<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Chat_v2 extends CI_Controller {
    
    public function __construct() {
        parent::__construct();
        
        if (!$this->session->userdata('admin_logged_in')) {
            redirect('admin/login');
        }
        
        $this->load->model('Chat_system_model');
        $this->load->helper('url');
    }
    
    // Main chat interface (two-panel layout)
    public function index() {
        $admin_id = $this->session->userdata('admin_id');
        $admin_name = $this->session->userdata('admin_name');
        
        // Check subscription if needed
        $data['subscription_active'] = true;
        
        $data['admin_info'] = [
            'id' => $admin_id,
            'name' => $admin_name,
            'type' => 'admin'
        ];
        
        $data['title'] = 'Chat - Admin Panel';
        $data['websocket_url'] = 'localhost:3001';
        
        $this->load->view('admin/chat_v2/index', $data);
    }
    
    // API: Get conversations for left panel
    public function get_conversations() {
        header('Content-Type: application/json');
        
        $admin_id = $this->session->userdata('admin_id');
        $conversations = $this->Chat_system_model->get_admin_conversations($admin_id);
        
        echo json_encode([
            'status' => true,
            'conversations' => $conversations
        ]);
    }
    
    // API: Get messages for a conversation
    public function get_messages() {
        header('Content-Type: application/json');
        
        $admin_id = $this->session->userdata('admin_id');
        $penghuni_id = $this->input->get('penghuni_id');
        
        if (!$penghuni_id) {
            echo json_encode(['status' => false, 'message' => 'Penghuni ID required']);
            return;
        }
        
        $messages = $this->Chat_system_model->get_conversation($admin_id, $penghuni_id, 100);
        
        echo json_encode([
            'status' => true,
            'messages' => $messages
        ]);
    }
    
    // API: Send message
    public function send_message() {
        header('Content-Type: application/json');
        
        $admin_id = $this->session->userdata('admin_id');
        $penghuni_id = $this->input->post('penghuni_id');
        $message = $this->input->post('message');
        
        if (!$penghuni_id || !$message) {
            echo json_encode(['status' => false, 'message' => 'Missing required data']);
            return;
        }
        
        $message_id = $this->Chat_system_model->send_message([
            'id_admin' => $admin_id,
            'id_penghuni' => $penghuni_id,
            'message' => $message,
            'sender' => 'admin',
            'is_read_admin' => 1,
            'is_read_penghuni' => 0
        ]);
        
        echo json_encode([
            'status' => true,
            'message_id' => $message_id
        ]);
    }
    
    // API: Mark messages as read
    public function mark_as_read() {
        header('Content-Type: application/json');
        
        $admin_id = $this->session->userdata('admin_id');
        $penghuni_id = $this->input->post('penghuni_id');
        
        if (!$penghuni_id) {
            echo json_encode(['status' => false, 'message' => 'Penghuni ID required']);
            return;
        }
        
        $updated = $this->Chat_system_model->mark_as_read($admin_id, $penghuni_id, 'admin');
        
        echo json_encode([
            'status' => true,
            'updated' => $updated
        ]);
    }
    
    // API: Get online status
    public function get_online_status($penghuni_id) {
        header('Content-Type: application/json');
        
        $admin_id = $this->session->userdata('admin_id');
        $status = $this->Chat_system_model->get_online_status($penghuni_id, $admin_id);
        
        echo json_encode([
            'status' => true,
            'is_online' => $status['is_online'],
            'last_seen' => $status['last_seen']
        ]);
    }
}


