<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Dashboard extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        if (!$this->session->userdata('admin_logged_in')) {
            redirect('admin/login');
        }
        $this->load->model('Chat_model');
        $this->load->model('admin/Kos_model');
        $this->load->model('admin/Laporan_model');
        $this->load->model('admin/Subscription_model');
        $this->load->model('admin/Admin_model');
        $this->load->model('superadmin/Report_model');
        $this->load->helper('url');
    }
    public function index()
    {
        $id_admin = $this->session->userdata('admin_id');
        $data['list_kos'] = $this->Kos_model->get_by_admin($id_admin);
        $data['list_penghuni'] = $this->Kos_model->get_all_penghuni_by_admin($id_admin);
        $total_laporan = 0;
        $total_pending = 0;
        $total_proses  = 0;
        $total_selesai = 0;
        foreach ($data['list_kos'] as $kos) {
            $total_laporan += $this->Laporan_model->count_all_by_kos($kos->id_kos);
            $total_pending += $this->Laporan_model->count_by_status_kos('Diajukan', $kos->id_kos);
            $total_proses  += $this->Laporan_model->count_by_status_kos('Diproses', $kos->id_kos);
            $total_selesai += $this->Laporan_model->count_by_status_kos('Selesai', $kos->id_kos);
        }
        $data['total_laporan']   = $total_laporan;
        $data['laporan_pending'] = $total_pending;
        $data['laporan_proses']  = $total_proses;
        $data['laporan_selesai'] = $total_selesai;
        $data['recent_activities'] = $this->Laporan_model->get_recent_activities_by_admin($id_admin, 10);
        $data['has_subscription'] = $this->Subscription_model->check_subscription($id_admin);
        $data['active_subscription'] = $this->Subscription_model->get_active_subscription($id_admin);
        $admin = $this->Admin_model->get($id_admin);
        $this->db->where('id_admin', $id_admin);
        $this->db->where('status !=', 'deleted');
        $this->db->where('created_at IS NOT NULL');
        $user_reports = $this->db->get('admin_reports')->result();
        $this->db->where('id_admin', $id_admin);
        $this->db->where('status', 'pending');
        $this->db->where('status !=', 'deleted');
        $pending_reports = $this->db->get('admin_reports')->result();
        $data['title'] = 'Dashboard Admin';
        $data['admin'] = $admin;
        $data['user_reports_count'] = count($user_reports);
        $data['pending_reports_count'] = count($pending_reports);
        $data['warning_count'] = $admin ? ($admin->warning_count ?? 0) : 0;
        $data['is_suspended'] = $admin ? ($admin->is_suspended ?? 0) : 0;
        $data['suspended_until'] = $admin ? ($admin->suspended_until ?? null) : null;
        $data['suspension_reason'] = $admin ? ($admin->suspension_reason ?? null) : null;
        if (!empty($user_reports)) {
            $this->db->select('ar.*, p.nama_penghuni, p.email as penghuni_email');
            $this->db->from('admin_reports ar');
            $this->db->join('penghuni p', 'p.id_penghuni = ar.id_penghuni');
            $this->db->where('ar.id_admin', $id_admin);
            $this->db->where('ar.status !=', 'deleted');
            $this->db->order_by('ar.created_at', 'DESC');
            $this->db->limit(5);
            $data['user_reports_list'] = $this->db->get()->result();
            $data['last_user_report'] = $user_reports[0]->created_at ?? null;
        } else {
            $data['user_reports_list'] = [];
            $data['last_user_report'] = null;
        }
        $data['total_penghuni'] = isset($data['list_penghuni']) ? count($data['list_penghuni']) : 0;
        $data['average_rating'] = 0;
        if (!empty($data['list_kos'])) {
            $total_rating = 0;
            $count_rating = 0;
            foreach ($data['list_kos'] as $kos) {
                $rating = $this->Kos_model->get_rating($kos->id_kos);
                if ($rating > 0) {
                    $total_rating += $rating;
                    $count_rating++;
                }
            }
            $data['average_rating'] = $count_rating > 0 ? $total_rating / $count_rating : 0;
        }
        echo '<div style="background: #fff3cd; padding: 20px; margin: 20px; border-radius: 10px; border: 2px solid #ffc107;">';
        echo '<h4>DEBUG DASHBOARD DATA</h4>';
        echo '<pre>';
        echo "User Reports Count: " . $data['user_reports_count'] . "\n";
        echo "Pending Reports: " . $data['pending_reports_count'] . "\n";
        echo "Warning Count: " . $data['warning_count'] . "\n";
        echo "Is Suspended: " . ($data['is_suspended'] ? 'YES' : 'NO') . "\n";
        echo "Suspended Until: " . ($data['suspended_until'] ? $data['suspended_until'] : 'NULL') . "\n";
        echo '</pre>';
        echo '</div>';

        $this->load->view('admin/dashboard', $data);
    }
    public function reset_all()
    {
        $id_admin = $this->session->userdata('admin_id');
        $this->db->where('id', $id_admin);
        $this->db->update('admin', [
            'warning_count' => 0,
            'is_suspended' => 0,
            'suspended_until' => NULL,
            'suspension_reason' => NULL
        ]);
        $this->db->where('id_admin', $id_admin);
        $this->db->delete('admin_reports');
        $this->db->where('id_admin', $id_admin);
        $this->db->delete('admin_suspensions');
        $this->db->where('admin_id', $id_admin);
        $this->db->delete('admin_suspend_logs');
        $this->session->set_flashdata('success', 'Semua data peringatan dan suspension telah direset!');
        redirect('admin/dashboard');
    }
    public function set_kos($id_kos)
    {
        $list_kos = $this->session->userdata('list_kos');
        $valid = false;
        if (!empty($list_kos)) {
            foreach ($list_kos as $kos) {
                if ($kos->id_kos == $id_kos) {
                    $valid = true;
                    break;
                }
            }
        }
        if ($valid) {
            $this->session->set_userdata('id_kos', $id_kos);
            $this->session->set_flashdata('success', 'Kos aktif berhasil diganti.');
        } else {
            $this->session->set_flashdata('error', 'Kos tidak valid untuk admin ini.');
        }
        redirect('admin/dashboard');
    }
}
