<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Penghuni extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('admin/Penghuni_model');
        $this->load->library(['session', 'form_validation']);
        $this->load->helper(['url', 'form']);

        // Pastikan admin login
        if (!$this->session->userdata('admin_logged_in')) {
            redirect('admin/login');
        }
    }

    // Tampilkan daftar penghuni (hanya dari kos admin login)
    public function index()
    {
        $this->load->model('admin/Kos_model');
        $id_admin = $this->session->userdata('admin_id'); // ambil ID admin login

        $data['title'] = 'Data Penghuni - SistemKOS';

        // 🔹 Ambil semua kos milik admin
        $kos_admin = $this->Kos_model->get_by_admin($id_admin);

        // 🔹 Ambil semua penghuni dari semua kos admin
        $data['penghuni'] = [];
        foreach ($kos_admin as $kos) {
            $penghuni_kos = $this->Penghuni_model->get_all_by_kos($kos->id_kos);
            $data['penghuni'] = array_merge($data['penghuni'], $penghuni_kos);
        }

        // Tambahkan nama kos aktif untuk tampilan info (opsional)
        $data['nama_kos_aktif'] = 'Semua Kos Milik Anda';

        $this->load->view('admin/penghuni/index', $data);
    }


    // Form tambah penghuni
    public function tambah()
    {
        $data['title'] = 'Tambah Penghuni';
        $this->load->view('admin/penghuni/form', $data);
    }

    // Simpan penghuni baru (otomatis ikut id_kos admin login)
    public function simpan()
    {
        $this->form_validation->set_rules('nama_penghuni', 'Nama', 'required');
        $this->form_validation->set_rules('email', 'Email', 'required|valid_email|is_unique[penghuni.email]');
        $this->form_validation->set_rules('password', 'Password', 'required|min_length[6]');

        if ($this->form_validation->run() == FALSE) {
            $this->tambah();
        } else {
            $data = [
                'nama_penghuni' => $this->input->post('nama_penghuni', true),
                'email' => $this->input->post('email', true),
                'password' => password_hash($this->input->post('password', true), PASSWORD_BCRYPT),
                'no_hp' => $this->input->post('no_hp', true),
                'kamar' => $this->input->post('kamar', true),
                'alamat' => $this->input->post('alamat', true),
                'id_kos' => $this->session->userdata('id_kos') // 🔹 otomatis ambil dari admin login
            ];

            $this->Penghuni_model->insert($data);
            $this->session->set_flashdata('success', 'Penghuni berhasil ditambahkan.');
            redirect('admin/penghuni');
        }
    }

    // Edit penghuni
    public function edit($id)
    {
        $data['penghuni'] = $this->Penghuni_model->get_by_id($id);
        if (!$data['penghuni']) show_404();
        $data['title'] = 'Edit Penghuni';
        $this->load->view('admin/penghuni/form', $data);
    }

    // Update data penghuni
    public function update($id)
    {
        $data_lama = $this->Penghuni_model->get_by_id($id);
        if (!$data_lama) show_404();

        $this->form_validation->set_rules('nama_penghuni', 'Nama', 'required');
        $this->form_validation->set_rules('email', 'Email', 'required|valid_email');

        if ($this->form_validation->run() == FALSE) {
            $this->edit($id);
        } else {
            $data = [
                'nama_penghuni' => $this->input->post('nama_penghuni', true),
                'email' => $this->input->post('email', true),
                'no_hp' => $this->input->post('no_hp', true),
                'kamar' => $this->input->post('kamar', true),
                'alamat' => $this->input->post('alamat', true),
                'id_kos' => $this->session->userdata('id_kos') // 🔹 tetap set biar sesuai kos admin login
            ];

            // Jika password diisi baru, update
            if ($this->input->post('password')) {
                $data['password'] = password_hash($this->input->post('password', true), PASSWORD_BCRYPT);
            }

            $this->Penghuni_model->update($id, $data);
            $this->session->set_flashdata('success', 'Data penghuni berhasil diperbarui.');
            redirect('admin/penghuni');
        }
    }

    // Hapus penghuni
    public function hapus($id)
    {
        $this->Penghuni_model->delete($id);
        $this->session->set_flashdata('success', 'Penghuni berhasil dihapus.');
        redirect('admin/penghuni');
    }
}
