
<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Chat_v2 extends CI_Controller {
    
    public function __construct() {
        parent::__construct();
        
        if (!$this->session->userdata('user_logged_in')) {
            redirect('user/login');
        }
        
        $this->load->model('Chat_system_model');
        $this->load->helper('url');
    }
    
    // User chat bubble interface
    public function index() {
        $penghuni_id = $this->session->userdata('user_id');
        $penghuni_name = $this->session->userdata('user_name');
        
        // Get admin info for this penghuni
        $penghuni = $this->db->select('id_admin')
            ->from('penghuni')
            ->where('id_penghuni', $penghuni_id)
            ->get()
            ->row();
        
        if (!$penghuni || !$penghuni->id_admin) {
            show_error('Anda belum terdaftar di kos manapun.');
        }
        
        $admin = $this->db->select('id, nama')
            ->from('admin')
            ->where('id', $penghuni->id_admin)
            ->get()
            ->row();
        
        $data['user_info'] = [
            'id' => $penghuni_id,
            'name' => $penghuni_name,
            'type' => 'penghuni'
        ];
        
        $data['admin_info'] = [
            'id' => $admin->id,
            'name' => $admin->nama
        ];
        
        $data['title'] = 'Chat dengan Admin';
        $data['websocket_url'] = 'localhost:3001';
        
        $this->load->view('user/chat_v2/index', $data);
    }
    
    // API: Get messages
    public function get_messages() {
        header('Content-Type: application/json');
        
        $penghuni_id = $this->session->userdata('user_id');
        
        // Get admin id from penghuni
        $penghuni = $this->db->select('id_admin')
            ->from('penghuni')
            ->where('id_penghuni', $penghuni_id)
            ->get()
            ->row();
        
        if (!$penghuni) {
            echo json_encode(['status' => false, 'message' => 'Penghuni not found']);
            return;
        }
        
        $messages = $this->Chat_system_model->get_conversation($penghuni->id_admin, $penghuni_id, 100);
        
        echo json_encode([
            'status' => true,
            'messages' => $messages
        ]);
    }
    
    // API: Send message
    public function send_message() {
        header('Content-Type: application/json');
        
        $penghuni_id = $this->session->userdata('user_id');
        $message = $this->input->post('message');
        
        if (!$message) {
            echo json_encode(['status' => false, 'message' => 'Message required']);
            return;
        }
        
        // Get admin id from penghuni
        $penghuni = $this->db->select('id_admin')
            ->from('penghuni')
            ->where('id_penghuni', $penghuni_id)
            ->get()
            ->row();
        
        if (!$penghuni) {
            echo json_encode(['status' => false, 'message' => 'Penghuni not found']);
            return;
        }
        
        $message_id = $this->Chat_system_model->send_message([
            'id_admin' => $penghuni->id_admin,
            'id_penghuni' => $penghuni_id,
            'message' => $message,
            'sender' => 'penghuni',
            'is_read_admin' => 0,
            'is_read_penghuni' => 1
        ]);
        
        echo json_encode([
            'status' => true,
            'message_id' => $message_id
        ]);
    }
    
    // API: Mark messages as read
    public function mark_as_read() {
        header('Content-Type: application/json');
        
        $penghuni_id = $this->session->userdata('user_id');
        
        // Get admin id from penghuni
        $penghuni = $this->db->select('id_admin')
            ->from('penghuni')
            ->where('id_penghuni', $penghuni_id)
            ->get()
            ->row();
        
        if (!$penghuni) {
            echo json_encode(['status' => false, 'message' => 'Penghuni not found']);
            return;
        }
        
        $updated = $this->Chat_system_model->mark_as_read($penghuni->id_admin, $penghuni_id, 'penghuni');
        
        echo json_encode([
            'status' => true,
            'updated' => $updated
        ]);
    }
}