<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Detaillaporan extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('user/Detaillaporan_model', 'detaillaporan');
        $this->load->helper(['url', 'form']);
        $this->load->library('session');
    }

    // Menampilkan detail laporan berdasarkan ID
    public function index($id_laporan)
    {
        // Ambil data laporan utama
        $data['laporan'] = $this->detaillaporan->getLaporanById($id_laporan);

        // Ambil detail laporan (riwayat progress)
        $data['detail'] = $this->detaillaporan->getDetailByLaporan($id_laporan);

        if (!$data['laporan']) {
            show_404();
        }

        $data['title'] = 'Detail Laporan';

        $this->load->view('user/dashboard/detail', $data);
    }

    // Tambah detail laporan baru (misalnya oleh admin / penghuni)
    public function tambah()
    {
        $id_laporan = $this->input->post('id_laporan');
        $id_penghuni = $this->session->userdata('id_penghuni'); // jika penghuni login
        $keterangan = $this->input->post('keterangan');
        $status = $this->input->post('status');

        $data = [
            'id_laporan' => $id_laporan,
            'id_penghuni' => $id_penghuni,
            'keterangan' => $keterangan,
            'status' => $status,
        ];

        $this->detaillaporan->insertDetail($data);

        // Update status di tabel laporan juga
        $this->detaillaporan->updateStatusLaporan($id_laporan, $status);

        $this->session->set_flashdata('success', 'Detail laporan berhasil ditambahkan!');
        redirect('user/detaillaporan/index/'.$id_laporan);
    }
}
