<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Kos_model extends CI_Model
{
    protected $table = 'kos';

    public function get_all()
    {
        // Asumsi: tabel admin memiliki primary key 'id' (bukan 'id_admin')
        $this->db->select('kos.*, admin.nama as nama_admin');
        $this->db->from($this->table);
        $this->db->join('admin', 'admin.id = kos.id_admin', 'left');
        return $this->db->get()->result();
    }

    public function get($id)
    {
        $this->db->select('kos.*, admin.nama as nama_admin');
        $this->db->from($this->table);
        $this->db->join('admin', 'admin.id = kos.id_admin', 'left');
        $this->db->where('kos.id_kos', $id);
        return $this->db->get()->row();
    }

    public function count_all()
    {
        return $this->db->count_all($this->table);
    }

    public function insert($data)
    {
        $this->db->insert($this->table, $data);
        return $this->db->insert_id();
    }

    public function update($id, $data)
    {
        $this->db->where('id_kos', $id);
        return $this->db->update($this->table, $data);
    }

    public function delete($id)
    {
        return $this->db->delete($this->table, ['id_kos' => $id]);
    }
}