<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Report_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
    }

    // Get all reports with admin and penghuni details
    public function get_all()
    {
        $this->db->select('r.*, 
                          a.nama as admin_nama, 
                          a.email as admin_email,
                          p.nama_penghuni,
                          p.email as penghuni_email');
        $this->db->from('reports r');
        $this->db->join('admin a', 'a.id = r.id_admin', 'left');
        $this->db->join('penghuni p', 'p.id_penghuni = r.id_penghuni', 'left');
        $this->db->order_by('r.created_at', 'DESC');
        return $this->db->get()->result();
    }

    // Get report by ID
    public function get($id)
    {
        $this->db->select('r.*, 
                          a.nama as admin_nama, 
                          a.email as admin_email,
                          p.nama_penghuni,
                          p.email as penghuni_email');
        $this->db->from('reports r');
        $this->db->join('admin a', 'a.id = r.id_admin', 'left');
        $this->db->join('penghuni p', 'p.id_penghuni = r.id_penghuni', 'left');
        $this->db->where('r.id_report', $id);
        return $this->db->get()->row();
    }

    // Update report status and action
    public function update_report($id, $data)
    {
        $this->db->where('id_report', $id);
        return $this->db->update('reports', $data);
    }

    // Count reports by status
    public function count_by_status($status)
    {
        $this->db->where('status', $status);
        return $this->db->count_all_results('reports');
    }

    // Get reports by admin ID - METHOD PERTAMA (simple)
    public function get_by_admin($admin_id)
    {
        $this->db->where('id_admin', $admin_id);
        $this->db->order_by('created_at', 'DESC');
        return $this->db->get('reports')->result();
    }

    // Count total reports
    public function count_all()
    {
        return $this->db->count_all('reports');
    }

    // Get reports by admin ID with details - METHOD KEDUA (with penghuni details)
    public function get_by_admin_with_details($admin_id, $status = null)
    {
        $this->db->select('r.*, p.nama_penghuni, p.email as penghuni_email');
        $this->db->from('reports r');
        $this->db->join('penghuni p', 'p.id_penghuni = r.id_penghuni', 'left');
        $this->db->where('r.id_admin', $admin_id);

        if ($status) {
            $this->db->where('r.status', $status);
        }

        $this->db->order_by('r.created_at', 'DESC');
        return $this->db->get()->result();
    }

    // Get limited reports by admin
    public function get_by_admin_limit($admin_id, $limit = 5)
    {
        $this->db->select('r.*, p.nama_penghuni, p.email as penghuni_email');
        $this->db->from('reports r');
        $this->db->join('penghuni p', 'p.id_penghuni = r.id_penghuni', 'left');
        $this->db->where('r.id_admin', $admin_id);
        $this->db->order_by('r.created_at', 'DESC');
        $this->db->limit($limit);
        return $this->db->get()->result();
    }

    // Get last report by admin
    public function get_last_by_admin($admin_id)
    {
        $this->db->select('created_at');
        $this->db->where('id_admin', $admin_id);
        $this->db->order_by('created_at', 'DESC');
        $this->db->limit(1);
        $result = $this->db->get('reports')->row();
        return $result ? $result->created_at : null;
    }

    // Count reports by admin
    public function count_by_admin($admin_id)
    {
        $this->db->where('id_admin', $admin_id);
        return $this->db->count_all_results('reports');
    }

    // Count reports by admin and status
    public function count_by_admin_status($admin_id, $status)
    {
        $this->db->where('id_admin', $admin_id);
        $this->db->where('status', $status);
        return $this->db->count_all_results('reports');
    }

    public function get_pending_count_by_admin($admin_id)
    {
        $this->db->where('id_admin', $admin_id);
        $this->db->where('status', 'pending');
        return $this->db->count_all_results('reports');
    }

    // TAMBAHKAN METHOD INI untuk compatibilitas
    public function get_recent_user_reports($admin_id, $limit = 5)
    {
        return $this->get_by_admin_limit($admin_id, $limit);
    }
}
