<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Penghuni_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }

    // Ambil semua data penghuni
    public function get_all() {
        return $this->db->get('penghuni')->result();
    }

    // 🔹 Ambil semua penghuni berdasarkan id_kos (khusus admin login)
    public function get_all_by_kos($id_kos) {
        $this->db->select('penghuni.*, kos.nama_kos'); // ✅ ambil nama_kos juga
        $this->db->from('penghuni');
        $this->db->join('kos', 'penghuni.id_kos = kos.id_kos', 'left'); // ✅ join tabel kos
        $this->db->where('penghuni.id_kos', $id_kos);
        return $this->db->get()->result();
    }

    // Ambil berdasarkan ID
    public function get_by_id($id) {
        return $this->db->get_where('penghuni', ['id_penghuni' => $id])->row();
    }

    // Simpan data baru
    public function insert($data) {
        return $this->db->insert('penghuni', $data);
    }

    // Update data
    public function update($id, $data) {
        $this->db->where('id_penghuni', $id);
        return $this->db->update('penghuni', $data);
    }

    // Hapus data
    public function delete($id) {
        return $this->db->delete('penghuni', ['id_penghuni' => $id]);
    }

    // Cek email unik
    public function get_by_email($email) {
        return $this->db->get_where('penghuni', ['email' => $email])->row();
    }
}
