<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Detaillaporan_model extends CI_Model {

    // Ambil data laporan berdasarkan ID
    public function getLaporanById($id_laporan)
    {
        $this->db->select('
            laporan.*, 
            penghuni.nama_penghuni, 
            kos.nama_kos, 
            kos.alamat
        ');
        $this->db->from('laporan');
        $this->db->join('penghuni', 'laporan.id_penghuni = penghuni.id_penghuni', 'left');
        $this->db->join('kos', 'laporan.id_kos = kos.id_kos', 'left');
        $this->db->where('laporan.id_laporan', $id_laporan);
        return $this->db->get()->row_array();
    }

    // Ambil seluruh detail dari laporan tertentu
    public function getDetailByLaporan($id_laporan)
    {
        $this->db->select('
            detail_laporan.*, 
            penghuni.nama_penghuni
        ');
        $this->db->from('detail_laporan');
        $this->db->join('penghuni', 'detail_laporan.id_penghuni = penghuni.id_penghuni', 'left');
        $this->db->where('detail_laporan.id_laporan', $id_laporan);
        $this->db->order_by('detail_laporan.tanggal_update', 'ASC');
        return $this->db->get()->result_array();
    }

    // Tambah detail laporan baru
    public function insertDetail($data)
    {
        return $this->db->insert('detail_laporan', $data);
    }

    // Update status laporan utama
    public function updateStatusLaporan($id_laporan, $status)
    {
        $this->db->where('id_laporan', $id_laporan);
        return $this->db->update('laporan', ['status' => $status]);
    }
}
