<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Penghuni_model extends CI_Model
{
    private $table = 'penghuni';
    public function __construct()
    {
        parent::__construct();
    }
    public function insert_penghuni($data)
    {
        $this->db->insert($this->table, $data);
        return $this->db->insert_id();
    }
    public function email_exists($email)
    {
        $this->db->where('email', $email);
        $query = $this->db->get($this->table);
        return $query->num_rows() > 0;
    }
    public function kamar_exists($kamar)
    {
        $this->db->where('kamar', $kamar);
        $query = $this->db->get($this->table);
        return $query->num_rows() > 0;
    }
    public function kamar_exists_in_kos($kamar, $id_kos)
    {
        $this->db->where('kamar', $kamar);
        $this->db->where('id_kos', $id_kos);
        $query = $this->db->get($this->table);
        return $query->num_rows() > 0;
    }
    public function get_occupied_kamar()
    {
        $this->db->select('kamar');
        $this->db->where('kamar IS NOT NULL');
        $this->db->where('kamar !=', '');
        $query = $this->db->get($this->table);

        $occupied = [];
        foreach ($query->result() as $row) {
            $occupied[] = $row->kamar;
        }
        return $occupied;
    }
    public function get_occupied_kamar_by_kos($id_kos)
    {
        $this->db->select('kamar');
        $this->db->where('id_kos', $id_kos);
        $this->db->where('kamar IS NOT NULL');
        $this->db->where('kamar !=', '');
        $query = $this->db->get($this->table);
        $occupied = [];
        foreach ($query->result() as $row) {
            $occupied[] = $row->kamar;
        }

        return $occupied;
    }
    public function get_by_email($email)
    {
        $this->db->where('email', $email);
        $query = $this->db->get($this->table);
        return $query->row();
    }
    public function get_by_id($id)
    {
        $this->db->where('id_penghuni', $id);
        $query = $this->db->get($this->table);
        return $query->row();
    }
    public function get_all()
    {
        $this->db->order_by('created_at', 'DESC');
        $query = $this->db->get($this->table);
        return $query->result();
    }
    public function update_penghuni($id, $data)
    {
        $this->db->where('id_penghuni', $id);
        return $this->db->update($this->table, $data);
    }
    public function delete_penghuni($id)
    {
        $this->db->where('id_penghuni', $id);
        return $this->db->delete($this->table);
    }
    public function count_all()
    {
        return $this->db->count_all($this->table);
    }
    public function get_by_kamar($kamar)
    {
        $this->db->where('kamar', $kamar);
        $query = $this->db->get($this->table);
        return $query->row();
    }
    public function search($keyword)
    {
        $this->db->like('nama_penghuni', $keyword);
        $this->db->or_like('kamar', $keyword);
        $this->db->or_like('email', $keyword);
        $query = $this->db->get($this->table);
        return $query->result();
    }
    public function get_paginated($limit, $offset)
    {
        $this->db->limit($limit, $offset);
        $this->db->order_by('created_at', 'DESC');
        $query = $this->db->get($this->table);
        return $query->result();
    }
    public function get_with_kos_admin($id_penghuni = null)
    {
        $this->db->select('penghuni.*, kos.nama_kos, kos.alamat as alamat_kos, kos.jumlah_kamar, admin.nama as nama_admin');
        $this->db->from('penghuni');
        $this->db->join('kos', 'penghuni.id_kos = kos.id_kos', 'left');
        $this->db->join('admin', 'penghuni.id_admin = admin.id', 'left');

        if ($id_penghuni) {
            $this->db->where('penghuni.id_penghuni', $id_penghuni);
            return $this->db->get()->row();
        }

        $this->db->order_by('penghuni.created_at', 'DESC');
        return $this->db->get()->result();
    }
    public function get_by_admin($id_admin)
    {
        $this->db->where('id_admin', $id_admin);
        $this->db->order_by('created_at', 'DESC');
        $query = $this->db->get($this->table);
        return $query->result();
    }
    public function get_by_kos($id_kos)
    {
        $this->db->where('id_kos', $id_kos);
        $this->db->order_by('kamar', 'ASC');
        $query = $this->db->get($this->table);
        return $query->result();
    }
}
