<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Profile_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
        $this->load->database();
    }

    // Get user by ID
    public function get_user_by_id($user_id)
    {
        $this->db->select('penghuni.*, kos.nama_kos'); // Tambah kolom nama_kos
        $this->db->from('penghuni');
        $this->db->join('kos', 'kos.id_kos = penghuni.id_kos', 'left');
        $this->db->where('penghuni.id_penghuni', $user_id);
        $query = $this->db->get();
        return $query->row();
    }


    // Update user profile
    public function update_user($user_id, $data)
    {
        $this->db->where('id_penghuni', $user_id);
        return $this->db->update('penghuni', $data);
    }

    // Check if email already exists (exclude current user)
    public function check_email_exists($email, $user_id)
    {
        $this->db->where('email', $email);
        $this->db->where('id_penghuni !=', $user_id);
        $query = $this->db->get('penghuni');
        return $query->num_rows() > 0;
    }

    // Insert permintaan pindah kamar
    public function insert_permintaan_pindah($data)
    {
        return $this->db->insert('permintaan_pindah_kamar', $data);
    }

    // Get permintaan pindah kamar by user
    public function get_permintaan_by_user($user_id)
    {
        $this->db->where('id_penghuni', $user_id);
        $this->db->order_by('tanggal_pengajuan', 'DESC');
        $query = $this->db->get('permintaan_pindah_kamar');
        return $query->result();
    }

    // Check if user has pending request
    public function has_pending_request($user_id)
    {
        $this->db->where('id_penghuni', $user_id);
        $this->db->where('status', 'Menunggu');
        $query = $this->db->get('permintaan_pindah_kamar');
        return $query->num_rows() > 0;
    }
}
