<?php
defined('BASEPATH') or exit('No direct script access allowed');

class User_model extends CI_Model
{
    private $table = 'penghuni';

    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Get user by email (untuk login)
     */
    public function get_by_email($email)
    {
        $this->db->where('email', $email);
        $query = $this->db->get($this->table);
        return $query->row();
    }

    /**
     * Get user by ID
     */
    public function get_by_id($id)
    {
        $this->db->where('id_penghuni', $id);
        $query = $this->db->get($this->table);
        return $query->row();
    }

    /**
     * Update user profile
     */
    public function update_user($id, $data)
    {
        $this->db->where('id_penghuni', $id);
        return $this->db->update($this->table, $data);
    }

    /**
     * Check if email exists
     */
    public function email_exists($email)
    {
        $this->db->where('email', $email);
        $query = $this->db->get($this->table);
        return $query->num_rows() > 0;
    }

    /**
     * Get all users
     */
    public function get_all_users()
    {
        $query = $this->db->get($this->table);
        return $query->result();
    }

    /* ==========================================================
     * TAMBAHAN: FITUR PILIH KOS UNTUK PENGHUNI
     * ==========================================================
     */

    /**
     * Ambil semua kos yang aktif
     */
    public function get_all_kos()
    {
        $this->db->select('id_kos, nama_kos, alamat');
        $this->db->from('kos');
        $this->db->where('status', 'Aktif');
        return $this->db->get()->result();
    }

    /**
     * Simpan pilihan kos ke penghuni
     */
    public function set_kos($id_penghuni, $id_kos)
    {
        $this->db->where('id_penghuni', $id_penghuni);
        return $this->db->update($this->table, ['id_kos' => $id_kos]);
    }

    /**
     * Ambil nama kos berdasarkan ID
     */
    public function get_kos_by_id($id_kos)
    {
        return $this->db->get_where('kos', ['id_kos' => $id_kos])->row();
    }

    /**
     * Ambil data penghuni beserta nama kos (join)
     */
    public function get_user_with_kos($id_penghuni)
    {
        $this->db->select('penghuni.*, kos.nama_kos, kos.alamat');
        $this->db->from('penghuni');
        $this->db->join('kos', 'penghuni.id_kos = kos.id_kos', 'left');
        $this->db->where('penghuni.id_penghuni', $id_penghuni);
        return $this->db->get()->row();
    }

    /* ==========================================================
     * FITUR RESET PASSWORD
     * ==========================================================
     */

    /**
     * Generate and save reset token
     */
    public function generate_reset_token($email)
    {
        // Generate random token
        $token = bin2hex(random_bytes(50)); // 100 karakter hex
        $expiry = date('Y-m-d H:i:s', strtotime('+1 hour')); // Token berlaku 1 jam

        $this->db->where('email', $email);
        $this->db->update($this->table, [
            'reset_token' => $token,
            'reset_token_expiry' => $expiry
        ]);

        return $token;
    }

    /**
     * Validate reset token
     */
    public function validate_reset_token($token)
    {
        $this->db->where('reset_token', $token);
        $this->db->where('reset_token_expiry >=', date('Y-m-d H:i:s'));
        $query = $this->db->get($this->table);

        return $query->row();
    }

    /**
     * Reset password dengan token
     */
    public function reset_password($token, $new_password)
    {
        $hashed_password = password_hash($new_password, PASSWORD_DEFAULT);

        $this->db->where('reset_token', $token);
        $this->db->where('reset_token_expiry >=', date('Y-m-d H:i:s'));

        return $this->db->update($this->table, [
            'password' => $hashed_password,
            'reset_token' => null,
            'reset_token_expiry' => null
        ]);
    }

    /**
     * Clear expired tokens (opsional, bisa dijadikan cron job)
     */
    public function clear_expired_tokens()
    {
        $this->db->where('reset_token_expiry <', date('Y-m-d H:i:s'));
        $this->db->where('reset_token IS NOT NULL', null, false);

        return $this->db->update($this->table, [
            'reset_token' => null,
            'reset_token_expiry' => null
        ]);
    }

    /**
     * Get user by reset token
     */
    public function get_by_reset_token($token)
    {
        $this->db->where('reset_token', $token);
        $query = $this->db->get($this->table);
        return $query->row();
    }
}
