<?php
// Check subscription status - data passed from controller
// Variables: $has_subscription, $active_subscription
?>
<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title><?= $title ?></title>
  <link rel="stylesheet" href="<?= base_url('asset/css/bootstrap.min.css') ?>">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }

    body {
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      background: #f0f8ff;
      color: #333;
    }

    /* TOPBAR IMPROVED */
    .topbar {
      background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
      padding: 12px 0;
      box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
      position: fixed;
      top: 0;
      left: 0;
      right: 0;
      z-index: 1030;
      height: 60px;
    }

    .topbar-container {
      display: flex;
      justify-content: space-between;
      align-items: center;
      height: 100%;
      padding: 0 15px;
    }

    .brand-section {
      display: flex;
      align-items: center;
      gap: 15px;
      flex-shrink: 0;
    }

    .brand-logo {
      width: 50px;
      height: auto;
      transition: transform 0.3s;
    }

    .brand-logo:hover {
      transform: scale(1.05);
    }

    .brand-text {
      color: white;
    }

    .brand-text h4 {
      font-weight: 600;
      font-size: 1.3rem;
      margin: 0;
      line-height: 1.2;
    }

    .brand-text span {
      font-size: 0.9rem;
      opacity: 0.9;
      display: block;
      margin-top: 2px;
    }

    .user-section {
      display: flex;
      align-items: center;
      gap: 15px;
      flex-shrink: 0;
    }

    .user-info {
      display: flex;
      align-items: center;
      gap: 8px;
      color: white;
      font-size: 0.95rem;
      padding: 6px 12px;
      border-radius: 6px;
      transition: background 0.3s;
    }

    .user-info:hover {
      background: rgba(255, 255, 255, 0.1);
    }

    .user-info i {
      font-size: 1.2rem;
    }

    .logout-btn {
      display: flex;
      align-items: center;
      gap: 8px;
      color: white;
      text-decoration: none;
      padding: 8px 16px;
      border-radius: 6px;
      background: rgba(255, 255, 255, 0.15);
      transition: all 0.3s;
      font-size: 0.9rem;
      font-weight: 500;
    }

    .logout-btn:hover {
      background: rgba(255, 255, 255, 0.25);
      transform: translateY(-1px);
      color: white;
    }

    /* SIDEBAR STYLES */
    .sidebar {
      background: white;
      min-height: calc(100vh - 60px);
      padding: 25px 15px;
      box-shadow: 2px 0 10px rgba(0, 0, 0, 0.05);
      position: fixed;
      top: 60px;
      left: 0;
      width: 16.666667%;
      height: calc(100vh - 60px);
      overflow-y: auto;
      z-index: 1020;
    }

    .sidebar h5 {
      color: #4a90e2;
      margin-bottom: 20px;
      font-weight: 600;
      padding-bottom: 10px;
      border-bottom: 2px solid #e3f2fd;
    }

    .sidebar ul {
      list-style: none;
    }

    .sidebar ul li {
      margin-bottom: 8px;
    }

    .sidebar ul li a {
      display: block;
      padding: 12px 15px;
      color: #555;
      text-decoration: none;
      border-radius: 8px;
      transition: all 0.3s;
      font-size: 0.95rem;
    }

    .sidebar ul li a:hover,
    .sidebar ul li a.active {
      background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
      color: white;
      transform: translateX(5px);
    }

    .sidebar ul li a i {
      width: 20px;
      margin-right: 10px;
    }

    /* MAIN CONTENT */
    .main-content {
      margin-left: 16.666667%;
      margin-top: 60px;
      padding: 25px;
      background: #f0f8ff;
      min-height: calc(100vh - 60px);
    }

    .page-header {
      background: white;
      padding: 25px;
      border-radius: 12px;
      margin-bottom: 25px;
      box-shadow: 0 4px 15px rgba(0, 0, 0, 0.08);
    }

    .page-header h4 {
      color: #4a90e2;
      margin: 0;
      font-weight: 600;
    }

    .page-header p {
      color: #888;
      margin: 5px 0 0;
    }

    /* ALERT STYLES */
    .alert {
      border-radius: 10px;
      border: none;
      padding: 15px 20px;
      margin-bottom: 20px;
      animation: slideDown 0.3s ease-out;
      display: flex;
      align-items: center;
      gap: 10px;
    }

    @keyframes slideDown {
      from {
        opacity: 0;
        transform: translateY(-20px);
      }
      to {
        opacity: 1;
        transform: translateY(0);
      }
    }

    .alert-success {
      background: #d4edda;
      color: #155724;
      border-left: 4px solid #28a745;
    }

    .alert-danger {
      background: #f8d7da;
      color: #721c24;
      border-left: 4px solid #dc3545;
    }

    /* TABLE CARD */
    .table-card {
      background: white;
      border-radius: 12px;
      padding: 25px;
      box-shadow: 0 4px 15px rgba(0, 0, 0, 0.08);
      overflow-x: auto;
    }

    .table-header {
      display: flex;
      justify-content: space-between;
      align-items: center;
      margin-bottom: 20px;
      flex-wrap: wrap;
      gap: 15px;
    }

    .table-header h5 {
      color: #4a90e2;
      margin: 0;
      font-weight: 600;
    }

    .btn-add {
      background: linear-gradient(135deg, #28a745 0%, #20893a 100%);
      color: white;
      border: none;
      padding: 10px 20px;
      border-radius: 8px;
      font-weight: 500;
      text-decoration: none;
      display: inline-flex;
      align-items: center;
      gap: 8px;
      transition: all 0.3s;
    }

    .btn-add:hover {
      transform: translateY(-2px);
      box-shadow: 0 5px 15px rgba(40, 167, 69, 0.3);
      color: white;
    }

    .custom-table {
      width: 100%;
      border-collapse: separate;
      border-spacing: 0;
      margin-top: 20px;
    }

    .custom-table thead tr {
      background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
      color: white;
    }

    .custom-table thead th {
      padding: 15px;
      text-align: left;
      font-weight: 600;
      font-size: 0.9rem;
      border: none;
    }

    .custom-table thead th:first-child {
      border-radius: 8px 0 0 0;
    }

    .custom-table thead th:last-child {
      border-radius: 0 8px 0 0;
    }

    .custom-table tbody tr {
      background: white;
      transition: all 0.3s;
      border-bottom: 1px solid #f0f0f0;
    }

    .custom-table tbody tr:hover {
      background: #f8fbff;
      transform: scale(1.01);
      box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
    }

    .custom-table tbody td {
      padding: 15px;
      font-size: 0.9rem;
      color: #555;
      vertical-align: middle;
    }

    .status-select {
      width: 100%;
      padding: 8px 12px;
      border: 2px solid #e3f2fd;
      border-radius: 8px;
      font-size: 0.85rem;
      transition: all 0.3s;
      cursor: pointer;
      background: white;
    }

    .status-select:focus {
      border-color: #4a90e2;
      outline: none;
      box-shadow: 0 0 0 3px rgba(74, 144, 226, 0.1);
    }

    .status-select option {
      padding: 10px;
    }

    .badge {
      padding: 6px 12px;
      border-radius: 20px;
      font-size: 0.8rem;
      font-weight: 500;
      display: inline-block;
    }

    .badge-diajukan {
      background: #fff3cd;
      color: #856404;
    }

    .badge-diproses {
      background: #cce5ff;
      color: #004085;
    }

    .badge-selesai {
      background: #d4edda;
      color: #155724;
    }

    .action-buttons {
      display: flex;
      gap: 5px;
    }

    .btn-action {
      padding: 8px 15px;
      border-radius: 6px;
      border: none;
      cursor: pointer;
      transition: all 0.3s;
      font-size: 0.85rem;
      text-decoration: none;
      display: inline-flex;
      align-items: center;
      gap: 5px;
      font-weight: 500;
    }

    .btn-detail {
      background: #17a2b8;
      color: white;
    }

    .btn-detail:hover {
      background: #138496;
      transform: translateY(-2px);
      color: white;
      box-shadow: 0 3px 10px rgba(23, 162, 184, 0.3);
    }

    .btn-delete {
      background: #dc3545;
      color: white;
    }

    .btn-delete:hover {
      background: #c82333;
      transform: translateY(-2px);
      color: white;
      box-shadow: 0 3px 10px rgba(220, 53, 69, 0.3);
    }

    .empty-state {
      text-align: center;
      padding: 60px 20px;
      color: #888;
    }

    .empty-state i {
      font-size: 5rem;
      color: #ddd;
      margin-bottom: 20px;
    }

    .empty-state h5 {
      color: #666;
      margin-bottom: 10px;
    }

    .empty-state p {
      color: #999;
    }

    /* SIDEBAR SCROLLBAR */
    .sidebar::-webkit-scrollbar {
      width: 6px;
    }

    .sidebar::-webkit-scrollbar-track {
      background: #f1f1f1;
    }

    .sidebar::-webkit-scrollbar-thumb {
      background: #4a90e2;
      border-radius: 3px;
    }

    .sidebar::-webkit-scrollbar-thumb:hover {
      background: #357abd;
    }

    /* RESPONSIVE DESIGN */
    @media (max-width: 992px) {
      .sidebar {
        width: 25%;
      }
      .main-content {
        margin-left: 25%;
      }
    }

    @media (max-width: 768px) {
      .sidebar {
        position: relative;
        width: 100%;
        height: auto;
        min-height: auto;
        top: 0;
      }
      
      .main-content {
        margin-left: 0;
        margin-top: 0;
        padding: 15px;
      }
      
      .topbar {
        height: auto;
        padding: 10px 0;
      }
      
      .topbar-container {
        flex-direction: column;
        gap: 10px;
        height: auto;
      }
      
      .brand-section, .user-section {
        width: 100%;
        justify-content: center;
      }
      
      .table-card {
        padding: 15px;
      }
      
      .custom-table {
        font-size: 0.8rem;
      }
      
      .custom-table thead th,
      .custom-table tbody td {
        padding: 10px;
      }
      
      .action-buttons {
        flex-direction: column;
      }
      
      .brand-text h4 {
        font-size: 1.1rem;
      }
      
      .brand-text span {
        font-size: 0.8rem;
      }
      
      .user-info, .logout-btn {
        font-size: 0.85rem;
      }
    }

    @media (max-width: 576px) {
      .search-box {
        flex-direction: column;
      }
      
      .search-box input,
      .search-box button {
        width: 100%;
      }
      
      .table-header {
        flex-direction: column;
        align-items: flex-start;
      }
      
      .custom-table {
        display: block;
        overflow-x: auto;
        white-space: nowrap;
      }
    }

    /* ANIMATIONS FOR ALERTS */
    @keyframes slideUp {
      from {
        opacity: 1;
        transform: translateY(0);
      }
      to {
        opacity: 0;
        transform: translateY(-20px);
      }
    }
  </style>
</head>

<body>
  <!-- TOPBAR IMPROVED -->
  <div class="topbar">
    <div class="container-fluid">
      <div class="topbar-container">
        <!-- Brand Section (Left) -->
        <div class="brand-section">
          <img src="<?= base_url('asset/logo 2.png'); ?>" alt="Logo KosCare" class="brand-logo">
          <div class="brand-text">
            <h4>KosCare</h4>
            <span>Dashboard Admin</span>
          </div>
        </div>
        
        <!-- User Section (Right) -->
        <div class="user-section">
          <div class="user-info">
            <i class="fas fa-user-circle"></i>
            <div>
              <span>Halo, <strong><?= $this->session->userdata('admin_name') ?></strong></span>
            </div>
          </div>
          <a href="<?= site_url('admin/login/logout') ?>" class="logout-btn">
            <i class="fas fa-sign-out-alt"></i> Logout
          </a>
        </div>
      </div>
    </div>
  </div>

  <!-- SIDEBAR -->
  <div class="sidebar" id="sidebar">
    <h5><i class="fas fa-bars"></i> Menu</h5>
    <ul>
      <li><a href="<?= site_url('admin/dashboard'); ?>"><i class="fas fa-tachometer-alt"></i> Dashboard</a></li>
      <li><a href="<?= site_url('admin/laporan'); ?>" class="active"><i class="fas fa-clipboard-list"></i> Laporan</a></li>
      <li><a href="<?= site_url('admin/penghuni'); ?>"><i class="fas fa-users"></i> Penghuni</a></li>
      <li><a href="<?= site_url('admin/iklan'); ?>"><i class="fas fa-bullhorn"></i> Iklan</a></li>
      <li><a href="<?= site_url('admin/kos'); ?>"><i class="fas fa-building"></i> Kos</a></li>
      <li><a href="<?= site_url('admin/pengaturan'); ?>"><i class="fas fa-cog"></i> Pengaturan</a></li>
    </ul>
  </div>

  <!-- MAIN CONTENT -->
  <div class="main-content">
    <div class="page-header">
      <h4><i class="fas fa-clipboard-list"></i> <?= $title ?></h4>
      <p>Kelola laporan keluhan dan permintaan dari penghuni</p>
    </div>

    <?php if ($this->session->flashdata('success')): ?>
      <div class="alert alert-success">
        <i class="fas fa-check-circle"></i>
        <?= $this->session->flashdata('success') ?>
      </div>
    <?php endif; ?>

    <?php if ($this->session->flashdata('error')): ?>
      <div class="alert alert-danger">
        <i class="fas fa-exclamation-circle"></i>
        <?= $this->session->flashdata('error') ?>
      </div>
    <?php endif; ?>

    <div class="table-card">
      <div class="table-header">
        <div>
          <h5><i class="fas fa-list"></i> Daftar Laporan</h5>
          <!-- TOMBOL TAMBAH LAPORAN DIHAPUS DARI SINI -->
        </div>
      </div>

      <?php if (empty($laporan)): ?>
        <div class="empty-state">
          <i class="fas fa-inbox"></i>
          <h5>Belum ada data laporan</h5>
          <p>Belum ada laporan yang dibuat oleh penghuni</p>
        </div>
      <?php else: ?>
        <table class="custom-table">
          <thead>
            <tr>
              <th style="width: 50px; text-align: center;">#</th>
              <th>Nama Penghuni</th>
              <th>Judul Laporan</th>
              <th style="width: 180px;">Status</th>
              <th style="width: 130px;">Tanggal</th>
              <th style="width: 180px; text-align: center;">Aksi</th>
            </tr>
          </thead>
          <tbody>
            <?php $no = 1;
            foreach ($laporan as $row): ?>
              <tr>
                <td style="text-align: center;"><strong><?= $no++ ?></strong></td>
                <td>
                  <i class="fas fa-user"></i> <?= $row->nama_penghuni ?>
                </td>
                <td><?= $row->judul ?></td>
                <td>
                  <form method="post" action="<?= site_url('admin/laporan/ubah_status/' . $row->id_laporan) ?>" style="margin: 0;">
                    <select name="status" class="status-select" onchange="if(confirm('Ubah status laporan ini?')) this.form.submit();">
                      <option value="Diajukan" <?= $row->status == 'Diajukan' ? 'selected' : '' ?>>📋 Diajukan</option>
                      <option value="Diproses" <?= $row->status == 'Diproses' ? 'selected' : '' ?>>⚙️ Diproses</option>
                      <option value="Selesai" <?= $row->status == 'Selesai' ? 'selected' : '' ?>>✅ Selesai</option>
                    </select>
                  </form>
                </td>
                <td>
                  <i class="far fa-calendar-alt"></i> <?= date('d M Y', strtotime($row->tanggal_laporan)) ?>
                </td>
                <td>
                  <div class="action-buttons">
                    <a href="<?= site_url('admin/laporan/detail/' . $row->id_laporan) ?>" class="btn-action btn-detail">
                      <i class="fas fa-eye"></i> Detail
                    </a>
                    <a href="<?= site_url('admin/laporan/hapus/' . $row->id_laporan) ?>"
                      class="btn-action btn-delete"
                      onclick="return confirm('Apakah Anda yakin ingin menghapus laporan ini?')">
                      <i class="fas fa-trash"></i> Hapus
                    </a>
                  </div>
                </td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      <?php endif; ?>
    </div>
  </div>

  <script src="<?= base_url('asset/js/jquery-3.6.0.min.js') ?>"></script>
  <script src="<?= base_url('asset/js/bootstrap.bundle.min.js') ?>"></script>

  <script>
    // Active menu highlight
    document.addEventListener('DOMContentLoaded', function() {
      const currentPath = window.location.pathname;
      document.querySelectorAll('.sidebar a').forEach(link => {
        link.classList.remove('active');
        if (link.getAttribute('href') && link.getAttribute('href').includes('laporan')) {
          link.classList.add('active');
        }
      });

      // Auto hide alerts after 5 seconds
      const alerts = document.querySelectorAll('.alert');
      alerts.forEach(alert => {
        setTimeout(() => {
          alert.style.animation = 'slideUp 0.3s ease-out';
          setTimeout(() => {
            alert.style.display = 'none';
          }, 300);
        }, 5000);
      });
    });

    // Add hover effects to logout button
    document.addEventListener('DOMContentLoaded', function() {
      const logoutBtn = document.querySelector('.logout-btn');
      if (logoutBtn) {
        logoutBtn.addEventListener('mouseenter', function() {
          this.style.transform = 'translateY(-1px) scale(1.02)';
        });
        logoutBtn.addEventListener('mouseleave', function() {
          this.style.transform = 'translateY(0) scale(1)';
        });
      }
    });

    // Smooth scroll to top after status change
    if (window.location.hash === '#status-updated') {
      window.scrollTo({
        top: 0,
        behavior: 'smooth'
      });
    }
  </script>
</body>
</html>