<?php
// Determine active menu based on current URL
$current_url = uri_string();
?>
<!doctype html>
<html>

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>Edit Iklan - SistemKOS</title>
    <link rel="stylesheet" href="<?php echo base_url('asset/css/bootstrap.min.css'); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: #f0f8ff;
            color: #333;
        }

        /* TOPBAR IMPROVED - SAME AS ADMIN */
        .topbar {
            background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
            padding: 12px 0;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            z-index: 1030;
            height: 60px;
        }

        .topbar-container {
            display: flex;
            justify-content: space-between;
            align-items: center;
            height: 100%;
            padding: 0 15px;
        }

        .brand-section {
            display: flex;
            align-items: center;
            gap: 15px;
            flex-shrink: 0;
        }

        .brand-logo {
            width: 50px;
            height: auto;
            transition: transform 0.3s;
        }

        .brand-logo:hover {
            transform: scale(1.05);
        }

        .brand-text {
            color: white;
        }

        .brand-text h4 {
            font-weight: 600;
            font-size: 1.3rem;
            margin: 0;
            line-height: 1.2;
        }

        .brand-text span {
            font-size: 0.9rem;
            opacity: 0.9;
            display: block;
            margin-top: 2px;
        }

        .user-section {
            display: flex;
            align-items: center;
            gap: 15px;
            flex-shrink: 0;
        }

        .user-info {
            display: flex;
            align-items: center;
            gap: 8px;
            color: white;
            font-size: 0.95rem;
            padding: 6px 12px;
            border-radius: 6px;
            transition: background 0.3s;
        }

        .user-info:hover {
            background: rgba(255, 255, 255, 0.1);
        }

        .user-info i {
            font-size: 1.2rem;
        }

        .logout-btn {
            display: flex;
            align-items: center;
            gap: 8px;
            color: white;
            text-decoration: none;
            padding: 8px 16px;
            border-radius: 6px;
            background: rgba(255, 255, 255, 0.15);
            transition: all 0.3s;
            font-size: 0.9rem;
            font-weight: 500;
        }

        .logout-btn:hover {
            background: rgba(255, 255, 255, 0.25);
            transform: translateY(-1px);
            color: white;
        }

        /* SIDEBAR STYLES */
        .sidebar {
            background: white;
            min-height: calc(100vh - 60px);
            padding: 25px 15px;
            box-shadow: 2px 0 10px rgba(0, 0, 0, 0.05);
            position: fixed;
            top: 60px;
            left: 0;
            width: 16.666667%;
            height: calc(100vh - 60px);
            overflow-y: auto;
            z-index: 1020;
        }

        .sidebar h5 {
            color: #4a90e2;
            margin-bottom: 20px;
            font-weight: 600;
            padding-bottom: 10px;
            border-bottom: 2px solid #e3f2fd;
        }

        .sidebar ul {
            list-style: none;
        }

        .sidebar ul li {
            margin-bottom: 8px;
        }

        .sidebar ul li a {
            display: block;
            padding: 12px 15px;
            color: #555;
            text-decoration: none;
            border-radius: 8px;
            transition: all 0.3s;
            font-size: 0.95rem;
            position: relative;
            overflow: hidden;
        }

        .sidebar ul li a:hover {
            background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
            color: white;
            transform: translateX(5px);
        }

        .sidebar ul li a.active {
            background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
            color: white;
            transform: translateX(5px);
            box-shadow: 0 4px 15px rgba(74, 144, 226, 0.3);
        }

        .sidebar ul li a.active:before {
            content: '';
            position: absolute;
            left: 0;
            top: 0;
            height: 100%;
            width: 4px;
            background: white;
            border-radius: 0 4px 4px 0;
        }

        .sidebar ul li a i {
            width: 20px;
            margin-right: 10px;
        }

        /* MAIN CONTENT */
        .main-content {
            margin-left: 16.666667%;
            margin-top: 60px;
            padding: 25px;
            background: #f0f8ff;
            min-height: calc(100vh - 60px);
        }

        .form-card {
            background: white;
            border-radius: 12px;
            padding: 30px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.08);
            margin-bottom: 20px;
        }

        .form-card h5 {
            color: #4a90e2;
            margin-bottom: 25px;
            font-weight: 600;
            font-size: 1.2rem;
            padding-bottom: 15px;
            border-bottom: 2px solid #e3f2fd;
        }

        .form-label {
            font-weight: 500;
            color: #555;
            margin-bottom: 8px;
            font-size: 0.95rem;
        }

        .form-label i {
            margin-right: 8px;
            color: #4a90e2;
        }

        .required {
            color: #dc3545;
        }

        .form-control,
        .form-select {
            border: 2px solid #e9ecef;
            border-radius: 8px;
            padding: 12px 15px;
            font-size: 0.95rem;
            transition: all 0.3s;
        }

        .form-control:focus,
        .form-select:focus {
            border-color: #4a90e2;
            box-shadow: 0 0 0 0.2rem rgba(74, 144, 226, 0.25);
        }

        textarea.form-control {
            min-height: 100px;
            resize: vertical;
        }

        /* GAMBAR SECTION - STYLE UNIFIED */
        .current-image-container {
            margin-top: 15px;
            padding: 20px;
            background: #f8fbff;
            border-radius: 8px;
            border: 2px solid #e3f2fd;
            text-align: center;
        }

        .current-image-container img {
            max-width: 100%;
            height: auto;
            border-radius: 8px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
            max-height: 200px;
        }

        .current-image-label {
            color: #4a90e2;
            font-weight: 600;
            margin-bottom: 15px;
            font-size: 0.9rem;
            display: block;
        }

        .preview-container {
            margin-top: 15px;
            padding: 15px;
            background: #f8fbff;
            border-radius: 8px;
            border: 2px dashed #e3f2fd;
            text-align: center;
        }

        .preview-container img {
            max-width: 100%;
            height: auto;
            border-radius: 8px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
            max-height: 200px;
        }

        .preview-placeholder {
            color: #888;
            font-size: 0.9rem;
            padding: 40px;
        }

        .preview-placeholder i {
            font-size: 3rem;
            color: #ccc;
            margin-bottom: 10px;
        }

        /* BUTTON STYLES - SAME AS INDEX */
        .btn-primary-custom {
            background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
            border: none;
            color: white;
            padding: 12px 30px;
            border-radius: 8px;
            text-decoration: none;
            transition: all 0.3s;
            font-size: 0.95rem;
            font-weight: 500;
            display: inline-flex;
            align-items: center;
            gap: 8px;
            cursor: pointer;
        }

        .btn-primary-custom:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 15px rgba(74, 144, 226, 0.4);
            color: white;
        }

        .btn-secondary-custom {
            background: #6c757d;
            border: none;
            color: white;
            padding: 12px 30px;
            border-radius: 8px;
            text-decoration: none;
            transition: all 0.3s;
            font-size: 0.95rem;
            font-weight: 500;
            display: inline-flex;
            align-items: center;
            gap: 8px;
        }

        .btn-secondary-custom:hover {
            background: #5a6268;
            transform: translateY(-2px);
            box-shadow: 0 4px 15px rgba(108, 117, 125, 0.4);
            color: white;
        }

        .info-text {
            color: #888;
            font-size: 0.85rem;
            margin-top: 5px;
        }

        .form-section {
            margin-bottom: 25px;
        }

        /* RESPONSIVE DESIGN */
        @media (max-width: 992px) {
            .sidebar {
                width: 25%;
            }

            .main-content {
                margin-left: 25%;
            }
        }

        @media (max-width: 768px) {
            .sidebar {
                position: relative;
                width: 100%;
                height: auto;
                min-height: auto;
                top: 0;
            }

            .main-content {
                margin-left: 0;
                margin-top: 0;
                padding: 15px;
            }

            .topbar {
                height: auto;
                padding: 10px 0;
            }

            .topbar-container {
                flex-direction: column;
                gap: 10px;
                height: auto;
            }

            .brand-section,
            .user-section {
                width: 100%;
                justify-content: center;
            }

            .form-card {
                padding: 20px;
            }

            .brand-text h4 {
                font-size: 1.1rem;
            }

            .brand-text span {
                font-size: 0.8rem;
            }

            .user-info,
            .logout-btn {
                font-size: 0.85rem;
            }
        }

        @media (max-width: 576px) {

            .btn-primary-custom,
            .btn-secondary-custom {
                padding: 10px 20px;
                font-size: 0.9rem;
                width: 100%;
                justify-content: center;
            }
        }

        .sidebar::-webkit-scrollbar {
            width: 6px;
        }

        .sidebar::-webkit-scrollbar-track {
            background: #f1f1f1;
        }

        .sidebar::-webkit-scrollbar-thumb {
            background: #4a90e2;
            border-radius: 3px;
        }

        .sidebar::-webkit-scrollbar-thumb:hover {
            background: #357abd;
        }
    </style>
</head>

<body>
    <!-- TOPBAR IMPROVED -->
    <div class="topbar">
        <div class="container-fluid">
            <div class="topbar-container">
                <!-- Brand Section (Left) -->
                <div class="brand-section">
                    <img src="<?= base_url('asset/logo 2.png'); ?>" alt="Logo KosCare" class="brand-logo">
                    <div class="brand-text">
                        <h4>KosCare</h4>
                        <span>Dashboard Admin</span>
                    </div>
                </div>

                <!-- User Section (Right) -->
                <div class="user-section">
                    <div class="user-info">
                        <i class="fas fa-user-circle"></i>
                        <div>
                            <span>Halo, <strong><?php echo $this->session->userdata('admin_name'); ?></strong></span>
                        </div>
                    </div>
                    <a href="<?php echo site_url('admin/login/logout'); ?>" class="logout-btn">
                        <i class="fas fa-sign-out-alt"></i> Logout
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- SIDEBAR -->
    <div class="sidebar" id="sidebar">
        <h5><i class="fas fa-bars"></i> Menu</h5>
        <ul>
            <li><a href="<?= site_url('admin/dashboard'); ?>" class="<?= strpos($current_url, 'dashboard') !== false ? 'active' : '' ?>"><i class="fas fa-tachometer-alt"></i> Dashboard</a></li>
            <li><a href="<?= site_url('admin/laporan'); ?>" class="<?= strpos($current_url, 'laporan') !== false ? 'active' : '' ?>"><i class="fas fa-clipboard-list"></i> Laporan</a></li>
            <li><a href="<?= site_url('admin/penghuni'); ?>" class="<?= strpos($current_url, 'penghuni') !== false ? 'active' : '' ?>"><i class="fas fa-users"></i> Penghuni</a></li>
            <li><a href="<?= site_url('admin/iklan'); ?>" class="<?= strpos($current_url, 'iklan') !== false ? 'active' : '' ?>"><i class="fas fa-bullhorn"></i> Iklan</a></li>
            <li><a href="<?= site_url('admin/kos'); ?>" class="<?= (strpos($current_url, 'kos') !== false && strpos($current_url, 'penghuni') === false) ? 'active' : '' ?>"><i class="fas fa-building"></i> Kos</a></li>
            <li><a href="<?= site_url('admin/pengaturan'); ?>" class="<?= strpos($current_url, 'pengaturan') !== false ? 'active' : '' ?>"><i class="fas fa-cog"></i> Pengaturan</a></li>
        </ul>
    </div>

    <div class="main-content">
        <div class="row">
            <div class="col-lg-8 mx-auto">
                <div class="form-card">
                    <h5><i class="fas fa-edit"></i> Edit Iklan</h5>

                    <?php if (isset($error)): ?>
                        <div class="alert alert-danger" style="background: #f8d7da; color: #721c24; padding: 15px; border-radius: 8px; border-left: 4px solid #dc3545; margin-bottom: 20px;">
                            <i class="fas fa-exclamation-circle"></i> <?php echo $error; ?>
                        </div>
                    <?php endif; ?>

                    <?php if ($this->session->flashdata('error')): ?>
                        <div class="alert alert-danger" style="background: #f8d7da; color: #721c24; padding: 15px; border-radius: 8px; border-left: 4px solid #dc3545; margin-bottom: 20px;">
                            <i class="fas fa-exclamation-circle"></i> <?= $this->session->flashdata('error') ?>
                        </div>
                    <?php endif; ?>

                    <?php if ($this->session->flashdata('success')): ?>
                        <div class="alert alert-success" style="background: #d4edda; color: #155724; padding: 15px; border-radius: 8px; border-left: 4px solid #28a745; margin-bottom: 20px;">
                            <i class="fas fa-check-circle"></i> <?= $this->session->flashdata('success') ?>
                        </div>
                    <?php endif; ?>

                    <form method="post" action="<?= site_url('admin/iklan/edit/' . $iklan->id_iklan) ?>" enctype="multipart/form-data">
                        <div class="form-section">
                            <label class="form-label">
                                <i class="fas fa-heading"></i> Judul Iklan <span class="required">*</span>
                            </label>
                            <input type="text" name="judul" class="form-control" value="<?= htmlspecialchars($iklan->judul) ?>" required>
                        </div>

                        <div class="form-section">
                            <label class="form-label">
                                <i class="fas fa-align-left"></i> Deskripsi <span class="required">*</span>
                            </label>
                            <textarea name="deskripsi" class="form-control" rows="4" required><?= htmlspecialchars($iklan->deskripsi) ?></textarea>
                        </div>

                        <div class="form-section">
                            <label class="form-label">
                                <i class="fas fa-home"></i> Pilih Kos <span class="required">*</span>
                            </label>
                            <select name="id_kos" class="form-select form-control" required>
                                <option value="">-- Pilih Kos --</option>
                                <?php if (isset($list_kos) && !empty($list_kos)): ?>
                                    <?php foreach ($list_kos as $kos): ?>
                                        <option value="<?= $kos->id_kos ?>" <?= ($iklan->id_kos == $kos->id_kos) ? 'selected' : '' ?>>
                                            <?= htmlspecialchars($kos->nama_kos) ?>
                                        </option>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <option value="" disabled>-- Tidak ada kos tersedia --</option>
                                <?php endif; ?>
                            </select>
                        </div>

                        <div class="form-section">
                            <label class="form-label">
                                <i class="fas fa-image"></i> Gambar Iklan
                            </label>

                            <div class="current-image-container">
                                <span class="current-image-label">
                                    <i class="fas fa-image"></i> Gambar Saat Ini
                                </span>
                                <?php if (!empty($iklan->gambar) && file_exists(FCPATH . 'asset/iklan/' . $iklan->gambar)): ?>
                                    <img src="<?= base_url('asset/iklan/' . $iklan->gambar) ?>"
                                        alt="<?= htmlspecialchars($iklan->judul) ?>"
                                        onerror="this.style.display='none'; this.nextElementSibling.style.display='block';">
                                    <div class="preview-placeholder" style="display: none;" id="errorPlaceholder">
                                        <i class="fas fa-exclamation-triangle"></i>
                                        <p>Gambar tidak dapat dimuat</p>
                                    </div>
                                <?php else: ?>
                                    <div class="preview-placeholder">
                                        <i class="fas fa-image"></i>
                                        <p>Tidak ada gambar</p>
                                    </div>
                                <?php endif; ?>
                            </div>

                            <div class="mt-3">
                                <label class="form-label">
                                    <i class="fas fa-upload"></i> Ganti Gambar (Opsional)
                                </label>
                                <input type="file" name="gambar" class="form-control" accept="image/*" onchange="previewImage(event)">
                                <div class="info-text">Kosongkan jika tidak ingin mengganti gambar. Format: JPG, PNG, GIF. Maksimal 2MB</div>
                            </div>

                            <div class="preview-container" id="previewContainer" style="display:none;">
                                <div class="preview-placeholder" id="previewPlaceholder">
                                    <i class="fas fa-eye"></i>
                                    <p>Preview gambar baru</p>
                                </div>
                                <img id="preview" style="display:none; max-height: 200px;">
                            </div>
                        </div>

                        <div class="form-section">
                            <label class="form-label">
                                <i class="fas fa-link"></i> Link/URL <span class="required">*</span>
                            </label>
                            <input type="url" name="link" class="form-control" value="<?= htmlspecialchars($iklan->link) ?>" required>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-section">
                                    <label class="form-label">
                                        <i class="fas fa-sort-numeric-down"></i> Urutan Tampil <span class="required">*</span>
                                    </label>
                                    <input type="number" name="urutan" class="form-control" value="<?= $iklan->urutan ?>" min="1" required>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-section">
                                    <label class="form-label">
                                        <i class="fas fa-toggle-on"></i> Status <span class="required">*</span>
                                    </label>
                                    <select name="status" class="form-select form-control" required>
                                        <option value="Aktif" <?= $iklan->status == 'Aktif' ? 'selected' : '' ?>>Aktif</option>
                                        <option value="Nonaktif" <?= $iklan->status == 'Nonaktif' ? 'selected' : '' ?>>Nonaktif</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="d-flex gap-2 mt-4">
                            <button type="submit" class="btn-primary-custom">
                                <i class="fas fa-save"></i> Update Iklan
                            </button>
                            <a href="<?= site_url('admin/iklan') ?>" class="btn-secondary-custom">
                                <i class="fas fa-arrow-left"></i> Kembali
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script src="<?php echo base_url('asset/js/jquery-3.6.0.min.js'); ?>"></script>
    <script src="<?php echo base_url('asset/js/bootstrap.bundle.min.js'); ?>"></script>

    <script>
        function previewImage(event) {
            const reader = new FileReader();
            const preview = document.getElementById('preview');
            const placeholder = document.getElementById('previewPlaceholder');
            const previewContainer = document.getElementById('previewContainer');

            reader.onload = function() {
                preview.src = reader.result;
                preview.style.display = 'block';
                if (placeholder) {
                    placeholder.style.display = 'none';
                }
                previewContainer.style.display = 'block';
            }

            if (event.target.files && event.target.files[0]) {
                reader.readAsDataURL(event.target.files[0]);
            }
        }

        // Add hover effects to logout button
        document.addEventListener('DOMContentLoaded', function() {
            const logoutBtn = document.querySelector('.logout-btn');
            if (logoutBtn) {
                logoutBtn.addEventListener('mouseenter', function() {
                    this.style.transform = 'translateY(-1px) scale(1.02)';
                });
                logoutBtn.addEventListener('mouseleave', function() {
                    this.style.transform = 'translateY(0) scale(1)';
                });
            }
        });
    </script>
</body>

</html>