<?php
// Determine active menu based on current URL
$current_url = uri_string(); // Get current URI segment
?>
<!doctype html>
<html>

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title><?php echo isset($title) ? $title : 'Kelola Iklan'; ?> - SistemKOS</title>
    <link rel="stylesheet" href="<?php echo base_url('asset/css/bootstrap.min.css'); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: #f0f8ff;
            color: #333;
        }

        /* TOPBAR IMPROVED - SAME AS ADMIN */
        .topbar {
            background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
            padding: 12px 0;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            z-index: 1030;
            height: 60px;
        }

        .topbar-container {
            display: flex;
            justify-content: space-between;
            align-items: center;
            height: 100%;
            padding: 0 15px;
        }

        .brand-section {
            display: flex;
            align-items: center;
            gap: 15px;
            flex-shrink: 0;
        }

        .brand-logo {
            width: 50px;
            height: auto;
            transition: transform 0.3s;
        }

        .brand-logo:hover {
            transform: scale(1.05);
        }

        .brand-text {
            color: white;
        }

        .brand-text h4 {
            font-weight: 600;
            font-size: 1.3rem;
            margin: 0;
            line-height: 1.2;
        }

        .brand-text span {
            font-size: 0.9rem;
            opacity: 0.9;
            display: block;
            margin-top: 2px;
        }

        .user-section {
            display: flex;
            align-items: center;
            gap: 15px;
            flex-shrink: 0;
        }

        .user-info {
            display: flex;
            align-items: center;
            gap: 8px;
            color: white;
            font-size: 0.95rem;
            padding: 6px 12px;
            border-radius: 6px;
            transition: background 0.3s;
        }

        .user-info:hover {
            background: rgba(255, 255, 255, 0.1);
        }

        .user-info i {
            font-size: 1.2rem;
        }

        .logout-btn {
            display: flex;
            align-items: center;
            gap: 8px;
            color: white;
            text-decoration: none;
            padding: 8px 16px;
            border-radius: 6px;
            background: rgba(255, 255, 255, 0.15);
            transition: all 0.3s;
            font-size: 0.9rem;
            font-weight: 500;
        }

        .logout-btn:hover {
            background: rgba(255, 255, 255, 0.25);
            transform: translateY(-1px);
            color: white;
        }

        /* SIDEBAR STYLES */
        .sidebar {
            background: white;
            min-height: calc(100vh - 60px);
            padding: 25px 15px;
            box-shadow: 2px 0 10px rgba(0, 0, 0, 0.05);
            position: fixed;
            top: 60px;
            left: 0;
            width: 16.666667%;
            height: calc(100vh - 60px);
            overflow-y: auto;
            z-index: 1020;
        }

        .sidebar h5 {
            color: #4a90e2;
            margin-bottom: 20px;
            font-weight: 600;
            padding-bottom: 10px;
            border-bottom: 2px solid #e3f2fd;
        }

        .sidebar ul {
            list-style: none;
        }

        .sidebar ul li {
            margin-bottom: 8px;
        }

        .sidebar ul li a {
            display: block;
            padding: 12px 15px;
            color: #555;
            text-decoration: none;
            border-radius: 8px;
            transition: all 0.3s;
            font-size: 0.95rem;
            position: relative;
            overflow: hidden;
        }

        .sidebar ul li a:hover {
            background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
            color: white;
            transform: translateX(5px);
        }

        .sidebar ul li a.active {
            background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
            color: white;
            transform: translateX(5px);
            box-shadow: 0 4px 15px rgba(74, 144, 226, 0.3);
        }

        .sidebar ul li a.active:before {
            content: '';
            position: absolute;
            left: 0;
            top: 0;
            height: 100%;
            width: 4px;
            background: white;
            border-radius: 0 4px 4px 0;
        }

        .sidebar ul li a i {
            width: 20px;
            margin-right: 10px;
        }

        /* MAIN CONTENT */
        .main-content {
            margin-left: 16.666667%;
            margin-top: 60px;
            padding: 25px;
            background: #f0f8ff;
            min-height: calc(100vh - 60px);
        }

        .page-header {
            background: white;
            border-radius: 12px;
            padding: 20px 25px;
            margin-bottom: 25px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.08);
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .page-header h3 {
            color: #4a90e2;
            font-weight: 600;
            margin: 0;
        }

        .btn-primary-custom {
            background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
            border: none;
            color: white;
            padding: 10px 20px;
            border-radius: 8px;
            text-decoration: none;
            transition: all 0.3s;
            font-size: 0.95rem;
            font-weight: 500;
            display: inline-flex;
            align-items: center;
            gap: 8px;
        }

        .btn-primary-custom:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 15px rgba(74, 144, 226, 0.4);
            color: white;
        }

        .table-card {
            background: white;
            border-radius: 12px;
            padding: 25px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.08);
            overflow-x: auto;
        }

        .table {
            margin-bottom: 0;
            width: 100%;
            border-collapse: separate;
            border-spacing: 0;
        }

        .table thead th {
            background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
            color: white;
            border: none;
            padding: 15px;
            font-weight: 500;
            font-size: 0.95rem;
            white-space: nowrap;
        }

        .table thead th:first-child {
            border-radius: 8px 0 0 0;
        }

        .table thead th:last-child {
            border-radius: 0 8px 0 0;
        }

        .table tbody tr {
            transition: all 0.3s;
            border-bottom: 1px solid #e9ecef;
        }

        .table tbody tr:hover {
            background: #f8fbff;
            transform: scale(1.01);
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
        }

        .table tbody td {
            padding: 15px;
            vertical-align: middle;
            text-align: center;
        }

        .table img {
            border-radius: 8px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
            object-fit: cover;
        }

        .badge-status {
            display: inline-block;
            padding: 6px 14px;
            border-radius: 20px;
            font-size: 0.85rem;
            font-weight: 500;
        }

        .badge-aktif {
            background: #d4edda;
            color: #155724;
        }

        .badge-nonaktif {
            background: #f8d7da;
            color: #721c24;
        }

        .btn-action {
            padding: 6px 12px;
            border-radius: 6px;
            font-size: 0.85rem;
            text-decoration: none;
            transition: all 0.3s;
            display: inline-flex;
            align-items: center;
            gap: 5px;
            margin: 2px;
        }

        .btn-warning {
            background: #ffc107;
            color: #856404;
            border: none;
        }

        .btn-warning:hover {
            background: #e0a800;
            transform: translateY(-2px);
            box-shadow: 0 4px 10px rgba(255, 193, 7, 0.4);
            color: #856404;
        }

        .btn-danger {
            background: #dc3545;
            color: white;
            border: none;
        }

        .btn-danger:hover {
            background: #c82333;
            transform: translateY(-2px);
            box-shadow: 0 4px 10px rgba(220, 53, 69, 0.4);
            color: white;
        }

        .empty-state {
            text-align: center;
            padding: 60px 20px;
            color: #888;
        }

        .empty-state i {
            font-size: 5rem;
            color: #ccc;
            margin-bottom: 20px;
        }

        .empty-state p {
            font-size: 1.1rem;
            margin: 0 0 20px 0;
        }

        .urutan-badge {
            background: #e3f2fd;
            color: #4a90e2;
            padding: 6px 14px;
            border-radius: 20px;
            font-weight: 600;
            font-size: 0.85rem;
        }

        .link-preview {
            color: #4a90e2;
            text-decoration: none;
            font-size: 0.85rem;
            max-width: 200px;
            display: inline-block;
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
        }

        .link-preview:hover {
            text-decoration: underline;
        }

        .image-placeholder {
            width: 120px;
            height: 70px;
            background: #e3f2fd;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 8px;
            color: #4a90e2;
            margin: 0 auto;
        }

        /* RESPONSIVE DESIGN */
        @media (max-width: 992px) {
            .sidebar {
                width: 25%;
            }

            .main-content {
                margin-left: 25%;
            }
        }

        @media (max-width: 768px) {
            .sidebar {
                position: relative;
                width: 100%;
                height: auto;
                min-height: auto;
                top: 0;
            }

            .main-content {
                margin-left: 0;
                margin-top: 0;
                padding: 15px;
            }

            .topbar {
                height: auto;
                padding: 10px 0;
            }

            .topbar-container {
                flex-direction: column;
                gap: 10px;
                height: auto;
            }

            .brand-section,
            .user-section {
                width: 100%;
                justify-content: center;
            }

            .page-header {
                flex-direction: column;
                align-items: flex-start;
                gap: 15px;
            }

            .table-card {
                padding: 15px;
            }

            .brand-text h4 {
                font-size: 1.1rem;
            }

            .brand-text span {
                font-size: 0.8rem;
            }

            .user-info,
            .logout-btn {
                font-size: 0.85rem;
            }
        }

        @media (max-width: 576px) {
            .btn-action {
                display: block;
                margin-bottom: 5px;
                width: 100%;
                text-align: center;
            }

            .table {
                font-size: 0.85rem;
            }

            .table td,
            .table th {
                padding: 10px;
            }

            .image-placeholder {
                width: 80px;
                height: 50px;
            }
        }

        .sidebar::-webkit-scrollbar {
            width: 6px;
        }

        .sidebar::-webkit-scrollbar-track {
            background: #f1f1f1;
        }

        .sidebar::-webkit-scrollbar-thumb {
            background: #4a90e2;
            border-radius: 3px;
        }

        .sidebar::-webkit-scrollbar-thumb:hover {
            background: #357abd;
        }
    </style>
</head>

<body>
    <!-- TOPBAR IMPROVED -->
    <div class="topbar">
        <div class="container-fluid">
            <div class="topbar-container">
                <!-- Brand Section (Left) -->
                <div class="brand-section">
                    <img src="<?= base_url('asset/logo 2.png'); ?>" alt="Logo KosCare" class="brand-logo">
                    <div class="brand-text">
                        <h4>KosCare</h4>
                        <span>Dashboard Admin</span>
                    </div>
                </div>

                <!-- User Section (Right) -->
                <div class="user-section">
                    <div class="user-info">
                        <i class="fas fa-user-circle"></i>
                        <div>
                            <span>Halo, <strong><?php echo $this->session->userdata('admin_name'); ?></strong></span>
                        </div>
                    </div>
                    <a href="<?php echo site_url('admin/login/logout'); ?>" class="logout-btn">
                        <i class="fas fa-sign-out-alt"></i> Logout
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- SIDEBAR -->
    <div class="sidebar" id="sidebar">
        <h5><i class="fas fa-bars"></i> Menu</h5>
        <ul>
            <li><a href="<?= site_url('admin/dashboard'); ?>" class="<?= strpos($current_url, 'dashboard') !== false ? 'active' : '' ?>"><i class="fas fa-tachometer-alt"></i> Dashboard</a></li>
            <li><a href="<?= site_url('admin/laporan'); ?>" class="<?= strpos($current_url, 'laporan') !== false ? 'active' : '' ?>"><i class="fas fa-clipboard-list"></i> Laporan</a></li>
            <li><a href="<?= site_url('admin/penghuni'); ?>" class="<?= strpos($current_url, 'penghuni') !== false ? 'active' : '' ?>"><i class="fas fa-users"></i> Penghuni</a></li>
            <li><a href="<?= site_url('admin/iklan'); ?>" class="<?= strpos($current_url, 'iklan') !== false ? 'active' : '' ?>"><i class="fas fa-bullhorn"></i> Iklan</a></li>
            <li><a href="<?= site_url('admin/kos'); ?>" class="<?= (strpos($current_url, 'kos') !== false && strpos($current_url, 'penghuni') === false) ? 'active' : '' ?>"><i class="fas fa-building"></i> Kos</a></li>
            <li><a href="<?= site_url('admin/pengaturan'); ?>" class="<?= strpos($current_url, 'pengaturan') !== false ? 'active' : '' ?>"><i class="fas fa-cog"></i> Pengaturan</a></li>
        </ul>
    </div>

    <div class="main-content">
        <div class="page-header">
            <h3><i class="fas fa-bullhorn"></i> <?php echo isset($title) ? $title : 'Kelola Iklan'; ?></h3>
            <a href="<?php echo site_url('admin/iklan/tambah'); ?>" class="btn-primary-custom">
                <i class="fas fa-plus-circle"></i> Tambah Iklan Baru
            </a>
        </div>

        <div class="table-card">
            <?php if (!empty($iklan) && count($iklan) > 0): ?>
                <table class="table">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Judul</th>
                            <th>Gambar</th>
                            <th>Link</th>
                            <th>Status</th>
                            <th>Urutan</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($iklan as $i): ?>
                            <tr>
                                <td><strong><?php echo $i->id_iklan; ?></strong></td>
                                <td style="text-align: left;">
                                    <strong><?php echo htmlspecialchars($i->judul); ?></strong>
                                </td>
                                <td>
                                    <?php if (!empty($i->gambar) && file_exists(FCPATH . 'asset/iklan/' . $i->gambar)): ?>
                                        <img src="<?php echo base_url('asset/iklan/' . $i->gambar); ?>"
                                            width="120" height="70"
                                            alt="<?php echo htmlspecialchars($i->judul); ?>"
                                            onerror="this.style.display='none'; this.nextElementSibling.style.display='flex';">
                                        <div class="image-placeholder" style="display: none;">
                                            <i class="fas fa-image" style="font-size: 1.5rem;"></i>
                                        </div>
                                    <?php else: ?>
                                        <div class="image-placeholder">
                                            <i class="fas fa-image" style="font-size: 1.5rem;"></i>
                                        </div>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <a href="<?php echo htmlspecialchars($i->link); ?>" target="_blank" class="link-preview"
                                        title="<?php echo htmlspecialchars($i->link); ?>">
                                        <?php 
                                        $display_link = $i->link;
                                        if (strlen($display_link) > 30) {
                                            $display_link = substr($display_link, 0, 30) . '...';
                                        }
                                        echo htmlspecialchars($display_link);
                                        ?>
                                    </a>
                                </td>
                                <td>
                                    <span class="badge-status <?php echo strtolower($i->status) == 'aktif' ? 'badge-aktif' : 'badge-nonaktif'; ?>">
                                        <i class="fas <?php echo strtolower($i->status) == 'aktif' ? 'fa-check-circle' : 'fa-times-circle'; ?>"></i> <?php echo $i->status; ?>
                                    </span>
                                </td>
                                <td>
                                    <span class="urutan-badge"><?php echo $i->urutan; ?></span>
                                </td>
                                <td>
                                    <a href="<?php echo site_url('admin/iklan/edit/' . $i->id_iklan); ?>"
                                        class="btn-action btn-warning" title="Edit Iklan">
                                        <i class="fas fa-edit"></i> Edit
                                    </a>
                                    <a href="<?php echo site_url('admin/iklan/hapus/' . $i->id_iklan); ?>"
                                        class="btn-action btn-danger"
                                        onclick="return confirm('Yakin ingin menghapus iklan &quot;<?php echo addslashes($i->judul); ?>&quot;?')"
                                        title="Hapus Iklan">
                                        <i class="fas fa-trash"></i> Hapus
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php else: ?>
                <div class="empty-state">
                    <i class="fas fa-bullhorn"></i>
                    <p>Belum ada iklan yang ditambahkan</p>
                    <a href="<?php echo site_url('admin/iklan/tambah'); ?>" class="btn-primary-custom">
                        <i class="fas fa-plus-circle"></i> Tambah Iklan Pertama
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <script src="<?php echo base_url('asset/js/jquery-3.6.0.min.js'); ?>"></script>
    <script src="<?php echo base_url('asset/js/bootstrap.bundle.min.js'); ?>"></script>

    <script>
        // Add hover effects to logout button
        document.addEventListener('DOMContentLoaded', function() {
            const logoutBtn = document.querySelector('.logout-btn');
            if (logoutBtn) {
                logoutBtn.addEventListener('mouseenter', function() {
                    this.style.transform = 'translateY(-1px) scale(1.02)';
                });
                logoutBtn.addEventListener('mouseleave', function() {
                    this.style.transform = 'translateY(0) scale(1)';
                });
            }
        });
    </script>
</body>

</html>