<?php
defined('BASEPATH') or exit('No direct script access allowed');

// Debug data - hapus setelah testing
// echo "<pre>";
// print_r($admin);
// print_r($current_subscription);
// echo "</pre>";
?>

<div class="container-fluid">
    <div class="row">
        <div class="col-lg-6 mx-auto">
            <div class="card shadow">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0"><i class="fas fa-credit-card"></i> Pembayaran Fitur Chat</h5>
                </div>
                <div class="card-body">

                    <!-- Ringkasan Pesanan -->
                    <div class="alert alert-light border">
                        <h6 class="alert-heading">Ringkasan Pesanan</h6>
                        <div class="row">
                            <div class="col-6">
                                <p class="mb-1"><strong>Produk:</strong></p>
                                <p class="mb-1"><strong>Durasi:</strong></p>
                                <p class="mb-1"><strong>Tanggal:</strong></p>
                                <p class="mb-0"><strong>Pelanggan:</strong></p>
                            </div>
                            <div class="col-6 text-end">
                                <p class="mb-1">Fitur Chat Premium</p>
                                <p class="mb-1"><?php echo isset($duration) ? $duration . ' Hari' : '30 Hari'; ?></p>
                                <p class="mb-1"><?php echo date('d F Y'); ?></p>
                                <p class="mb-0"><?php echo isset($admin->nama) ? $admin->nama : 'Admin'; ?></p>
                            </div>
                        </div>
                        <hr>
                        <div class="row">
                            <div class="col-6">
                                <h5 class="mb-0">Total Pembayaran:</h5>
                            </div>
                            <div class="col-6 text-end">
                                <h3 class="text-primary mb-0">Rp <?php echo isset($price) ? number_format($price, 0, ',', '.') : '50.000'; ?></h3>
                            </div>
                        </div>
                    </div>

                    <!-- Status Langganan Saat Ini -->
                    <?php if (isset($current_subscription) && !empty($current_subscription)): ?>
                        <div class="alert alert-warning">
                            <h6><i class="fas fa-info-circle"></i> Status Langganan Saat Ini</h6>
                            <p class="mb-1">Masa aktif:
                                <strong>
                                    <?php echo date('d F Y', strtotime($current_subscription['start_date'])); ?>
                                    -
                                    <?php echo date('d F Y', strtotime($current_subscription['end_date'])); ?>
                                </strong>
                            </p>
                            <p class="mb-0">Status: <span class="badge bg-success"><?php echo ucfirst($current_subscription['status']); ?></span></p>
                        </div>
                    <?php endif; ?>

                    <?php if (isset($is_chat_active) && $is_chat_active): ?>
                        <div class="alert alert-success">
                            <h6><i class="fas fa-check-circle"></i> Fitur Chat Aktif</h6>
                            <p class="mb-1">Fitur chat Anda saat ini <strong>AKTIF</strong></p>
                            <?php if (isset($current_subscription) && !empty($current_subscription)): ?>
                                <p class="mb-0">Berlaku hingga: <strong><?php echo date('d F Y H:i', strtotime($current_subscription['end_date'])); ?></strong></p>
                            <?php endif; ?>
                        </div>
                    <?php else: ?>
                        <div class="alert alert-warning">
                            <h6><i class="fas fa-exclamation-triangle"></i> Fitur Chat Tidak Aktif</h6>
                            <p class="mb-0">Anda perlu membayar untuk mengaktifkan fitur chat.</p>
                        </div>
                    <?php endif; ?>

                    <!-- Informasi Penting -->
                    <div class="alert alert-info">
                        <h6><i class="fas fa-info-circle"></i> Informasi Penting</h6>
                        <ul class="mb-0">
                            <li>Pembayaran akan mengaktifkan fitur chat selama <?php echo isset($duration) ? $duration : '30'; ?> hari</li>
                            <li>Fitur akan aktif segera setelah pembayaran berhasil</li>
                            <li>Anda akan mendapatkan notifikasi sebelum masa aktif berakhir</li>
                            <li>Data chat akan disimpan selama masa aktif</li>
                            <li>Pembayaran menggunakan Midtrans yang mendukung berbagai metode pembayaran</li>
                        </ul>
                    </div>

                    <!-- Metode Pembayaran yang Didukung -->
                    <div class="mb-4">
                        <h6 class="mb-3">Metode Pembayaran yang Didukung</h6>
                        <div class="row g-2">
                            <div class="col-3">
                                <div class="payment-method border rounded p-2 text-center bg-light">
                                    <i class="fas fa-credit-card fa-lg text-primary mb-1"></i>
                                    <p class="mb-0 small">Kartu Kredit</p>
                                </div>
                            </div>
                            <div class="col-3">
                                <div class="payment-method border rounded p-2 text-center bg-light">
                                    <i class="fas fa-university fa-lg text-success mb-1"></i>
                                    <p class="mb-0 small">Transfer Bank</p>
                                </div>
                            </div>
                            <div class="col-3">
                                <div class="payment-method border rounded p-2 text-center bg-light">
                                    <i class="fas fa-mobile-alt fa-lg text-info mb-1"></i>
                                    <p class="mb-0 small">E-Wallet</p>
                                </div>
                            </div>
                            <div class="col-3">
                                <div class="payment-method border rounded p-2 text-center bg-light">
                                    <i class="fas fa-qrcode fa-lg text-warning mb-1"></i>
                                    <p class="mb-0 small">QRIS</p>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
                <div class="card-footer">
                    <div class="row">
                        <div class="col-6">
                            <a href="<?php echo base_url('admin/dashboard'); ?>" class="btn btn-outline-secondary w-100">
                                <i class="fas fa-arrow-left"></i> Kembali ke Dashboard
                            </a>
                        </div>
                        <div class="col-6">
                            <!-- Form untuk proses pembayaran -->
                            <form action="<?php echo base_url('payment/process'); ?>" method="POST" id="payment-form">
                                <?php if (isset($is_chat_active) && $is_chat_active): ?>
                                    <button type="button" class="btn btn-success w-100" disabled>
                                        <i class="fas fa-check"></i> Fitur Sudah Aktif
                                    </button>
                                <?php else: ?>
                                    <button type="submit" class="btn btn-primary w-100" id="pay-button">
                                        <i class="fas fa-lock"></i> Bayar Sekarang (Rp <?php echo isset($price) ? number_format($price, 0, ',', '.') : '50.000'; ?>)
                                    </button>
                                <?php endif; ?>
                            </form>
                        </div>
                    </div>

                    <?php if (isset($current_subscription) && !empty($current_subscription) && $current_subscription['status'] == 'active'): ?>
                        <div class="row mt-3">
                            <div class="col-12">
                                <a href="<?php echo base_url('payment/history'); ?>" class="btn btn-outline-info w-100">
                                    <i class="fas fa-history"></i> Lihat History Pembayaran
                                </a>
                            </div>
                        </div>
                    <?php endif; ?>

                    <div class="text-center mt-3">
                        <small class="text-muted">
                            <i class="fas fa-shield-alt"></i> Pembayaran aman terenkripsi oleh Midtrans
                        </small>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .payment-method {
        transition: all 0.3s;
        min-height: 70px;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
    }

    .payment-method:hover {
        border-color: #4e73df !important;
        background-color: #f8f9fc;
        transform: translateY(-2px);
    }

    .payment-method.active {
        border-color: #4e73df !important;
        background-color: #e3f2fd;
        box-shadow: 0 0 0 2px rgba(78, 115, 223, 0.25);
    }
</style>

<script>
    $(document).ready(function() {
        // Proses pembayaran
        $('#payment-form').submit(function(e) {
            e.preventDefault();

            // Tampilkan loading
            $('#pay-button').html('<i class="fas fa-spinner fa-spin"></i> Memproses...').prop('disabled', true);

            // Submit form setelah 500ms
            setTimeout(function() {
                $('#payment-form')[0].submit();
            }, 500);
        });

        // Animasi untuk metode pembayaran
        $('.payment-method').hover(
            function() {
                $(this).addClass('active');
            },
            function() {
                $(this).removeClass('active');
            }
        );
    });
</script>