<?php
defined('BASEPATH') or exit('No direct script access allowed');
?>

<div class="container-fluid">
    <div class="row">
        <div class="col-lg-8 mx-auto">
            <div class="card shadow">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0"><i class="fas fa-comments"></i> Aktivasi Fitur Chat</h5>
                </div>
                <div class="card-body">

                    <!-- Status Subscription -->
                    <?php if (isset($current_subscription) && !empty($current_subscription)): ?>
                        <?php
                        $expiry = strtotime($current_subscription['end_date']);
                        $now = time();
                        $days_left = ceil(($expiry - $now) / (60 * 60 * 24));
                        ?>

                        <?php if ($days_left > 0): ?>
                            <div class="alert alert-success">
                                <div class="d-flex align-items-center">
                                    <div class="flex-shrink-0">
                                        <i class="fas fa-check-circle fa-3x"></i>
                                    </div>
                                    <div class="flex-grow-1 ms-4">
                                        <h4 class="alert-heading">Fitur Chat Aktif!</h4>
                                        <p class="mb-1">
                                            <strong>Berlangganan Anda aktif hingga:</strong><br>
                                            <span class="h5 text-success">
                                                <?php echo date('d F Y', strtotime($current_subscription['end_date'])); ?>
                                            </span>
                                        </p>
                                        <p class="mb-0">
                                            <strong>Sisa waktu:</strong>
                                            <span class="badge bg-success fs-6">
                                                <?php echo $days_left; ?> hari
                                            </span>
                                        </p>
                                        <hr>
                                        <a href="<?php echo base_url('admin/chat'); ?>" class="btn btn-success">
                                            <i class="fas fa-comments"></i> Gunakan Fitur Chat
                                        </a>
                                    </div>
                                </div>
                            </div>
                        <?php else: ?>
                            <div class="alert alert-warning">
                                <div class="d-flex align-items-center">
                                    <div class="flex-shrink-0">
                                        <i class="fas fa-exclamation-triangle fa-3x"></i>
                                    </div>
                                    <div class="flex-grow-1 ms-4">
                                        <h4 class="alert-heading">Berlangganan Telah Berakhir</h4>
                                        <p>Berlangganan Anda telah berakhir pada <?php echo date('d F Y', strtotime($current_subscription['end_date'])); ?>.</p>
                                        <a href="<?php echo base_url('payment/checkout'); ?>" class="btn btn-warning">
                                            <i class="fas fa-sync-alt"></i> Perpanjang Sekarang
                                        </a>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                    <?php else: ?>
                        <div class="alert alert-info">
                            <div class="d-flex align-items-center">
                                <div class="flex-shrink-0">
                                    <i class="fas fa-info-circle fa-3x"></i>
                                </div>
                                <div class="flex-grow-1 ms-4">
                                    <h4 class="alert-heading">Fitur Chat Tidak Aktif</h4>
                                    <p>Anda belum berlangganan fitur chat. Aktifkan sekarang untuk bisa berkomunikasi dengan penghuni secara real-time.</p>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>

                    <!-- Paket Berlangganan -->
                    <div class="card mb-4 border-primary">
                        <div class="card-body text-center">
                            <h3 class="card-title text-primary">Paket Chat 1 Bulan</h3>

                            <div class="my-4">
                                <h1 class="display-4 text-primary">Rp 100.000</h1>
                                <p class="lead">Akses fitur chat selama 30 hari</p>
                            </div>

                            <div class="row text-start mb-4">
                                <div class="col-md-6">
                                    <h5><i class="fas fa-check text-success"></i> Fitur yang Didapat:</h5>
                                    <ul class="list-unstyled">
                                        <li class="mb-2"><i class="fas fa-comment-dots text-primary"></i> Chat real-time dengan penghuni</li>
                                        <li class="mb-2"><i class="fas fa-paper-plane text-primary"></i> Kirim pesan & file</li>
                                        <li class="mb-2"><i class="fas fa-bell text-primary"></i> Notifikasi chat</li>
                                        <li class="mb-2"><i class="fas fa-history text-primary"></i> Riwayat percakapan</li>
                                    </ul>
                                </div>
                                <div class="col-md-6">
                                    <h5><i class="fas fa-shield-alt text-success"></i> Keamanan:</h5>
                                    <ul class="list-unstyled">
                                        <li class="mb-2"><i class="fas fa-lock text-primary"></i> Data terenkripsi</li>
                                        <li class="mb-2"><i class="fas fa-user-check text-primary"></i> Verifikasi pengguna</li>
                                        <li class="mb-2"><i class="fas fa-database text-primary"></i> Backup data otomatis</li>
                                        <li class="mb-2"><i class="fas fa-headset text-primary"></i> Support 24/7</li>
                                    </ul>
                                </div>
                            </div>

                            <?php if (empty($current_subscription) || (isset($days_left) && $days_left <= 0)): ?>
                                <a href="<?php echo site_url('payment/checkout'); ?>" class="btn btn-primary btn-lg px-5">
                                    <i class="fas fa-shopping-cart"></i> Aktifkan Sekarang
                                </a>
                            <?php else: ?>
                                <a href="<?php echo site_url('payment/checkout'); ?>" class="btn btn-outline-primary btn-lg px-5">
                                    <i class="fas fa-sync-alt"></i> Perpanjang Berlangganan
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>

                    <!-- Riwayat Pembayaran -->
                    <?php if (!empty($payment_history)): ?>
                        <h5 class="mb-3"><i class="fas fa-history"></i> Riwayat Pembayaran</h5>
                        <div class="table-responsive">
                            <table class="table table-bordered table-hover">
                                <thead class="table-light">
                                    <tr>
                                        <th>Tanggal</th>
                                        <th>Order ID</th>
                                        <th>Jumlah</th>
                                        <th>Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($payment_history as $payment): ?>
                                        <tr>
                                            <td><?php echo date('d/m/Y H:i', strtotime($payment['created_at'])); ?></td>
                                            <td><code><?php echo $payment['order_id']; ?></code></td>
                                            <td class="text-end">Rp <?php echo number_format($payment['gross_amount'], 0, ',', '.'); ?></td>
                                            <td>
                                                <?php
                                                $status = $payment['transaction_status'];
                                                $badge_class = 'secondary';
                                                if ($status == 'settlement') {
                                                    $badge_class = 'success';
                                                } elseif ($status == 'pending') {
                                                    $badge_class = 'warning';
                                                } elseif ($status == 'deny' || $status == 'cancel') {
                                                    $badge_class = 'danger';
                                                }
                                                ?>
                                                <span class="badge bg-<?php echo $badge_class; ?>">
                                                    <?php
                                                    $status_text = [
                                                        'settlement' => 'Berhasil',
                                                        'pending' => 'Menunggu',
                                                        'deny' => 'Ditolak',
                                                        'cancel' => 'Dibatalkan'
                                                    ];
                                                    echo $status_text[$status] ?? ucfirst($status);
                                                    ?>
                                                </span>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <div class="alert alert-secondary">
                            <i class="fas fa-info-circle"></i> Belum ada riwayat pembayaran.
                        </div>
                    <?php endif; ?>

                </div>
                <div class="card-footer text-center">
                    <small class="text-muted">
                        <i class="fas fa-question-circle"></i> Butuh bantuan?
                        <a href="mailto:support@sistemkos.com">Hubungi Support</a>
                    </small>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .card {
        border-radius: 10px;
    }

    .alert {
        border-radius: 10px;
        border: none;
    }

    .btn-lg {
        padding: 12px 30px;
        font-size: 1.1rem;
    }
</style>

<script>
    // Update pending count badge
    function updatePendingCount() {
        $.ajax({
            url: '<?php echo base_url("payment/pending_count"); ?>',
            type: 'GET',
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    $('#pending-payments-badge').text(response.count);
                    if (response.count > 0) {
                        $('#pending-payments-badge').show();
                    } else {
                        $('#pending-payments-badge').hide();
                    }
                }
            }
        });
    }

    $(document).ready(function() {
        updatePendingCount();
        setInterval(updatePendingCount, 30000);
    });
</script>