<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $title; ?> - Sistem Kos</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
        }
        .payment-card {
            background: white;
            border-radius: 20px;
            box-shadow: 0 15px 35px rgba(0,0,0,0.2);
            padding: 40px;
            max-width: 600px;
            margin: 50px auto;
        }
        .payment-header {
            text-align: center;
            margin-bottom: 30px;
        }
        .payment-icon {
            font-size: 60px;
            color: #4e73df;
            margin-bottom: 20px;
        }
        .amount-display {
            font-size: 48px;
            font-weight: bold;
            color: #4e73df;
            margin: 20px 0;
        }
        .payment-details {
            background: #f8f9fa;
            border-radius: 10px;
            padding: 20px;
            margin: 20px 0;
        }
        .payment-methods {
            display: flex;
            flex-wrap: wrap;
            gap: 10px;
            justify-content: center;
            margin: 20px 0;
        }
        .payment-method {
            border: 1px solid #dee2e6;
            border-radius: 8px;
            padding: 10px;
            text-align: center;
            width: 100px;
        }
        .payment-method img {
            height: 30px;
        }
    </style>
</head>
<body>
    <div class="payment-card">
        <div class="payment-header">
            <div class="payment-icon">
                <i class="fas fa-credit-card"></i>
            </div>
            <h1><?php echo $title; ?></h1>
            <p class="text-muted">Complete your payment to activate chat feature</p>
        </div>
        
        <div class="text-center">
            <div class="amount-display">
                Rp <?php echo number_format($amount, 0, ',', '.'); ?>
            </div>
            <p class="lead"><?php echo $item_name; ?></p>
            <p class="text-muted"><?php echo $description; ?></p>
        </div>
        
        <div class="payment-details">
            <h5>Payment Details</h5>
            <table class="table">
                <tr>
                    <td>Order ID:</td>
                    <td class="text-end"><strong><?php echo $order_id; ?></strong></td>
                </tr>
                <tr>
                    <td>Customer:</td>
                    <td class="text-end"><?php echo $admin['nama']; ?></td>
                </tr>
                <tr>
                    <td>Email:</td>
                    <td class="text-end"><?php echo $admin['email']; ?></td>
                </tr>
                <tr>
                    <td>Date:</td>
                    <td class="text-end"><?php echo date('d F Y, H:i'); ?></td>
                </tr>
            </table>
        </div>
        
        <div class="payment-methods">
            <div class="payment-method">
                <img src="https://midtrans.com/assets/images/icons/payment_methods/credit_card.png" alt="Credit Card">
                <div class="small">Credit Card</div>
            </div>
            <div class="payment-method">
                <img src="https://midtrans.com/assets/images/icons/payment_methods/bca.png" alt="BCA">
                <div class="small">BCA</div>
            </div>
            <div class="payment-method">
                <img src="https://midtrans.com/assets/images/icons/payment_methods/gopay.png" alt="GoPay">
                <div class="small">GoPay</div>
            </div>
            <div class="payment-method">
                <img src="https://midtrans.com/assets/images/icons/payment_methods/indomaret.png" alt="Indomaret">
                <div class="small">Indomaret</div>
            </div>
        </div>
        
        <!-- Untuk testing, gunakan form sederhana -->
        <form method="POST" action="<?php echo base_url('payment/process_payment'); ?>">
            <input type="hidden" name="order_id" value="<?php echo $order_id; ?>">
            <input type="hidden" name="amount" value="<?php echo $amount; ?>">
            <input type="hidden" name="type" value="<?php echo $type; ?>">
            
            <div class="d-grid gap-2 mt-4">
                <!-- Tombol untuk testing (tanpa Midtrans) -->
                <button type="submit" class="btn btn-success btn-lg">
                    <i class="fas fa-check-circle"></i> Complete Payment (Test Mode)
                </button>
                
                <a href="<?php echo base_url('admin/dashboard'); ?>" class="btn btn-outline-secondary">
                    <i class="fas fa-times"></i> Cancel Payment
                </a>
            </div>
        </form>
        
        <div class="text-center mt-4">
            <p class="text-muted small">
                <i class="fas fa-lock"></i> Secure payment powered by Midtrans
            </p>
        </div>
    </div>
    
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    
    <script>
        // Simulasi pembayaran berhasil setelah 5 detik untuk testing
        setTimeout(function() {
            $('button[type="submit"]').html('<i class="fas fa-spinner fa-spin"></i> Processing...');
        }, 3000);
        
        // Auto submit untuk testing
        // setTimeout(function() {
        //     $('form').submit();
        // }, 5000);
    </script>
</body>
</html>