<?php
defined('BASEPATH') OR exit('No direct script access allowed');
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Pembayaran Fitur Chat - SistemKos</title>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Midtrans Snap JS -->
    <script type="text/javascript"
        src="<?php echo $this->config->item('snap_js_url', 'midtrans'); ?>"
        data-client-key="<?php echo $client_key; ?>"></script>
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    
    <style>
        body {
            background-color: #f8f9fa;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        .payment-container {
            max-width: 500px;
            margin: 30px auto;
            padding: 0 15px;
        }
        .payment-card {
            border: none;
            border-radius: 15px;
            box-shadow: 0 5px 25px rgba(0,0,0,0.1);
            overflow: hidden;
        }
        .payment-header {
            background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
            color: white;
            padding: 25px 30px;
            text-align: center;
        }
        .payment-body {
            padding: 30px;
            background-color: white;
        }
        .order-info {
            background-color: #f8f9fc;
            border-radius: 10px;
            padding: 20px;
            margin-bottom: 25px;
            border-left: 4px solid #4e73df;
        }
        .info-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 8px;
            padding-bottom: 8px;
            border-bottom: 1px solid #eee;
        }
        .info-row:last-child {
            border-bottom: none;
            margin-bottom: 0;
            padding-bottom: 0;
        }
        .info-label {
            font-weight: 600;
            color: #6c757d;
        }
        .info-value {
            font-weight: 600;
            color: #333;
        }
        .price-value {
            color: #4e73df;
            font-size: 1.3em;
        }
        #pay-button {
            background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
            border: none;
            padding: 15px;
            font-size: 16px;
            font-weight: 600;
            border-radius: 10px;
            transition: all 0.3s;
            width: 100%;
        }
        #pay-button:hover:not(:disabled) {
            transform: translateY(-2px);
            box-shadow: 0 7px 15px rgba(78, 115, 223, 0.3);
        }
        #pay-button:disabled {
            opacity: 0.7;
            cursor: not-allowed;
        }
        .loading-spinner {
            display: none;
            text-align: center;
            padding: 20px;
        }
        .security-badge {
            text-align: center;
            margin-top: 20px;
            color: #6c757d;
            font-size: 0.9em;
        }
        .payment-instruction {
            background-color: #e8f4fd;
            border-left: 4px solid #17a2b8;
            padding: 15px;
            border-radius: 5px;
            margin-top: 20px;
            font-size: 0.9em;
        }
        .payment-instruction h6 {
            color: #17a2b8;
            margin-bottom: 10px;
        }
        .test-card-info {
            background-color: #fff3cd;
            border-left: 4px solid #ffc107;
            padding: 15px;
            border-radius: 5px;
            margin-top: 20px;
            font-size: 0.85em;
        }
        .test-card-info h6 {
            color: #856404;
            margin-bottom: 10px;
        }
        .back-button {
            background-color: #6c757d;
            border: none;
            padding: 15px;
            font-size: 16px;
            border-radius: 10px;
            transition: all 0.3s;
            width: 100%;
        }
        .back-button:hover {
            background-color: #5a6268;
        }
    </style>
</head>
<body>
    <div class="payment-container">
        <div class="payment-card">
            <div class="payment-header">
                <h3><i class="fas fa-lock"></i> Pembayaran Aman</h3>
                <p class="mb-0">Selesaikan pembayaran untuk mengaktifkan fitur chat</p>
            </div>
            
            <div class="payment-body">
                <!-- Informasi Pesanan -->
                <div class="order-info">
                    <div class="info-row">
                        <span class="info-label">Order ID:</span>
                        <span class="info-value"><?php echo $order_id; ?></span>
                    </div>
                    <div class="info-row">
                        <span class="info-label">Pelanggan:</span>
                        <span class="info-value"><?php echo $admin_name; ?></span>
                    </div>
                    <div class="info-row">
                        <span class="info-label">Produk:</span>
                        <span class="info-value">Fitur Chat Premium</span>
                    </div>
                    <div class="info-row">
                        <span class="info-label">Durasi:</span>
                        <span class="info-value">30 Hari</span>
                    </div>
                    <div class="info-row">
                        <span class="info-label">Total Pembayaran:</span>
                        <span class="info-value price-value">Rp <?php echo number_format($amount, 0, ',', '.'); ?></span>
                    </div>
                </div>
                
                <!-- Loading Spinner -->
                <div class="loading-spinner" id="loadingSpinner">
                    <div class="spinner-border text-primary" style="width: 3rem; height: 3rem;" role="status">
                        <span class="visually-hidden">Loading...</span>
                    </div>
                    <p class="mt-3">Mempersiapkan pembayaran...</p>
                </div>
                
                <!-- Tombol Bayar -->
                <button id="pay-button" class="btn btn-primary mb-3">
                    <i class="fas fa-credit-card"></i> Bayar Sekarang
                </button>
                
                <!-- Tombol Kembali -->
                <a href="<?php echo site_url('admin/subscription'); ?>" class="btn btn-secondary back-button">
                    <i class="fas fa-arrow-left"></i> Kembali
                </a>
                
                <!-- Informasi Kartu Uji Coba (Sandbox Only) -->
                <?php if (!$this->config->item('is_production', 'midtrans')): ?>
                <div class="test-card-info">
                    <h6><i class="fas fa-vial"></i> Informasi Kartu Uji Coba (Sandbox)</h6>
                    <p class="mb-1"><strong>Kartu Kredit:</strong> 4811 1111 1111 1114</p>
                    <p class="mb-1"><strong>Expiry Date:</strong> Bulan/Tahun apapun di masa depan</p>
                    <p class="mb-1"><strong>CVV:</strong> 123</p>
                    <p class="mb-0"><strong>OTP:</strong> 112233</p>
                </div>
                <?php endif; ?>
                
                <!-- Instruksi Pembayaran -->
                <div class="payment-instruction">
                    <h6><i class="fas fa-info-circle"></i> Instruksi Pembayaran</h6>
                    <p class="mb-1">1. Klik tombol "Bayar Sekarang"</p>
                    <p class="mb-1">2. Pilih metode pembayaran yang diinginkan</p>
                    <p class="mb-1">3. Ikuti instruksi pada popup pembayaran</p>
                    <p class="mb-0">4. Tunggu konfirmasi pembayaran sukses</p>
                </div>
                
                <!-- Badge Keamanan -->
                <div class="security-badge">
                    <i class="fas fa-shield-alt"></i> Transaksi aman dan terenkripsi
                </div>
            </div>
        </div>
    </div>
    
    <script type="text/javascript">
        document.addEventListener('DOMContentLoaded', function() {
            const payButton = document.getElementById('pay-button');
            const loadingSpinner = document.getElementById('loadingSpinner');
            
            payButton.addEventListener('click', function() {
                // Tampilkan loading
                payButton.disabled = true;
                payButton.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Memproses...';
                loadingSpinner.style.display = 'block';
                
                // Trigger Snap popup
                snap.pay('<?php echo $snapToken; ?>', {
                    // Callback ketika popup dibuka
                    onOpen: function() {
                        // Sembunyikan loading ketika popup terbuka
                        loadingSpinner.style.display = 'none';
                    },
                    // Callback ketika pembayaran sukses
                    onSuccess: function(result) {
                        console.log('Payment success:', result);
                        // Redirect ke halaman sukses
                        window.location.href = '<?php echo base_url("payment/finish?order_id=" . $order_id . "&status_code=200&transaction_status=settlement"); ?>';
                    },
                    // Callback ketika pembayaran pending
                    onPending: function(result) {
                        console.log('Payment pending:', result);
                        // Tetap redirect ke halaman sukses untuk pending
                        window.location.href = '<?php echo base_url("payment/finish?order_id=" . $order_id . "&status_code=201&transaction_status=pending"); ?>';
                    },
                    // Callback ketika pembayaran error
                    onError: function(result) {
                        console.log('Payment error:', result);
                        // Redirect ke halaman gagal
                        window.location.href = '<?php echo base_url("payment/failed"); ?>';
                    },
                    // Callback ketika user menutup popup
                    onClose: function() {
                        console.log('Payment popup closed');
                        // Reset button state
                        payButton.disabled = false;
                        payButton.innerHTML = '<i class="fas fa-credit-card"></i> Bayar Sekarang';
                        loadingSpinner.style.display = 'none';
                    }
                });
            });
            
            // Auto trigger payment after 2 seconds (optional)
            // setTimeout(function() {
            //     payButton.click();
            // }, 2000);
        });
    </script>
    
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>