<!doctype html>
<html lang="id">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title><?php echo isset($title) ? $title : 'Complete Payment'; ?> - SistemKOS</title>
    
    <!-- 🔥 CRITICAL: Midtrans Snap.js -->
    <script type="text/javascript"
            src="<?= $is_production ? 'https://app.midtrans.com/snap/snap.js' : 'https://app.sandbox.midtrans.com/snap/snap.js' ?>"
            data-client-key="<?= $client_key ?>"></script>
</head>

<body>

    <!-- 🔥 MINIMAL SNAP TRIGGER - Pure Midtrans Only -->
    <script type="text/javascript">
        const SNAP_TOKEN = "<?= $snap_token ?>";
        const FINISH_URL = "<?= site_url('admin/subscription/finish') ?>?order_id=<?= $order_id ?>";
        const PENDING_URL = "<?= site_url('admin/subscription/pending') ?>?order_id=<?= $order_id ?>";
        const PRICING_URL = "<?= site_url('admin/subscription/pricing') ?>";
        
        window.addEventListener('load', function() {
            if (typeof snap === 'undefined') {
                alert('Payment system not loaded. Please refresh.');
                return;
            }
            
            setTimeout(function() {
                snap.pay(SNAP_TOKEN, {
                    onSuccess: function(result) {
                        window.location.href = FINISH_URL;
                    },
                    onPending: function(result) {
                        window.location.href = PENDING_URL;
                    },
                    onError: function(result) {
                        window.location.href = PRICING_URL;
                    },
                    onClose: function() {
                        window.location.href = PRICING_URL;
                    }
                });
            }, 300);
        });
    </script>
</body>
</html>