<!doctype html>
<html lang="id">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title><?php echo isset($title) ? $title : 'Pricing Plans'; ?> - SistemKOS</title>
    
    <!-- 🔥 FIX: Use CDN instead of local files -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        :root {
            --primary: #667eea;
            --secondary: #764ba2;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            padding: 60px 0;
        }

        .pricing-header {
            text-align: center;
            color: white;
            margin-bottom: 50px;
        }

        .pricing-header h1 {
            font-size: 42px;
            font-weight: bold;
            margin-bottom: 15px;
            text-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }

        .pricing-header p {
            font-size: 18px;
            opacity: 0.9;
        }

        .back-button {
            position: fixed;
            top: 20px;
            left: 20px;
            background: white;
            color: var(--primary);
            padding: 10px 20px;
            border-radius: 25px;
            text-decoration: none;
            box-shadow: 0 5px 15px rgba(0,0,0,0.2);
            transition: all 0.3s;
            z-index: 1000;
            font-weight: 600;
        }

        .back-button:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 20px rgba(0,0,0,0.3);
            color: var(--primary);
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
        }

        .pricing-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 30px;
            margin-bottom: 40px;
        }

        .pricing-card {
            background: white;
            border-radius: 20px;
            padding: 40px 30px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.2);
            transition: all 0.3s;
            position: relative;
            overflow: hidden;
        }

        .pricing-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
        }

        .pricing-card.featured {
            border: 3px solid #ffc107;
            transform: scale(1.05);
        }

        .pricing-card.featured::before {
            content: "MOST POPULAR";
            position: absolute;
            top: 20px;
            right: -35px;
            background: #ffc107;
            color: #333;
            padding: 5px 40px;
            transform: rotate(45deg);
            font-size: 12px;
            font-weight: bold;
        }

        .plan-name {
            font-size: 24px;
            font-weight: bold;
            color: #333;
            margin-bottom: 10px;
        }

        .plan-description {
            color: #666;
            font-size: 14px;
            margin-bottom: 20px;
            min-height: 40px;
        }

        .plan-price {
            font-size: 42px;
            font-weight: bold;
            color: var(--primary);
            margin-bottom: 5px;
        }

        .plan-price .currency {
            font-size: 20px;
            vertical-align: super;
        }

        .plan-duration {
            color: #999;
            font-size: 14px;
            margin-bottom: 30px;
        }

        .plan-features {
            list-style: none;
            padding: 0;
            margin: 30px 0;
        }

        .plan-features li {
            padding: 12px 0;
            border-bottom: 1px solid #f0f0f0;
            color: #555;
            display: flex;
            align-items: center;
        }

        .plan-features li i {
            color: #28a745;
            margin-right: 10px;
            font-size: 16px;
        }

        .plan-features li:last-child {
            border-bottom: none;
        }

        .btn-select-plan {
            width: 100%;
            padding: 15px;
            border: none;
            border-radius: 10px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s;
            background: linear-gradient(135deg, var(--primary) 0%, var(--secondary) 100%);
            color: white;
        }

        .btn-select-plan:hover:not(:disabled) {
            transform: translateY(-2px);
            box-shadow: 0 5px 20px rgba(102, 126, 234, 0.4);
        }

        .btn-select-plan.current {
            background: #28a745;
            cursor: default;
        }

        .btn-select-plan:disabled {
            background: #ccc;
            cursor: not-allowed;
        }

        /* Loading Overlay */
        .loading-overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0, 0, 0, 0.85);
            z-index: 9999;
            justify-content: center;
            align-items: center;
        }

        .loading-overlay.active {
            display: flex;
        }

        .loading-content {
            background: white;
            padding: 40px 50px;
            border-radius: 20px;
            text-align: center;
            box-shadow: 0 20px 60px rgba(0,0,0,0.5);
        }

        .spinner {
            border: 5px solid #f3f3f3;
            border-top: 5px solid var(--primary);
            border-radius: 50%;
            width: 60px;
            height: 60px;
            animation: spin 1s linear infinite;
            margin: 0 auto 20px;
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        .info-footer {
            text-align: center;
            margin-top: 40px;
            color: white;
            opacity: 0.8;
        }

        @media (max-width: 768px) {
            .pricing-grid {
                grid-template-columns: 1fr;
            }

            .pricing-card.featured {
                transform: scale(1);
            }

            .pricing-header h1 {
                font-size: 32px;
            }
        }
    </style>
</head>

<body>
    <!-- Back Button -->
    <a href="<?= site_url('admin/subscription') ?>" class="back-button">
        <i class="fas fa-arrow-left"></i> Back
    </a>

    <!-- Loading Overlay -->
    <div class="loading-overlay" id="loadingOverlay">
        <div class="loading-content">
            <div class="spinner"></div>
            <h4 style="margin-bottom: 10px;">Processing Payment...</h4>
            <p style="color: #666; margin: 0;">Please wait, redirecting to payment gateway</p>
        </div>
    </div>

    <div class="container">
        <!-- Header -->
        <div class="pricing-header">
            <h1><i class="fas fa-crown"></i> Choose Your Plan</h1>
            <p>Select the perfect plan for your boarding house management</p>
        </div>

        <!-- Pricing Cards -->
        <div class="pricing-grid">
            <?php if (!empty($plans)): ?>
                <?php foreach ($plans as $index => $plan): ?>
                    <?php
                    $features = json_decode($plan->features, true);
                    $is_featured = ($index == 1); // Middle plan is featured
                    $is_current = false;
                    
                    if (isset($active_subscription) && $active_subscription && $active_subscription->id_plan == $plan->id_plan) {
                        $is_current = true;
                    }
                    ?>
                    
                    <div class="pricing-card <?= $is_featured ? 'featured' : '' ?>">
                        <div class="plan-name"><?= htmlspecialchars($plan->plan_name) ?></div>
                        <div class="plan-description"><?= htmlspecialchars($plan->plan_description) ?></div>
                        
                        <div class="plan-price">
                            <span class="currency">Rp</span><?= number_format($plan->price, 0, ',', '.') ?>
                        </div>
                        <div class="plan-duration">per <?= $plan->duration_days ?> days</div>
                        
                        <ul class="plan-features">
                            <?php if ($features && is_array($features)): ?>
                                <?php foreach ($features as $feature): ?>
                                    <li>
                                        <i class="fas fa-check-circle"></i>
                                        <?= htmlspecialchars($feature) ?>
                                    </li>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </ul>
                        
                        <?php if ($is_current): ?>
                            <button class="btn-select-plan current" disabled>
                                <i class="fas fa-check"></i> Current Plan
                            </button>
                        <?php else: ?>
                            <button class="btn-select-plan" onclick="selectPlan(<?= $plan->id_plan ?>, '<?= htmlspecialchars($plan->plan_name, ENT_QUOTES) ?>')">
                                <i class="fas fa-shopping-cart"></i> Select Plan
                            </button>
                        <?php endif; ?>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <div style="grid-column: 1/-1; text-align: center; color: white; padding: 40px;">
                    <i class="fas fa-exclamation-circle" style="font-size: 48px; margin-bottom: 20px;"></i>
                    <h3>No Plans Available</h3>
                    <p>Please contact administrator</p>
                </div>
            <?php endif; ?>
        </div>

        <!-- Footer Info -->
        <div class="info-footer">
            <p><i class="fas fa-shield-alt"></i> Secure payment powered by Midtrans</p>
            <p style="margin-top: 10px; font-size: 14px;">All prices include VAT. Cancel anytime.</p>
        </div>
    </div>

    <!-- 🔥 Scripts from CDN -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        console.log('=== Pricing Page Loaded ===');
        
        // 🔥 FIX: Flag to control beforeunload warning
        let allowRedirect = false;
        
        function selectPlan(planId, planName) {
            console.log('Plan selected:', planId, planName);
            
            // Allow redirect without warning
            allowRedirect = true;
            
            // Show loading overlay immediately
            const overlay = document.getElementById('loadingOverlay');
            overlay.classList.add('active');
            
            // Build process URL
            const processUrl = '<?= site_url("admin/subscription/process/") ?>' + planId;
            console.log('Redirecting to:', processUrl);
            
            // Redirect immediately
            window.location.href = processUrl;
        }

        // 🔥 REMOVED: No more beforeunload warning
        // This was causing the "Keluar dari situs?" dialog

        // Handle browser back button
        window.addEventListener('pageshow', function(event) {
            if (event.persisted) {
                document.getElementById('loadingOverlay').classList.remove('active');
            }
        });

        // Auto-hide any alerts (if you add them later)
        setTimeout(function() {
            const alerts = document.querySelectorAll('.alert');
            alerts.forEach(function(alert) {
                alert.style.transition = 'opacity 0.3s';
                alert.style.opacity = '0';
                setTimeout(function() {
                    alert.remove();
                }, 300);
            });
        }, 5000);
    </script>
</body>
</html>