<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($title) ? $title . ' - Sistem Kos' : 'Sistem Kos'; ?></title>

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">

    <!-- Custom CSS -->
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f8f9fa;
        }

        .navbar-brand {
            font-weight: bold;
            color: #4e73df !important;
        }

        .sidebar {
            background: linear-gradient(180deg, #4e73df 0%, #224abe 100%);
            min-height: 100vh;
            color: white;
        }

        .sidebar .nav-link {
            color: rgba(255, 255, 255, .8);
            padding: 0.75rem 1rem;
            margin: 2px 0;
        }

        .sidebar .nav-link:hover {
            color: white;
            background: rgba(255, 255, 255, .1);
        }

        .sidebar .nav-link.active {
            color: white;
            background: rgba(255, 255, 255, .2);
        }

        .sidebar .nav-link i {
            margin-right: 10px;
            width: 20px;
            text-align: center;
        }

        .content-wrapper {
            padding: 20px;
        }

        .card {
            border: none;
            box-shadow: 0 0 15px rgba(0, 0, 0, .05);
            margin-bottom: 20px;
        }

        .card-header {
            background-color: white;
            border-bottom: 1px solid #e3e6f0;
            font-weight: 600;
        }

        .badge-notification {
            position: relative;
            top: -8px;
            left: -5px;
        }
    </style>
</head>

<body>
    <!-- Navbar -->
    <nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm">
        <div class="container-fluid">
            <a class="navbar-brand" href="<?php echo base_url('admin/dashboard'); ?>">
                <i class="fas fa-home"></i> Sistem Kos Admin
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown">
                            <i class="fas fa-user-circle"></i>
                            <?php echo $this->session->userdata('admin_name') ?? 'Admin'; ?>
                        </a>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="<?php echo site_url('admin/profile'); ?>">
                                    <i class="fas fa-user"></i> Profile
                                </a></li>
                            <li><a class="dropdown-item" href="<?php echo site_url('admin/subscription'); ?>">
                                    <i class="fas fa-crown"></i> Subscription
                                </a></li>
                            <li>
                                <hr class="dropdown-divider">
                            </li>
                            <li><a class="dropdown-item" href="<?php echo site_url('admin/logout'); ?>">
                                    <i class="fas fa-sign-out-alt"></i> Logout
                                </a></li>
                        </ul>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <div class="col-md-3 col-lg-2 d-md-block sidebar collapse">
                <div class="position-sticky pt-3">
                    <ul class="nav flex-column">
                        <li class="nav-item">
                            <a class="nav-link <?php echo ($this->uri->segment(2) == 'dashboard') ? 'active' : ''; ?>"
                                href="<?php echo site_url('admin/dashboard'); ?>">
                                <i class="fas fa-tachometer-alt"></i>
                                Dashboard
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo ($this->uri->segment(2) == 'kos') ? 'active' : ''; ?>"
                                href="<?php echo site_url('admin/kos'); ?>">
                                <i class="fas fa-home"></i>
                                Kos Management
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo ($this->uri->segment(2) == 'penghuni') ? 'active' : ''; ?>"
                                href="<?php echo site_url('admin/penghuni'); ?>">
                                <i class="fas fa-users"></i>
                                Penghuni
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo ($this->uri->segment(2) == 'laporan') ? 'active' : ''; ?>"
                                href="<?php echo site_url('admin/laporan'); ?>">
                                <i class="fas fa-clipboard-list"></i>
                                Laporan
                                <?php if (isset($pending_laporan_count) && $pending_laporan_count > 0): ?>
                                    <span class="badge bg-danger badge-notification"><?php echo $pending_laporan_count; ?></span>
                                <?php endif; ?>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo ($this->uri->segment(2) == 'chat') ? 'active' : ''; ?>"
                                href="<?php echo site_url('admin/chat'); ?>">
                                <i class="fas fa-comments"></i>
                                Chat
                                <?php if (isset($unread_chat_count) && $unread_chat_count > 0): ?>
                                    <span class="badge bg-danger badge-notification"><?php echo $unread_chat_count; ?></span>
                                <?php endif; ?>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo ($this->uri->segment(2) == 'subscription' || $this->uri->segment(2) == 'payment') ? 'active' : ''; ?>"
                                href="<?php echo site_url('admin/subscription'); ?>">
                                <i class="fas fa-crown"></i>
                                Subscription
                                <span class="badge bg-warning badge-notification" id="pending-payments-badge">0</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo ($this->uri->segment(2) == 'iklan') ? 'active' : ''; ?>"
                                href="<?php echo site_url('admin/iklan'); ?>">
                                <i class="fas fa-ad"></i>
                                Iklan
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo site_url('admin/logout'); ?>">
                                <i class="fas fa-sign-out-alt"></i>
                                Logout
                            </a>
                        </li>
                    </ul>
                </div>
            </div>

            <!-- Main Content -->
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3">
                    <h1 class="h2">
                        <?php
                        if (isset($title)) {
                            echo $title;
                        } else {
                            // Default title based on segment
                            $segments = $this->uri->segment_array();
                            if (!empty($segments[2])) {
                                echo ucfirst($segments[2]);
                            } else {
                                echo 'Dashboard';
                            }
                        }
                        ?>
                    </h1>
                    <div class="btn-toolbar mb-2 mb-md-0">
                        <?php if (isset($header_buttons)): ?>
                            <?php echo $header_buttons; ?>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Flash Messages -->
                <?php if ($this->session->flashdata('success')): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <?php echo $this->session->flashdata('success'); ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>

                <?php if ($this->session->flashdata('error')): ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <?php echo $this->session->flashdata('error'); ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>

                <?php if ($this->session->flashdata('warning')): ?>
                    <div class="alert alert-warning alert-dismissible fade show" role="alert">
                        <?php echo $this->session->flashdata('warning'); ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>