<?php
// Pastikan admin_id tersedia
$admin_id = isset($admin_id) ? $admin_id : $this->session->userdata('admin_id');

// Load model
$this->load->model('Payment_model', 'payment_model');
$has_active_subscription = $this->payment_model->check_admin_subscription($admin_id);

if (!$has_active_subscription): ?>
<div class="alert alert-warning" id="payment-widget">
    <div class="d-flex align-items-center">
        <div class="flex-shrink-0">
            <i class="fas fa-lock fa-2x"></i>
        </div>
        <div class="flex-grow-1 ms-3">
            <h5 class="alert-heading mb-2">Fitur Chat Terkunci</h5>
            <p class="mb-3">Anda perlu berlangganan untuk menggunakan fitur chat.</p>
            
            <div class="card border-warning">
                <div class="card-body">
                    <h6 class="card-title">Paket Chat 1 Bulan</h6>
                    <h3 class="text-warning">Rp 100.000</h3>
                    <p class="text-muted">Akses fitur chat selama 30 hari</p>
                    
                    <div class="row mb-3">
                        <div class="col-6">
                            <ul class="list-unstyled">
                                <li><i class="fas fa-check text-success"></i> Chat real-time</li>
                                <li><i class="fas fa-check text-success"></i> Kirim file</li>
                            </ul>
                        </div>
                        <div class="col-6">
                            <ul class="list-unstyled">
                                <li><i class="fas fa-check text-success"></i> Notifikasi</li>
                                <li><i class="fas fa-check text-success"></i> Riwayat chat</li>
                            </ul>
                        </div>
                    </div>
                    
                    <a href="<?php echo base_url('payment/checkout'); ?>" class="btn btn-warning w-100">
                        <i class="fas fa-shopping-cart"></i> Aktifkan Sekarang
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
<?php else: ?>
<div class="alert alert-success">
    <div class="d-flex align-items-center">
        <div class="flex-shrink-0">
            <i class="fas fa-check-circle fa-2x"></i>
        </div>
        <div class="flex-grow-1 ms-3">
            <h5 class="alert-heading">Fitur Chat Aktif</h5>
            <p>Anda dapat menggunakan fitur chat sekarang.</p>
            <a href="<?php echo base_url('admin/chat'); ?>" class="btn btn-success">
                <i class="fas fa-comments"></i> Buka Chat
            </a>
        </div>
    </div>
</div>
<?php endif; ?>