<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Verifikasi Kode - KosCare Admin</title>
    <link rel="stylesheet" href="<?= base_url('asset/css/bootstrap.min.css') ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        body {
            background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        .card {
            background: white;
            border-radius: 15px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.2);
            width: 100%;
            max-width: 550px;
            padding: 40px 30px;
        }
        .code-input {
            font-size: 2rem;
            text-align: center;
            letter-spacing: 10px;
            font-weight: bold;
            height: 60px;
        }
        .user-info {
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
            border-radius: 10px;
            padding: 20px;
            margin-bottom: 25px;
            border: 1px solid #dee2e6;
        }
        .code-display-section {
            background: #f8fbff;
            border-radius: 12px;
            padding: 25px;
            margin: 25px 0;
            border: 2px solid #4a90e2;
            box-shadow: 0 5px 15px rgba(74, 144, 226, 0.1);
        }
        .display-code {
            font-size: 42px;
            font-weight: bold;
            letter-spacing: 8px;
            color: #4a90e2;
            font-family: 'Courier New', monospace;
            margin: 15px 0;
            text-align: center;
            background: white;
            padding: 15px;
            border-radius: 8px;
            border: 2px dashed #4a90e2;
        }
        .code-instruction {
            font-size: 14px;
            color: #6c757d;
            text-align: center;
            margin-top: 10px;
        }
        .alert-success {
            background: #d4edda;
            color: #155724;
            border-left: 4px solid #28a745;
        }
        .alert-info {
            background: #d1ecf1;
            color: #0c5460;
            border-left: 4px solid #17a2b8;
        }
        .alert-danger {
            background: #f8d7da;
            color: #721c24;
            border-left: 4px solid #dc3545;
        }
        .timer-badge {
            background: #ffc107;
            color: #856404;
            padding: 5px 12px;
            border-radius: 20px;
            font-size: 13px;
            font-weight: bold;
            display: inline-block;
            margin-left: 10px;
        }
        .btn-copy {
            background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
            color: white;
            border: none;
            padding: 10px 20px;
            border-radius: 8px;
            transition: all 0.3s;
        }
        .btn-copy:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(74, 144, 226, 0.3);
        }
        .btn-verify {
            background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
            color: white;
            border: none;
            padding: 14px;
            font-size: 16px;
            font-weight: 600;
            border-radius: 10px;
            transition: all 0.3s;
        }
        .btn-verify:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 20px rgba(40, 167, 69, 0.4);
        }
    </style>
</head>
<body>
    <div class="card">
        <h3 class="text-center mb-4">
            <i class="fas fa-shield-alt text-primary mr-2"></i>
            Verifikasi Kode Reset
        </h3>
        
        <div class="user-info">
            <div class="row">
                <div class="col-md-6">
                    <p class="mb-2">
                        <i class="fas fa-user mr-2"></i>
                        <strong>Nama:</strong> <?= htmlspecialchars($admin_name ?? 'Admin') ?>
                    </p>
                </div>
                <div class="col-md-6">
                    <p class="mb-2">
                        <i class="fas fa-envelope mr-2"></i>
                        <strong>Email:</strong> <?= htmlspecialchars($email) ?>
                    </p>
                </div>
            </div>
            <p class="mb-0 text-muted">
                <i class="fas fa-info-circle mr-1"></i>
                Masukkan kode 6 digit di bawah untuk melanjutkan
            </p>
        </div>
        
        <?php if ($this->session->flashdata('success')): ?>
            <div class="alert alert-success">
                <i class="fas fa-check-circle mr-2"></i>
                <?= $this->session->flashdata('success') ?>
            </div>
        <?php endif; ?>
        
        <?php if ($this->session->flashdata('info')): ?>
            <div class="alert alert-info">
                <i class="fas fa-info-circle mr-2"></i>
                <?= $this->session->flashdata('info') ?>
            </div>
        <?php endif; ?>
        
        <?php if ($this->session->flashdata('error')): ?>
            <div class="alert alert-danger">
                <i class="fas fa-exclamation-circle mr-2"></i>
                <?= $this->session->flashdata('error') ?>
            </div>
        <?php endif; ?>
        
        <!-- TAMPILKAN KODE -->
        <?php if (isset($display_code)): ?>
        <div class="code-display-section">
            <h5 class="text-center mb-3">
                <i class="fas fa-key mr-2"></i>
                Kode Reset Password Anda
                <span class="timer-badge">
                    <i class="fas fa-clock mr-1"></i>30 menit
                </span>
            </h5>
            
            <div class="display-code" id="codeDisplay"><?= $display_code ?></div>
            
            <p class="code-instruction">
                <i class="fas fa-mouse-pointer mr-1"></i>
                Klik tombol di bawah untuk menyalin kode
            </p>
            
            <div class="text-center mt-3">
                <button class="btn-copy" onclick="copyToClipboard()">
                    <i class="fas fa-copy mr-2"></i> Salin Kode
                </button>
                <div class="mt-2">
                    <small class="text-success" id="copySuccess" style="display: none;">
                        <i class="fas fa-check mr-1"></i> Kode berhasil disalin!
                    </small>
                </div>
            </div>
        </div>
        <?php endif; ?>
        
        <form method="post" action="<?= site_url('admin/forgot_password/verify_code') ?>" id="verifyForm">
            <input type="hidden" name="email" value="<?= htmlspecialchars($email) ?>">
            
            <div class="form-group mb-4">
                <label for="code" class="font-weight-bold">
                    <i class="fas fa-keyboard mr-2"></i>Masukkan Kode Verifikasi
                </label>
                <input type="text" 
                       class="form-control code-input" 
                       id="code" 
                       name="code" 
                       maxlength="6" 
                       pattern="[0-9]{6}" 
                       placeholder="000000" 
                       required
                       oninput="this.value = this.value.replace(/[^0-9]/g, '')">
                <small class="form-text text-muted">
                    <i class="fas fa-lightbulb mr-1"></i>
                    Masukkan 6 digit kode yang telah diberikan
                </small>
            </div>
            
            <button type="submit" class="btn-verify btn-block mb-3">
                <i class="fas fa-check-circle mr-2"></i> Verifikasi & Lanjutkan
            </button>
            
            <div class="row">
                <div class="col-md-6">
                    <a href="<?= site_url('admin/forgot_password/resend_code') ?>" class="btn btn-outline-primary btn-block">
                        <i class="fas fa-sync-alt mr-1"></i> Kode Baru
                    </a>
                </div>
                <div class="col-md-6">
                    <a href="<?= site_url('admin/forgot_password/cancel') ?>" class="btn btn-outline-danger btn-block">
                        <i class="fas fa-times mr-1"></i> Batalkan
                    </a>
                </div>
            </div>
        </form>
        
        <div class="mt-4 text-center">
            <a href="<?= site_url('admin/login') ?>" class="text-primary">
                <i class="fas fa-arrow-left mr-1"></i> Kembali ke Login
            </a>
        </div>
    </div>
    
    <script>
        // Auto-focus on code input
        document.getElementById('code').focus();
        
        // Auto submit when 6 digits entered
        document.getElementById('code').addEventListener('input', function(e) {
            if (this.value.length === 6) {
                // Small delay to show the last digit
                setTimeout(() => {
                    document.getElementById('verifyForm').submit();
                }, 500);
            }
        });
        
        // Copy code to clipboard function
        function copyToClipboard() {
            const code = document.getElementById('codeDisplay').textContent;
            navigator.clipboard.writeText(code).then(() => {
                const successMsg = document.getElementById('copySuccess');
                successMsg.style.display = 'block';
                setTimeout(() => {
                    successMsg.style.display = 'none';
                }, 3000);
                
                // Auto paste to input field
                document.getElementById('code').value = code;
                document.getElementById('code').focus();
            }).catch(err => {
                alert('Gagal menyalin kode. Silakan salin manual: ' + code);
            });
        }
        
        // Timer countdown
        let timer = 30 * 60; // 30 minutes in seconds
        const timerElement = document.querySelector('.timer-badge');
        
        function updateTimer() {
            if (!timerElement) return;
            
            const minutes = Math.floor(timer / 60);
            const seconds = timer % 60;
            
            timerElement.innerHTML = `<i class="fas fa-clock mr-1"></i>${minutes}:${seconds.toString().padStart(2, '0')}`;
            
            if (timer > 0) {
                timer--;
                setTimeout(updateTimer, 1000);
            } else {
                timerElement.innerHTML = '<i class="fas fa-exclamation-triangle mr-1"></i>Kadaluarsa';
                timerElement.style.background = '#dc3545';
                timerElement.style.color = 'white';
            }
        }
        
        // Start timer
        if (document.querySelector('.timer-badge')) {
            updateTimer();
        }
        
        // Form loading state
        document.getElementById('verifyForm').addEventListener('submit', function(e) {
            const btn = this.querySelector('.btn-verify');
            const originalHTML = btn.innerHTML;
            btn.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i> Memverifikasi...';
            btn.disabled = true;
            
            // Re-enable after 5 seconds
            setTimeout(() => {
                btn.innerHTML = originalHTML;
                btn.disabled = false;
            }, 5000);
        });
    </script>
</body>
</html>