<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Reset Password - KosCare</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }
        .header {
            background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
            color: white;
            padding: 30px;
            text-align: center;
            border-radius: 10px 10px 0 0;
        }
        .content {
            background: #f9f9f9;
            padding: 30px;
            border-radius: 0 0 10px 10px;
        }
        .otp-code {
            background: #fff;
            border: 2px dashed #4a90e2;
            padding: 20px;
            text-align: center;
            font-size: 32px;
            font-weight: bold;
            letter-spacing: 10px;
            color: #4a90e2;
            margin: 20px 0;
            border-radius: 8px;
        }
        .warning {
            background: #fff3cd;
            border: 1px solid #ffeaa7;
            padding: 15px;
            border-radius: 5px;
            margin: 20px 0;
            color: #856404;
        }
        .footer {
            text-align: center;
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #ddd;
            color: #666;
            font-size: 12px;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>KosCare</h1>
        <p>Reset Password</p>
    </div>
    
    <div class="content">
        <h2>Halo,</h2>
        <p>Anda menerima email ini karena meminta reset password untuk akun KosCare Anda.</p>
        
        <p>Gunakan kode OTP berikut untuk melanjutkan proses reset password:</p>
        
        <div class="otp-code">
            <?= $otp ?>
        </div>
        
        <p>Kode ini akan kadaluarsa dalam <strong><?= $expiry ?></strong>.</p>
        
        <div class="warning">
            <p><strong>⚠️ PERHATIAN:</strong></p>
            <p>Jangan berikan kode ini kepada siapa pun, termasuk tim support kami.</p>
            <p>Jika Anda tidak meminta reset password, abaikan email ini.</p>
        </div>
        
        <p>Terima kasih,<br>
        <strong>Tim KosCare</strong></p>
    </div>
    
    <div class="footer">
        <p>Email ini dikirim secara otomatis. Mohon tidak membalas email ini.</p>
        <p>© <?= date('Y') ?> KosCare. All rights reserved.</p>
    </div>
</body>
</html>