<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>KosCare - Sistem Manajemen Kos Modern</title>
    <link rel="stylesheet" href="<?= base_url('asset/css/bootstrap.min.css') ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            color: #333;
            overflow-x: hidden;
        }

        /* Navbar */
        .navbar {
            background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
            padding: 15px 0;
            box-shadow: 0 2px 15px rgba(0, 0, 0, 0.1);
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            z-index: 1000;
            transition: all 0.3s;
        }

        .navbar.scrolled {
            padding: 10px 0;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.15);
        }

        .navbar-container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .navbar-brand {
            display: flex;
            align-items: center;
            gap: 15px;
            color: white;
            text-decoration: none;
            font-size: 1.5rem;
            font-weight: 600;
            transition: transform 0.3s;
        }

        .navbar-brand:hover {
            transform: scale(1.05);
            color: white;
        }

        .navbar-brand img {
            width: 45px;
            height: 45px;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.2);
            padding: 5px;
        }

        .navbar-menu {
            display: flex;
            gap: 30px;
            align-items: center;
        }

        .navbar-menu a {
            color: white;
            text-decoration: none;
            font-weight: 500;
            transition: all 0.3s;
            position: relative;
        }

        .navbar-menu a::after {
            content: '';
            position: absolute;
            bottom: -5px;
            left: 0;
            width: 0;
            height: 2px;
            background: white;
            transition: width 0.3s;
        }

        .navbar-menu a:hover::after {
            width: 100%;
        }

        .btn-nav {
            background: white;
            color: #4a90e2;
            padding: 10px 25px;
            border-radius: 25px;
            font-weight: 600;
            transition: all 0.3s;
            border: 2px solid white;
            cursor: pointer;
        }

        .btn-nav:hover {
            background: transparent;
            color: white;
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(255, 255, 255, 0.3);
        }

        .btn-nav-secondary {
            background: transparent;
            color: white;
            border: 2px solid white;
        }

        .btn-nav-secondary:hover {
            background: white;
            color: #4a90e2;
        }

        /* Modal Styles */
        .modal-overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.7);
            z-index: 2000;
            align-items: center;
            justify-content: center;
            animation: fadeIn 0.3s ease-out;
        }

        .modal-overlay.active {
            display: flex;
        }

        .modal-content {
            background: white;
            border-radius: 20px;
            width: 90%;
            max-width: 500px;
            padding: 40px;
            text-align: center;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
            animation: slideUp 0.4s ease-out;
            position: relative;
        }

        .modal-close {
            position: absolute;
            top: 20px;
            right: 20px;
            background: none;
            border: none;
            font-size: 1.5rem;
            color: #666;
            cursor: pointer;
            transition: color 0.3s;
        }

        .modal-close:hover {
            color: #4a90e2;
        }

        .modal-icon {
            width: 80px;
            height: 80px;
            background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 20px;
            font-size: 2.5rem;
            color: white;
        }

        .modal-content h2 {
            color: #333;
            font-size: 2rem;
            margin-bottom: 10px;
        }

        .modal-content p {
            color: #666;
            margin-bottom: 30px;
            font-size: 1.1rem;
            line-height: 1.6;
        }

        .modal-buttons {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 20px;
            margin-top: 30px;
        }

        .modal-btn {
            padding: 20px;
            border-radius: 15px;
            text-decoration: none;
            font-weight: 600;
            font-size: 1.1rem;
            transition: all 0.3s;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            gap: 10px;
            border: 2px solid transparent;
        }

        .modal-btn:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.15);
        }

        .modal-btn-owner {
            background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
            color: white;
        }

        .modal-btn-owner:hover {
            border-color: #4a90e2;
            background: white;
            color: #4a90e2;
        }

        .modal-btn-tenant {
            background: linear-gradient(135deg, #2ecc71 0%, #27ae60 100%);
            color: white;
        }

        .modal-btn-tenant:hover {
            border-color: #2ecc71;
            background: white;
            color: #2ecc71;
        }

        .modal-btn i {
            font-size: 2rem;
            margin-bottom: 10px;
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
            }

            to {
                opacity: 1;
            }
        }

        @keyframes slideUp {
            from {
                opacity: 0;
                transform: translateY(50px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* Hero Section */
        .hero {
            background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
            padding: 120px 20px 80px;
            position: relative;
            overflow: hidden;
        }

        .hero::before {
            content: '';
            position: absolute;
            top: -50%;
            right: -10%;
            width: 600px;
            height: 600px;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 50%;
            animation: float 20s infinite ease-in-out;
        }

        .hero::after {
            content: '';
            position: absolute;
            bottom: -30%;
            left: -5%;
            width: 400px;
            height: 400px;
            background: rgba(255, 255, 255, 0.05);
            border-radius: 50%;
            animation: float 15s infinite ease-in-out reverse;
        }

        @keyframes float {

            0%,
            100% {
                transform: translateY(0) rotate(0deg);
            }

            50% {
                transform: translateY(-30px) rotate(180deg);
            }
        }

        .hero-container {
            max-width: 1200px;
            margin: 0 auto;
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 60px;
            align-items: center;
            position: relative;
            z-index: 1;
        }

        .hero-content h1 {
            color: white;
            font-size: 3rem;
            font-weight: 700;
            margin-bottom: 20px;
            line-height: 1.2;
            animation: slideInLeft 0.8s ease-out;
        }

        @keyframes slideInLeft {
            from {
                opacity: 0;
                transform: translateX(-50px);
            }

            to {
                opacity: 1;
                transform: translateX(0);
            }
        }

        .hero-content p {
            color: rgba(255, 255, 255, 0.95);
            font-size: 1.2rem;
            margin-bottom: 30px;
            line-height: 1.8;
            animation: slideInLeft 0.8s ease-out 0.2s both;
        }

        .hero-buttons {
            display: flex;
            gap: 15px;
            flex-wrap: wrap;
            animation: slideInLeft 0.8s ease-out 0.4s both;
        }

        .btn-hero {
            padding: 15px 35px;
            border-radius: 30px;
            font-weight: 600;
            text-decoration: none;
            transition: all 0.3s;
            display: inline-flex;
            align-items: center;
            gap: 10px;
            font-size: 1.1rem;
            cursor: pointer;
            border: none;
        }

        .btn-primary {
            background: white;
            color: #4a90e2;
        }

        .btn-primary:hover {
            transform: translateY(-3px);
            box-shadow: 0 10px 30px rgba(255, 255, 255, 0.3);
            color: #4a90e2;
        }

        .btn-outline {
            background: transparent;
            color: white;
            border: 2px solid white;
        }

        .btn-outline:hover {
            background: white;
            color: #4a90e2;
            transform: translateY(-3px);
        }

        .hero-image {
            position: relative;
            animation: slideInRight 0.8s ease-out;
        }

        @keyframes slideInRight {
            from {
                opacity: 0;
                transform: translateX(50px);
            }

            to {
                opacity: 1;
                transform: translateX(0);
            }
        }

        .hero-image img {
            width: 100%;
            max-width: 500px;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
            animation: floatImage 3s infinite ease-in-out;
        }

        @keyframes floatImage {

            0%,
            100% {
                transform: translateY(0);
            }

            50% {
                transform: translateY(-20px);
            }
        }

        /* Pricing Section */
        .pricing {
            padding: 80px 20px;
            background: #f8fafc;
        }

        .section-header {
            text-align: center;
            max-width: 700px;
            margin: 0 auto 60px;
        }

        .section-header h2 {
            color: #4a90e2;
            font-size: 2.5rem;
            font-weight: 700;
            margin-bottom: 15px;
        }

        .section-header p {
            color: #666;
            font-size: 1.1rem;
            line-height: 1.8;
        }

        .pricing-grid {
            max-width: 1200px;
            margin: 0 auto;
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(350px, 1fr));
            gap: 30px;
        }

        .pricing-card {
            background: white;
            border-radius: 20px;
            overflow: hidden;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            transition: all 0.3s;
            position: relative;
        }

        .pricing-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 20px 40px rgba(74, 144, 226, 0.2);
        }

        .pricing-card.best {
            border: 3px solid #4a90e2;
            transform: scale(1.05);
        }

        .pricing-card.best:hover {
            transform: scale(1.05) translateY(-10px);
        }

        .pricing-header {
            padding: 40px 30px;
            text-align: center;
            background: linear-gradient(135deg, #f8fafc 0%, #e8eff8 100%);
        }

        .pricing-card.best .pricing-header {
            background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
        }

        .pricing-title {
            font-size: 1.5rem;
            font-weight: 700;
            margin-bottom: 15px;
            color: #333;
        }

        .pricing-card.best .pricing-title {
            color: white;
        }

        .pricing-subtitle {
            color: #666;
            font-size: 1rem;
            margin-bottom: 20px;
        }

        .pricing-card.best .pricing-subtitle {
            color: rgba(255, 255, 255, 0.9);
        }

        .pricing-price {
            font-size: 3rem;
            font-weight: 800;
            color: #4a90e2;
        }

        .pricing-card.best .pricing-price {
            color: white;
        }

        .pricing-price span {
            font-size: 1rem;
            color: #666;
        }

        .pricing-card.best .pricing-price span {
            color: rgba(255, 255, 255, 0.9);
        }

        .pricing-features {
            padding: 30px;
        }

        .feature-title {
            font-weight: 600;
            margin-bottom: 20px;
            color: #333;
            font-size: 1.2rem;
        }

        .feature-list {
            list-style: none;
            margin-bottom: 30px;
        }

        .feature-list li {
            padding: 10px 0;
            display: flex;
            align-items: center;
            gap: 10px;
            color: #555;
        }

        .feature-list i {
            color: #4a90e2;
        }

        .pricing-action {
            text-align: center;
            padding: 0 30px 40px;
        }

        .btn-pricing {
            display: inline-block;
            padding: 15px 40px;
            border-radius: 25px;
            font-weight: 600;
            text-decoration: none;
            transition: all 0.3s;
            width: 100%;
            text-align: center;
        }

        .btn-pricing-free {
            background: #e8eff8;
            color: #4a90e2;
            border: 2px solid #4a90e2;
        }

        .btn-pricing-free:hover {
            background: #4a90e2;
            color: white;
            transform: translateY(-3px);
        }

        .btn-pricing-premium {
            background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
            color: white;
            border: 2px solid #4a90e2;
        }

        .btn-pricing-premium:hover {
            background: white;
            color: #4a90e2;
            transform: translateY(-3px);
        }

        .pricing-badge {
            position: absolute;
            top: 20px;
            right: 20px;
            background: #2ecc71;
            color: white;
            padding: 5px 15px;
            border-radius: 15px;
            font-size: 0.8rem;
            font-weight: 600;
        }

        /* Features Detail Section */
        .features-detail {
            padding: 80px 20px;
            background: white;
        }

        .features-detail-container {
            max-width: 1200px;
            margin: 0 auto;
        }

        .features-detail-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 40px;
        }

        .feature-detail-card {
            background: #f8fafc;
            padding: 40px 30px;
            border-radius: 15px;
            transition: all 0.3s;
            border-left: 5px solid #4a90e2;
        }

        .feature-detail-card:hover {
            background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
            transform: translateY(-5px);
        }

        .feature-detail-card:hover .feature-detail-title,
        .feature-detail-card:hover .feature-detail-desc {
            color: white;
        }

        .feature-detail-icon {
            width: 60px;
            height: 60px;
            background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 25px;
            font-size: 1.5rem;
            color: white;
        }

        .feature-detail-card:hover .feature-detail-icon {
            background: white;
            color: #4a90e2;
        }

        .feature-detail-title {
            font-size: 1.5rem;
            font-weight: 700;
            margin-bottom: 15px;
            color: #333;
        }

        .feature-detail-desc {
            color: #666;
            line-height: 1.8;
        }

        /* About Section */
        .about {
            padding: 80px 20px;
            background: #f8fafc;
        }

        .about-container {
            max-width: 1200px;
            margin: 0 auto;
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 60px;
            align-items: center;
        }

        .about-image img {
            width: 100%;
            border-radius: 15px;
            box-shadow: 0 15px 40px rgba(0, 0, 0, 0.1);
        }

        .about-content h2 {
            color: #4a90e2;
            font-size: 2.5rem;
            font-weight: 700;
            margin-bottom: 20px;
        }

        .about-content p {
            color: #666;
            font-size: 1.1rem;
            line-height: 1.8;
            margin-bottom: 20px;
        }

        .about-list {
            list-style: none;
            margin: 30px 0;
        }

        .about-list li {
            color: #555;
            padding: 12px 0;
            display: flex;
            align-items: center;
            gap: 15px;
            font-size: 1.05rem;
        }

        .about-list i {
            color: #4a90e2;
            font-size: 1.2rem;
        }

        /* CTA Section */
        .cta {
            padding: 80px 20px;
            background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
            text-align: center;
            position: relative;
            overflow: hidden;
        }

        .cta::before {
            content: '';
            position: absolute;
            top: -50%;
            left: -10%;
            width: 500px;
            height: 500px;
            background: rgba(255, 255, 255, 0.05);
            border-radius: 50%;
        }

        .cta-content {
            max-width: 800px;
            margin: 0 auto;
            position: relative;
            z-index: 1;
        }

        .cta h2 {
            color: white;
            font-size: 2.5rem;
            font-weight: 700;
            margin-bottom: 20px;
        }

        .cta p {
            color: rgba(255, 255, 255, 0.95);
            font-size: 1.2rem;
            margin-bottom: 30px;
        }

        /* Footer */
        .footer {
            background: #2c3e50;
            color: white;
            padding: 60px 20px 30px;
        }

        .footer-container {
            max-width: 1200px;
            margin: 0 auto;
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 40px;
            margin-bottom: 40px;
        }

        .footer-section h3 {
            margin-bottom: 20px;
            font-size: 1.3rem;
        }

        .footer-section p {
            color: rgba(255, 255, 255, 0.8);
            line-height: 1.8;
            margin-bottom: 15px;
        }

        .footer-section ul {
            list-style: none;
        }

        .footer-section ul li {
            margin-bottom: 12px;
        }

        .footer-section ul li a {
            color: rgba(255, 255, 255, 0.8);
            text-decoration: none;
            transition: all 0.3s;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .footer-section ul li a:hover {
            color: #4a90e2;
            padding-left: 5px;
        }

        .social-links {
            display: flex;
            gap: 15px;
            margin-top: 20px;
        }

        .social-links a {
            width: 40px;
            height: 40px;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            transition: all 0.3s;
        }

        .social-links a:hover {
            background: #4a90e2;
            transform: translateY(-3px);
        }

        .footer-bottom {
            border-top: 1px solid rgba(255, 255, 255, 0.1);
            padding-top: 30px;
            text-align: center;
            color: rgba(255, 255, 255, 0.7);
        }

        /* Mobile Menu */
        .mobile-menu-toggle {
            display: none;
            background: none;
            border: none;
            color: white;
            font-size: 1.5rem;
            cursor: pointer;
        }

        @media (max-width: 768px) {
            .navbar-menu {
                display: none;
                position: absolute;
                top: 100%;
                left: 0;
                right: 0;
                background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
                flex-direction: column;
                padding: 20px;
                gap: 15px;
                box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
            }

            .navbar-menu.active {
                display: flex;
            }

            .mobile-menu-toggle {
                display: block;
            }

            .modal-buttons {
                grid-template-columns: 1fr;
            }

            .hero-container,
            .about-container {
                grid-template-columns: 1fr;
                gap: 40px;
            }

            .hero-content h1 {
                font-size: 2rem;
            }

            .hero-image img {
                max-width: 100%;
            }

            .section-header h2,
            .about-content h2,
            .cta h2 {
                font-size: 2rem;
            }

            .pricing-grid {
                grid-template-columns: 1fr;
            }

            .pricing-card.best {
                transform: none;
            }

            .features-detail-grid {
                grid-template-columns: 1fr;
            }
        }

        /* Scroll to top button */
        .scroll-top {
            position: fixed;
            bottom: 30px;
            right: 30px;
            width: 50px;
            height: 50px;
            background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 1.2rem;
            cursor: pointer;
            opacity: 0;
            visibility: hidden;
            transition: all 0.3s;
            z-index: 999;
            box-shadow: 0 5px 15px rgba(74, 144, 226, 0.4);
        }

        .scroll-top.visible {
            opacity: 1;
            visibility: visible;
        }

        .scroll-top:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 25px rgba(74, 144, 226, 0.5);
        }
    </style>
</head>

<body>
    <!-- Modal Pilihan Daftar -->
    <div class="modal-overlay" id="registerModal">
        <div class="modal-content">
            <button class="modal-close" id="modalClose">&times;</button>
            <div class="modal-icon">
                <i class="fas fa-user-plus"></i>
            </div>
            <h2>Daftar Sebagai</h2>
            <p>Pilih peran Anda untuk melanjutkan pendaftaran</p>
            <div class="modal-buttons">
                <a href="<?= site_url('admin/register') ?>" class="modal-btn modal-btn-owner">
                    <i class="fas fa-home"></i>
                    <span>Pemilik Kos</span>
                    <small>Kelola properti kos Anda</small>
                </a>
                <a href="<?= site_url('user/register') ?>" class="modal-btn modal-btn-tenant">
                    <i class="fas fa-user"></i>
                    <span>Penghuni</span>
                    <small>Tinggal di kos yang nyaman</small>
                </a>
            </div>
        </div>
    </div>

    <!-- Navbar -->
    <nav class="navbar">
        <div class="navbar-container">
            <a href="<?= base_url() ?>" class="navbar-brand">
                <img src="<?= base_url('Asset/logo.png') ?>" alt="Logo KosCare">
                <span>KosCare</span>
            </a>
            <button class="mobile-menu-toggle" id="mobileMenuToggle">
                <i class="fas fa-bars"></i>
            </button>
            <div class="navbar-menu" id="navbarMenu">
                <a href="#home">Beranda</a>
                <a href="#features">Fitur</a>
                <a href="#about">Tentang</a>
                <a href="#pricing">Paket</a>
                <button class="btn-nav" id="registerBtnNav">
                    <i class="fas fa-user-plus"></i> Daftar
                </button>
            </div>
        </div>
    </nav>

    <!-- Hero Section -->
    <section class="hero" id="home">
        <div class="hero-container">
            <div class="hero-content">
                <h1>Kelola Kos Anda dengan Lebih Mudah & Efisien</h1>
                <p>Tidak perlu lagi bingung mencari pesan di grup atau chat pribadi. Dengan KosCare, setiap laporan penghuni tercatat rapi, statusnya bisa dipantau,
                    dan semua pihak bisa tahu perkembangan perbaikan secara langsung.</p>
                <div class="hero-buttons">
                    <button class="btn-hero btn-primary" id="registerBtnHero">
                        <i class="fas fa-rocket"></i> Mulai Sekarang
                    </button>
                    <a href="#pricing" class="btn-hero btn-outline">
                        <i class="fas fa-info-circle"></i> Lihat Paket
                    </a>
                </div>
            </div>
            <div class="hero-image">
                <img src="<?= base_url('asset/logo 2.png') ?>" alt="Hero Image">
            </div>
        </div>
    </section>
    <!-- Features Detail Section -->
    <section class="features-detail" id="features">
        <div class="features-detail-container">
            <div class="section-header">
                <h2>Fitur Unggulan</h2>
                <p>Memudahkan penghuni kos melapor masalah secara online, memantau status laporan, dan berkomunikasi
                    cepat dengan pemilik kos melalui dashboard yang praktis dan responsif.</p>
            </div>
            <div class="features-detail-grid">
                <!-- Feature 1 -->
                <div class="feature-detail-card">
                    <div class="feature-detail-icon">
                        <i class="fas fa-clipboard-list"></i>
                    </div>
                    <h3 class="feature-detail-title">Manajemen Laporan</h3>
                    <p class="feature-detail-desc">
                       Semua laporan penghuni tercatat otomatis dan tersusun rapi.Pantau setiap keluhan dari tahap diajukan hingga selesai tanpa takut ada yang terlewat.
                    </p>
                </div>

                <!-- Feature 2 -->
                <div class="feature-detail-card">
                    <div class="feature-detail-icon">
                        <i class="fas fa-archive"></i>
                    </div>
                    <h3 class="feature-detail-title">Arsip Laporan</h3>
                    <p class="feature-detail-desc">
                        Simpan semua riwayat laporan dengan aman.Pemilik kos dapat melihat data laporan sebelumnya untuk evaluasi dan tindak lanjut.
                    </p>
                </div>

                <!-- Feature 3 -->
                <div class="feature-detail-card">
                    <div class="feature-detail-icon">
                        <i class="fas fa-users"></i>
                    </div>
                    <h3 class="feature-detail-title">Data Penghuni</h3>
                    <p class="feature-detail-desc">
                        Sistem mendukung akses untuk penghuni dan pemilik kos. Setiap pihak punya tampilan dan fungsi yang berbeda sesuai kebutuhannya.
                    </p>
                </div>

                <!-- Feature 4 -->
                <div class="feature-detail-card">
                    <div class="feature-detail-icon">
                        <i class="fas fa-mobile-alt"></i>
                    </div>
                    <h3 class="feature-detail-title">Akses Mudah</h3>
                    <p class="feature-detail-desc">
                        Desain responsif yang bisa diakses dari HP, tablet, atau laptop. Laporkan keluhan kapan pun, di mana pun dengan mudah.
                    </p>
                </div>

                <!-- Feature 5 -->
                <div class="feature-detail-card">
                    <div class="feature-detail-icon">
                        <i class="fas fa-search"></i>
                    </div>
                    <h3 class="feature-detail-title">Pelacakan Status Laporan</h3>
                    <p class="feature-detail-desc">
                        Setiap laporan bisa dipantau tahapannya – dari diajukan, diproses, hingga selesai. Penghuni tidak perlu menebak, cukup lihat status tracking di dashboard.
                    </p>
                </div>

                <!-- Feature 6 -->
                <div class="feature-detail-card">
                    <div class="feature-detail-icon">
                        <i class="fas fa-lock"></i>
                    </div>
                    <h3 class="feature-detail-title">Keamanan Data</h3>
                    <p class="feature-detail-desc">
                        Semua data laporan dan akun pengguna terlindungi dengan sistem autentikasi yang aman. Privasi penghuni dan pemilik kos tetap terjaga.
                    </p>
                </div>
            </div>
        </div>
    </section>

    <!-- About Section -->
    <section class="about" id="about">
        <div class="about-container">
            <div class="about-image">
                <img src="<?= base_url('asset/logo.png') ?>" alt="About Image">
            </div>
            <div class="about-content">
                <h2>Tentang KosCare</h2>
                <p>KosCare adalah platform manajemen kos modern yang dirancang untuk memudahkan pemilik kos dalam mengelola properti mereka dan membantu penghuni dalam melaporkan masalah dengan cepat dan efisien.</p>
                <p>Dengan antarmuka yang user-friendly dan fitur yang lengkap, KosCare menjadi solusi terbaik untuk manajemen kos digital yang terintegrasi.</p>
                <ul class="about-list">
                    <li><i class="fas fa-check-circle"></i> Interface yang user-friendly dan mudah digunakan</li>
                    <li><i class="fas fa-check-circle"></i> Sistem terintegrasi untuk manajemen kos</li>
                    <li><i class="fas fa-check-circle"></i> Support 24/7 untuk membantu Anda</li>
                    <li><i class="fas fa-check-circle"></i> Update fitur berkala dan maintenance rutin</li>
                </ul>
            </div>
        </div>
    </section>
    <section class="pricing" id="pricing">
        <div class="section-header">
            <h2>Pilih Paket Terbaik Anda</h2>
            <p>Pilih paket yang sesuai dengan kebutuhan manajemen kos Anda. Mulai dari gratis hingga fitur lengkap untuk bisnis Anda.</p>
        </div>
        <div class="pricing-grid">
            <!-- Basic Plan -->
            <div class="pricing-card">
                <div class="pricing-header">
                    <h3 class="pricing-title">Basic</h3>
                    <p class="pricing-subtitle">Cocok untuk pemilik kos yang ingin mencoba sistem pelaporan digital tanpa biaya.</p>
                    <div class="pricing-price">Gratis</div>
                </div>
                <div class="pricing-features">
                    <h4 class="feature-title">Fitur Unggulan</h4>
                    <ul class="feature-list">
                        <li><i class="fas fa-check"></i> Laporan dasar</li>
                        <li><i class="fas fa-check"></i> Dashboard sederhana</li>
                        <li><i class="fas fa-check"></i> Manajemen penghuni dasar</li>
                        <li><i class="fas fa-check"></i> Notifikasi email</li>
                    </ul>
                </div>
                <div class="pricing-action">
                    <button class="btn-hero btn-pricing-free" id="registerBtnBasic">
                        <i class="fas fa-rocket"></i> Pilih Paket
                    </button>
                </div>
            </div>

            <!-- Bisnis Plan (Recommended) -->
            <div class="pricing-card best">
                <div class="pricing-badge">TERPOPULER</div>
                <div class="pricing-header">
                    <h3 class="pricing-title">Bisnis</h3>
                    <p class="pricing-subtitle">Pilihan terbaik bagi pemilik kos yang ingin memaksimalkan kontrol, efisiensi, dan kualitas pelayanan.</p>
                    <div class="pricing-price">Rp 50.000<span>/bulan</span></div>
                </div>
                <div class="pricing-features">
                    <h4 class="feature-title">Fitur Unggulan</h4>
                    <ul class="feature-list">
                        <li><i class="fas fa-check"></i> Laporan tanpa batas</li>
                        <li><i class="fas fa-check"></i> Dashboard analitik profesional</li>
                        <li><i class="fas fa-check"></i> Kolom chat dengan penghuni</li>
                        <li><i class="fas fa-check"></i> Support 24/7</li>
                    </ul>
                </div>
                <div class="pricing-action">
                    <button class="btn-hero btn-pricing-premium" id="registerBtnPremium">
                        <i class="fas fa-crown"></i> Pilih Paket
                    </button>
                </div>
            </div>
        </div>
    </section>
    <!-- CTA Section -->
    <section class="cta">
        <div class="cta-content">
            <h2>Siap Memulai?</h2>
            <p>Bergabung dengan ratusan pemilik kos yang telah merasakan kemudahan mengelola properti dengan KosCare.</p>
            <button class="btn-hero btn-primary" id="registerBtnCTA">
                <i class="fas fa-user-plus"></i> Daftar Gratis Sekarang
            </button>
        </div>
    </section>

    <!-- Footer -->
    <footer class="footer">
        <div class="footer-container">
            <div class="footer-section">
                <h3>KosCare</h3>
                <p>Sistem manajemen kos modern yang membantu pemilik kos dan penghuni dalam mengelola properti dengan efisien dan terorganisir.</p>
                <div class="social-links">
                    <a href="#"><i class="fab fa-facebook-f"></i></a>
                    <a href="#"><i class="fab fa-twitter"></i></a>
                    <a href="#"><i class="fab fa-instagram"></i></a>
                    <a href="#"><i class="fab fa-linkedin-in"></i></a>
                </div>
            </div>
            <div class="footer-section">
                <h3>Menu</h3>
                <ul>
                    <li><a href="#home"><i class="fas fa-chevron-right"></i> Beranda</a></li>
                    <li><a href="#pricing"><i class="fas fa-chevron-right"></i> Paket</a></li>
                    <li><a href="#features"><i class="fas fa-chevron-right"></i> Fitur</a></li>
                    <li><a href="#about"><i class="fas fa-chevron-right"></i> Tentang</a></li>
                </ul>
            </div>
            <div class="footer-section">
                <h3>Kontak</h3>
                <ul>
                    <li><a href="#"><i class="fas fa-map-marker-alt"></i> Jl. Swadaya 4 No.124b, Mladangan, Minomartani, Kec. Ngaglik, Kabupaten Sleman, Daerah Istimewa Yogyakarta 55581</a></li>
                    <li><a href="#"><i class="fas fa-phone"></i> +62 813-6383-3544</a></li>
                    <li><a href="#"><i class="fas fa-envelope"></i> KosCare@gmail.com</a></li>
                    <li><a href="#"><i class="fas fa-clock"></i> Senin - Jumat: 9:00 - 17:00</a></li>
                </ul>
            </div>
        </div>
        <div class="footer-bottom">
            <p>&copy; 2025 KosCare. All rights reserved. Made with <i class="fas fa-heart" style="color: #e74c3c;"></i></p>
        </div>
    </footer>

    <!-- Scroll to Top Button -->
    <div class="scroll-top" id="scrollTop">
        <i class="fas fa-arrow-up"></i>
    </div>

    <script>
        // Modal Functionality
        const registerModal = document.getElementById('registerModal');
        const modalClose = document.getElementById('modalClose');
        const registerBtnNav = document.getElementById('registerBtnNav');
        const registerBtnHero = document.getElementById('registerBtnHero');
        const registerBtnCTA = document.getElementById('registerBtnCTA');
        const registerBtnBasic = document.getElementById('registerBtnBasic');
        const registerBtnPremium = document.getElementById('registerBtnPremium');

        // Function to show modal
        function showRegisterModal() {
            registerModal.classList.add('active');
            document.body.style.overflow = 'hidden';
        }

        // Function to hide modal
        function hideRegisterModal() {
            registerModal.classList.remove('active');
            document.body.style.overflow = '';
        }

        // Event listeners for showing modal
        registerBtnNav.addEventListener('click', showRegisterModal);
        registerBtnHero.addEventListener('click', showRegisterModal);
        registerBtnCTA.addEventListener('click', showRegisterModal);
        registerBtnBasic.addEventListener('click', showRegisterModal);
        registerBtnPremium.addEventListener('click', showRegisterModal);

        // Event listener for closing modal
        modalClose.addEventListener('click', hideRegisterModal);

        // Close modal when clicking outside
        registerModal.addEventListener('click', function(e) {
            if (e.target === registerModal) {
                hideRegisterModal();
            }
        });

        // Mobile Menu Toggle
        const mobileMenuToggle = document.getElementById('mobileMenuToggle');
        const navbarMenu = document.getElementById('navbarMenu');

        mobileMenuToggle.addEventListener('click', function() {
            navbarMenu.classList.toggle('active');
            const icon = this.querySelector('i');
            icon.classList.toggle('fa-bars');
            icon.classList.toggle('fa-times');
        });

        // Navbar Scroll Effect
        window.addEventListener('scroll', function() {
            const navbar = document.querySelector('.navbar');
            if (window.scrollY > 50) {
                navbar.classList.add('scrolled');
            } else {
                navbar.classList.remove('scrolled');
            }
        });

        // Scroll to Top Button
        const scrollTop = document.getElementById('scrollTop');

        window.addEventListener('scroll', function() {
            if (window.scrollY > 300) {
                scrollTop.classList.add('visible');
            } else {
                scrollTop.classList.remove('visible');
            }
        });

        scrollTop.addEventListener('click', function() {
            window.scrollTo({
                top: 0,
                behavior: 'smooth'
            });
        });

        // Smooth Scroll for Anchor Links
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function(e) {
                e.preventDefault();
                const target = document.querySelector(this.getAttribute('href'));
                if (target) {
                    target.scrollIntoView({
                        behavior: 'smooth',
                        block: 'start'
                    });
                    // Close mobile menu if open
                    navbarMenu.classList.remove('active');
                    const icon = mobileMenuToggle.querySelector('i');
                    icon.classList.add('fa-bars');
                    icon.classList.remove('fa-times');
                }
            });
        });

        // Add scroll effect to feature cards
        document.addEventListener('DOMContentLoaded', function() {
            const featureCards = document.querySelectorAll('.feature-detail-card');

            const observer = new IntersectionObserver((entries) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        entry.target.style.opacity = '1';
                        entry.target.style.transform = 'translateY(0)';
                    }
                });
            }, {
                threshold: 0.1
            });

            featureCards.forEach(card => {
                card.style.opacity = '0';
                card.style.transform = 'translateY(20px)';
                card.style.transition = 'opacity 0.5s ease, transform 0.5s ease';
                observer.observe(card);
            });
        });
    </script>
</body>

</html>