<?php
// Determine active menu based on current URL
$current_url = uri_string(); // Get current URI segment
?>
<!doctype html>
<html>

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title><?php echo isset($title) ? $title : 'Super Admin Dashboard'; ?></title>
  <link rel="stylesheet" href="<?php echo site_url('asset/css/bootstrap.min.css'); ?>">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }

    body {
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      background: #f0f8ff;
      color: #333;
    }

    /* TOPBAR IMPROVED - SAME AS ADMIN */
    .topbar {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      padding: 12px 0;
      box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
      position: fixed;
      top: 0;
      left: 0;
      right: 0;
      z-index: 1030;
      height: 60px;
    }

    .topbar-container {
      display: flex;
      justify-content: space-between;
      align-items: center;
      height: 100%;
      padding: 0 15px;
    }

    .brand-section {
      display: flex;
      align-items: center;
      gap: 15px;
      flex-shrink: 0;
    }

    .brand-logo {
      width: 50px;
      height: auto;
      transition: transform 0.3s;
    }

    .brand-logo:hover {
      transform: scale(1.05);
    }

    .brand-text {
      color: white;
    }

    .brand-text h4 {
      font-weight: 600;
      font-size: 1.3rem;
      margin: 0;
      line-height: 1.2;
    }

    .brand-text span {
      font-size: 0.9rem;
      opacity: 0.9;
      display: block;
      margin-top: 2px;
    }

    .user-section {
      display: flex;
      align-items: center;
      gap: 15px;
      flex-shrink: 0;
    }

    .user-info {
      display: flex;
      align-items: center;
      gap: 8px;
      color: white;
      font-size: 0.95rem;
      padding: 6px 12px;
      border-radius: 6px;
      transition: background 0.3s;
    }

    .user-info:hover {
      background: rgba(255, 255, 255, 0.1);
    }

    .user-info i {
      font-size: 1.2rem;
    }

    .logout-btn {
      display: flex;
      align-items: center;
      gap: 8px;
      color: white;
      text-decoration: none;
      padding: 8px 16px;
      border-radius: 6px;
      background: rgba(255, 255, 255, 0.15);
      transition: all 0.3s;
      font-size: 0.9rem;
      font-weight: 500;
    }

    .logout-btn:hover {
      background: rgba(255, 255, 255, 0.25);
      transform: translateY(-1px);
      color: white;
    }

    /* SIDEBAR STYLES - SUPER ADMIN */
    .sidebar {
      background: white;
      min-height: calc(100vh - 60px);
      padding: 25px 15px;
      box-shadow: 2px 0 10px rgba(0, 0, 0, 0.05);
      position: fixed;
      top: 60px;
      left: 0;
      width: 16.666667%;
      height: calc(100vh - 60px);
      overflow-y: auto;
      z-index: 1020;
    }

    .sidebar h5 {
      color: #667eea;
      margin-bottom: 20px;
      font-weight: 600;
      padding-bottom: 10px;
      border-bottom: 2px solid #e8eaf6;
    }

    .sidebar ul {
      list-style: none;
    }

    .sidebar ul li {
      margin-bottom: 8px;
    }

    .sidebar ul li a {
      display: block;
      padding: 12px 15px;
      color: #555;
      text-decoration: none;
      border-radius: 8px;
      transition: all 0.3s;
      font-size: 0.95rem;
      position: relative;
      overflow: hidden;
    }

    .sidebar ul li a:hover {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
      transform: translateX(5px);
    }

    .sidebar ul li a.active {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
      transform: translateX(5px);
      box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
    }

    .sidebar ul li a.active:before {
      content: '';
      position: absolute;
      left: 0;
      top: 0;
      height: 100%;
      width: 4px;
      background: white;
      border-radius: 0 4px 4px 0;
    }

    .sidebar ul li a i {
      width: 20px;
      margin-right: 10px;
    }

    /* MAIN CONTENT */
    .main-content {
      margin-left: 16.666667%;
      margin-top: 60px;
      padding: 25px;
      background: #f0f8ff;
      min-height: calc(100vh - 60px);
    }

    .welcome-section {
      background: white;
      border-radius: 12px;
      padding: 30px;
      margin-bottom: 30px;
      box-shadow: 0 4px 15px rgba(0, 0, 0, 0.08);
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
    }

    .welcome-section h3 {
      font-weight: 600;
      margin-bottom: 10px;
    }

    .welcome-section p {
      opacity: 0.95;
      font-size: 1rem;
    }

    .stat-card {
      background: white;
      border-radius: 12px;
      padding: 30px;
      margin-bottom: 20px;
      box-shadow: 0 4px 15px rgba(0, 0, 0, 0.08);
      transition: all 0.3s;
      border-left: 4px solid #667eea;
      position: relative;
      overflow: hidden;
    }

    .stat-card:hover {
      transform: translateY(-5px);
      box-shadow: 0 8px 25px rgba(0, 0, 0, 0.12);
    }

    .stat-card.card-purple {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
      border-left: none;
    }

    .stat-card.card-success {
      border-left-color: #28a745;
    }

    .stat-card.card-danger {
      border-left-color: #dc3545;
    }

    .stat-card h5 {
      font-size: 0.9rem;
      font-weight: 500;
      margin-bottom: 10px;
      opacity: 0.9;
    }

    .stat-card h2 {
      font-size: 3rem;
      font-weight: 700;
      margin-bottom: 15px;
    }

    .stat-card .icon {
      position: absolute;
      right: 20px;
      top: 20px;
      font-size: 4rem;
      opacity: 0.15;
    }

    .stat-card .btn {
      margin-top: 10px;
      border-radius: 8px;
      padding: 10px 20px;
      font-weight: 500;
      transition: all 0.3s;
    }

    .stat-card.card-purple .btn {
      background: white;
      color: #667eea;
      border: none;
    }

    .stat-card.card-purple .btn:hover {
      background: rgba(255, 255, 255, 0.9);
      transform: scale(1.05);
    }

    .stat-card:not(.card-purple) .btn-primary {
      background: #667eea;
      border: none;
    }

    .stat-card:not(.card-purple) .btn-primary:hover {
      background: #764ba2;
    }

    .stat-card:not(.card-purple) .btn-success {
      background: #28a745;
      border: none;
    }

    .stat-card:not(.card-purple) .btn-success:hover {
      background: #218838;
    }

    .stat-card:not(.card-purple) .btn-light {
      background: #f8f9fa;
      color: #333;
      border: 1px solid #dee2e6;
    }

    .stat-card:not(.card-purple) .btn-light:hover {
      background: #e9ecef;
    }

    .quick-actions {
      display: flex;
      gap: 10px;
      margin-bottom: 25px;
      flex-wrap: wrap;
    }

    .quick-action-btn {
      background: white;
      border: 2px solid #667eea;
      color: #667eea;
      padding: 12px 24px;
      border-radius: 8px;
      text-decoration: none;
      transition: all 0.3s;
      font-size: 0.9rem;
      font-weight: 500;
    }

    .quick-action-btn:hover {
      background: #667eea;
      color: white;
      transform: translateY(-2px);
      box-shadow: 0 4px 12px rgba(102, 126, 234, 0.3);
    }

    .quick-action-btn i {
      margin-right: 8px;
    }

    .info-card {
      background: white;
      border-radius: 12px;
      padding: 25px;
      margin-bottom: 20px;
      box-shadow: 0 4px 15px rgba(0, 0, 0, 0.08);
    }

    .info-card h5 {
      color: #667eea;
      margin-bottom: 20px;
      font-weight: 600;
    }

    .info-card .info-item {
      padding: 15px;
      background: #f8f9ff;
      border-radius: 8px;
      margin-bottom: 10px;
      display: flex;
      align-items: center;
      transition: all 0.3s;
    }

    .info-card .info-item:hover {
      background: #e8eaf6;
      transform: translateX(5px);
    }

    .info-card .info-item i {
      font-size: 1.5rem;
      color: #667eea;
      margin-right: 15px;
      width: 30px;
      text-align: center;
    }

    .info-card .info-item .info-text {
      flex: 1;
    }

    .info-card .info-item .info-text strong {
      display: block;
      color: #333;
      margin-bottom: 3px;
    }

    .info-card .info-item .info-text small {
      color: #888;
    }

    /* RESPONSIVE DESIGN */
    @media (max-width: 992px) {
      .sidebar {
        width: 25%;
      }

      .main-content {
        margin-left: 25%;
      }
    }

    @media (max-width: 768px) {
      .sidebar {
        position: relative;
        width: 100%;
        height: auto;
        min-height: auto;
        top: 0;
      }

      .main-content {
        margin-left: 0;
        margin-top: 0;
        padding: 15px;
      }

      .topbar {
        height: auto;
        padding: 10px 0;
      }

      .topbar-container {
        flex-direction: column;
        gap: 10px;
        height: auto;
      }

      .brand-section,
      .user-section {
        width: 100%;
        justify-content: center;
      }

      .stat-card h2 {
        font-size: 2rem;
      }

      .welcome-section {
        padding: 20px;
      }

      .brand-text h4 {
        font-size: 1.1rem;
      }

      .brand-text span {
        font-size: 0.8rem;
      }

      .user-info,
      .logout-btn {
        font-size: 0.85rem;
      }
    }

    .sidebar::-webkit-scrollbar {
      width: 6px;
    }

    .sidebar::-webkit-scrollbar-track {
      background: #f1f1f1;
    }

    .sidebar::-webkit-scrollbar-thumb {
      background: #667eea;
      border-radius: 3px;
    }

    .sidebar::-webkit-scrollbar-thumb:hover {
      background: #764ba2;
    }

    @media (max-width: 576px) {
      .quick-actions {
        flex-direction: column;
      }
      
      .quick-action-btn {
        width: 100%;
        text-align: center;
      }
    }
  </style>
</head>

<body>
  <!-- TOPBAR IMPROVED -->
  <div class="topbar">
    <div class="container-fluid">
      <div class="topbar-container">
        <!-- Brand Section (Left) -->
        <div class="brand-section">
          <img src="<?= base_url('asset/logo 2.png'); ?>" alt="Logo KosCare" class="brand-logo">
          <div class="brand-text">
            <h4>KosCare</h4>
            <span>Super Admin Dashboard</span>
          </div>
        </div>

        <!-- User Section (Right) -->
        <div class="user-section">
          <div class="user-info">
            <i class="fas fa-user-shield"></i>
            <div>
              <span>Halo, <strong><?php echo $this->session->userdata('super_admin_name'); ?></strong></span>
            </div>
          </div>
          <a href="<?php echo site_url('superadmin/superadmin/logout'); ?>" class="logout-btn">
            <i class="fas fa-sign-out-alt"></i> Logout
          </a>
        </div>
      </div>
    </div>
  </div>

  <!-- SIDEBAR -->
  <div class="sidebar" id="sidebar">
    <h5><i class="fas fa-bars"></i> Menu</h5>
    <ul>
      <li><a href="<?php echo site_url('superadmin/superadmin/dashboard'); ?>" class="<?= strpos($current_url, 'dashboard') !== false ? 'active' : '' ?>"><i class="fas fa-tachometer-alt"></i> Dashboard</a></li>
      <li><a href="<?php echo site_url('superadmin/superadmin/admin_list'); ?>" class="<?= strpos($current_url, 'admin_list') !== false || strpos($current_url, 'admin_form') !== false ? 'active' : '' ?>"><i class="fas fa-user-tie"></i> Kelola Admin</a></li>
      <li><a href="<?php echo site_url('superadmin/superadmin/kos_list'); ?>" class="<?= strpos($current_url, 'kos_list') !== false || strpos($current_url, 'kos_form') !== false ? 'active' : '' ?>"><i class="fas fa-building"></i> Kelola Kos</a></li>
      <li><a href="<?php echo site_url('superadmin/superadmin/report_list'); ?>" class="<?= strpos($current_url, 'report_list') !== false ? 'active' : '' ?>"><i class="fas fa-flag"></i> Laporan Admin</a></li>
    </ul>
  </div>

  <div class="main-content">
    <div class="welcome-section">
      <h3><i class="fas fa-hand-sparkles"></i> Selamat datang, <?php echo $this->session->userdata('super_admin_name'); ?>! 👋</h3>
      <p>Kelola seluruh sistem kos dengan mudah dari panel super admin ini</p>
    </div>
    <div class="row">
      <div class="col-md-4">
        <div class="stat-card card-purple">
          <i class="fas fa-user-tie icon"></i>
          <h5>Total Admin</h5>
          <h2><?php echo $admin_count; ?></h2>
          <small>Admin yang mengelola sistem kos</small>
          <div class="mt-3">
            <a href="<?php echo site_url('superadmin/superadmin/admin_list'); ?>" class="btn btn-light">
              <i class="fas fa-eye"></i> Kelola Admin
            </a>
          </div>
        </div>
      </div>

      <div class="col-md-4">
        <div class="stat-card card-success">
          <i class="fas fa-building icon"></i>
          <h5>Total Kos</h5>
          <h2><?php echo $kos_count; ?></h2>
          <small>Properti kos yang terdaftar</small>
          <div class="mt-3">
            <a href="<?php echo site_url('superadmin/superadmin/kos_list'); ?>" class="btn btn-success">
              <i class="fas fa-eye"></i> Kelola Kos
            </a>
          </div>
        </div>
      </div>

      <div class="col-md-4">
        <div class="stat-card card-danger">
          <i class="fas fa-flag icon"></i>
          <h5>Laporan Admin</h5>
          <h2><?php echo $report_count; ?></h2>
          <small>Total laporan dari penghuni</small>
          <?php if (isset($pending_reports) && $pending_reports > 0): ?>
            <div class="mt-2">
              <span class="badge bg-warning"><?php echo $pending_reports; ?> Pending</span>
            </div>
          <?php endif; ?>
          <div class="mt-3">
            <a href="<?php echo site_url('superadmin/superadmin/report_list'); ?>" class="btn btn-light">
              <i class="fas fa-eye"></i> Lihat Laporan
            </a>
          </div>
        </div>
      </div>
    </div>

    <div class="row mt-4">
      <div class="col-md-6">
        <div class="info-card">
          <h5><i class="fas fa-info-circle"></i> Informasi Sistem</h5>
          <div class="info-item">
            <i class="fas fa-server"></i>
            <div class="info-text">
              <strong>Status Sistem</strong>
              <small>Semua sistem berjalan normal</small>
            </div>
          </div>
          <div class="info-item">
            <i class="fas fa-database"></i>
            <div class="info-text">
              <strong>Database</strong>
              <small>Koneksi stabil dan terenkripsi</small>
            </div>
          </div>
          <div class="info-item">
            <i class="fas fa-shield-alt"></i>
            <div class="info-text">
              <strong>Keamanan</strong>
              <small>SSL aktif dan firewall terpasang</small>
            </div>
          </div>
        </div>
      </div>

      <div class="col-md-6">
        <div class="info-card">
          <h5><i class="fas fa-chart-pie"></i> Statistik Cepat</h5>
          <div class="info-item">
            <i class="fas fa-users"></i>
            <div class="info-text">
              <strong>Admin Aktif</strong>
              <small><?php echo $admin_count; ?> admin terdaftar</small>
            </div>
          </div>
          <div class="info-item">
            <i class="fas fa-home"></i>
            <div class="info-text">
              <strong>Properti Kos</strong>
              <small><?php echo $kos_count; ?> kos tersedia</small>
            </div>
          </div>
          <div class="info-item">
            <i class="fas fa-calendar-check"></i>
            <div class="info-text">
              <strong>Update Terakhir</strong>
              <small><?php echo date('d F Y, H:i'); ?> WIB</small>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <script src="<?php echo site_url('asset/js/jquery-3.6.0.min.js'); ?>"></script>
  <script src="<?php echo site_url('asset/js/bootstrap.bundle.min.js'); ?>"></script>

  <script>
    // Add hover effects to logout button
    document.addEventListener('DOMContentLoaded', function() {
      const logoutBtn = document.querySelector('.logout-btn');
      if (logoutBtn) {
        logoutBtn.addEventListener('mouseenter', function() {
          this.style.transform = 'translateY(-1px) scale(1.02)';
        });
        logoutBtn.addEventListener('mouseleave', function() {
          this.style.transform = 'translateY(0) scale(1)';
        });
      }
    });
  </script>
</body>

</html>