<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Super Admin Login - SistemKOS</title>
  <link rel="stylesheet" href="<?php echo site_url('asset/css/bootstrap.min.css'); ?>">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }

    body {
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      height: 100vh;
      display: flex;
      align-items: center;
      justify-content: center;
    }

    .login-container {
      width: 100%;
      max-width: 420px;
      padding: 15px;
    }

    .login-card {
      background: white;
      border-radius: 15px;
      overflow: hidden;
      box-shadow: 0 15px 35px rgba(0, 0, 0, 0.2);
    }

    .login-header {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
      padding: 30px;
      text-align: center;
    }

    .login-header i {
      font-size: 3.5rem;
      margin-bottom: 15px;
      display: block;
    }

    .login-header h2 {
      font-weight: 600;
      font-size: 1.8rem;
      margin-bottom: 5px;
    }

    .login-header p {
      opacity: 0.9;
      font-size: 0.9rem;
    }

    .login-body {
      padding: 30px;
    }

    .form-group {
      margin-bottom: 20px;
    }

    .form-label {
      font-weight: 500;
      margin-bottom: 8px;
      color: #555;
      display: block;
    }

    .form-control {
      width: 100%;
      padding: 12px 15px;
      border: 2px solid #e0e0e0;
      border-radius: 8px;
      font-size: 1rem;
      transition: all 0.3s;
    }

    .form-control:focus {
      border-color: #667eea;
      box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
      outline: none;
    }

    .input-group {
      position: relative;
    }

    .input-group i {
      position: absolute;
      left: 15px;
      top: 50%;
      transform: translateY(-50%);
      color: #999;
    }

    .input-group input {
      padding-left: 45px;
    }

    .btn-login {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
      border: none;
      padding: 14px;
      border-radius: 8px;
      font-size: 1rem;
      font-weight: 600;
      width: 100%;
      cursor: pointer;
      transition: all 0.3s;
      margin-top: 10px;
    }

    .btn-login:hover {
      transform: translateY(-2px);
      box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4);
    }

    .alert {
      padding: 12px 15px;
      border-radius: 8px;
      margin-bottom: 20px;
      font-size: 0.9rem;
    }

    .alert-danger {
      background: #fee;
      border: 1px solid #f99;
      color: #c00;
    }

    .footer-text {
      text-align: center;
      margin-top: 20px;
      color: #888;
      font-size: 0.85rem;
    }

    @media (max-width: 576px) {
      .login-container {
        padding: 20px;
      }

      .login-header {
        padding: 25px 20px;
      }

      .login-body {
        padding: 25px 20px;
      }
    }
  </style>
</head>

<body>
  <div class="login-container">
    <div class="login-card">
      <div class="login-header">
        <i class="fas fa-user-shield"></i>
        <h2>Super Admin Login</h2>
        <p>Sistem Manajemen Kos Terpadu</p>
      </div>

      <div class="login-body">
        <?php if ($this->session->flashdata('error')): ?>
          <div class="alert alert-danger">
            <i class="fas fa-exclamation-circle"></i> <?php echo $this->session->flashdata('error'); ?>
          </div>
        <?php endif; ?>

        <form action="<?php echo site_url('superadmin/superadmin/action'); ?>" method="POST">
          <div class="form-group">
            <label class="form-label" for="email">Email</label>
            <div class="input-group">
              <i class="fas fa-envelope"></i>
              <input type="email" name="email" id="email" class="form-control" placeholder="email@example.com" required>
            </div>
          </div>

          <div class="form-group">
            <label class="form-label" for="password">Password</label>
            <div class="input-group">
              <i class="fas fa-lock"></i>
              <input type="password" name="password" id="password" class="form-control" placeholder="••••••••" required>
            </div>
          </div>

          <button type="submit" class="btn-login">
            <i class="fas fa-sign-in-alt"></i> Login
          </button>
        </form>
        <div class="footer-text">
          &copy; <?php echo date('Y'); ?> KosCare- Super Admin Panel
        </div>
        <!-- Tambahkan setelah form login (sebelum footer-text) -->
        <div style="text-align: center; margin-top: 15px;">
          <a href="<?php echo site_url('superadmin/forgot_password'); ?>"
            style="color: #667eea; text-decoration: none; font-size: 0.9rem;">
            <i class="fas fa-question-circle"></i> Lupa Password?
          </a>
        </div>
      </div>
    </div>
  </div>
</body>

</html>