<?php
// Determine active menu based on current URL
$current_url = uri_string(); // Get current URI segment
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title><?php echo isset($title) ? $title : 'Laporan Admin'; ?> - SistemKOS</title>
  <link rel="stylesheet" href="<?php echo site_url('asset/css/bootstrap.min.css'); ?>">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  
  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }

    body {
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      background: #f0f8ff;
      color: #333;
    }

    /* TOPBAR IMPROVED - SAME AS SUPER ADMIN */
    .topbar {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      padding: 12px 0;
      box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
      position: fixed;
      top: 0;
      left: 0;
      right: 0;
      z-index: 1030;
      height: 60px;
    }

    .topbar-container {
      display: flex;
      justify-content: space-between;
      align-items: center;
      height: 100%;
      padding: 0 15px;
    }

    .brand-section {
      display: flex;
      align-items: center;
      gap: 15px;
      flex-shrink: 0;
    }

    .brand-logo {
      width: 50px;
      height: auto;
      transition: transform 0.3s;
    }

    .brand-logo:hover {
      transform: scale(1.05);
    }

    .brand-text {
      color: white;
    }

    .brand-text h4 {
      font-weight: 600;
      font-size: 1.3rem;
      margin: 0;
      line-height: 1.2;
    }

    .brand-text span {
      font-size: 0.9rem;
      opacity: 0.9;
      display: block;
      margin-top: 2px;
    }

    .user-section {
      display: flex;
      align-items: center;
      gap: 15px;
      flex-shrink: 0;
    }

    .user-info {
      display: flex;
      align-items: center;
      gap: 8px;
      color: white;
      font-size: 0.95rem;
      padding: 6px 12px;
      border-radius: 6px;
      transition: background 0.3s;
    }

    .user-info:hover {
      background: rgba(255, 255, 255, 0.1);
    }

    .user-info i {
      font-size: 1.2rem;
    }

    .logout-btn {
      display: flex;
      align-items: center;
      gap: 8px;
      color: white;
      text-decoration: none;
      padding: 8px 16px;
      border-radius: 6px;
      background: rgba(255, 255, 255, 0.15);
      transition: all 0.3s;
      font-size: 0.9rem;
      font-weight: 500;
    }

    .logout-btn:hover {
      background: rgba(255, 255, 255, 0.25);
      transform: translateY(-1px);
      color: white;
    }

    /* SIDEBAR STYLES */
    .sidebar {
      background: white;
      min-height: calc(100vh - 60px);
      padding: 25px 15px;
      box-shadow: 2px 0 10px rgba(0, 0, 0, 0.05);
      position: fixed;
      top: 60px;
      left: 0;
      width: 16.666667%;
      height: calc(100vh - 60px);
      overflow-y: auto;
      z-index: 1020;
    }

    .sidebar h5 {
      color: #667eea;
      margin-bottom: 20px;
      font-weight: 600;
      padding-bottom: 10px;
      border-bottom: 2px solid #e8eaf6;
    }

    .sidebar ul {
      list-style: none;
    }

    .sidebar ul li {
      margin-bottom: 8px;
    }

    .sidebar ul li a {
      display: block;
      padding: 12px 15px;
      color: #555;
      text-decoration: none;
      border-radius: 8px;
      transition: all 0.3s;
      font-size: 0.95rem;
      position: relative;
      overflow: hidden;
    }

    .sidebar ul li a:hover {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
      transform: translateX(5px);
    }

    .sidebar ul li a.active {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
      transform: translateX(5px);
      box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
    }

    .sidebar ul li a.active:before {
      content: '';
      position: absolute;
      left: 0;
      top: 0;
      height: 100%;
      width: 4px;
      background: white;
      border-radius: 0 4px 4px 0;
    }

    .sidebar ul li a i {
      width: 20px;
      margin-right: 10px;
    }

    /* MAIN CONTENT */
    .main-content {
      margin-left: 16.666667%;
      margin-top: 60px;
      padding: 25px;
      background: #f0f8ff;
      min-height: calc(100vh - 60px);
    }

    .page-header {
      background: white;
      border-radius: 12px;
      padding: 20px 25px;
      margin-bottom: 25px;
      box-shadow: 0 4px 15px rgba(0, 0, 0, 0.08);
      display: flex;
      justify-content: space-between;
      align-items: center;
      flex-wrap: wrap;
      gap: 15px;
    }

    .page-header h3 {
      color: #667eea;
      font-weight: 600;
      margin: 0;
      display: flex;
      align-items: center;
      gap: 10px;
    }

    .badge-notification {
      background: linear-gradient(135deg, #dc3545 0%, #c82333 100%);
      color: white;
      padding: 5px 12px;
      border-radius: 20px;
      font-size: 0.85rem;
      font-weight: 500;
    }

    .table-card {
      background: white;
      border-radius: 12px;
      padding: 25px;
      box-shadow: 0 4px 15px rgba(0, 0, 0, 0.08);
      overflow-x: auto;
    }

    .table {
      margin-bottom: 0;
      width: 100%;
      border-collapse: separate;
      border-spacing: 0;
    }

    .table thead th {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
      border: none;
      padding: 15px;
      font-weight: 500;
      font-size: 0.95rem;
    }

    .table thead th:first-child {
      border-radius: 8px 0 0 0;
    }

    .table thead th:last-child {
      border-radius: 0 8px 0 0;
    }

    .table tbody tr {
      transition: all 0.3s;
      border-bottom: 1px solid #e9ecef;
    }

    .table tbody tr:hover {
      background: #f8f9ff;
      transform: scale(1.01);
      box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
    }

    .table tbody td {
      padding: 15px;
      vertical-align: middle;
    }

    .admin-info {
      display: flex;
      align-items: center;
      gap: 10px;
    }

    .admin-avatar {
      width: 40px;
      height: 40px;
      border-radius: 50%;
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      display: flex;
      align-items: center;
      justify-content: center;
      color: white;
      font-weight: 600;
      font-size: 1rem;
    }

    .admin-avatar.bg-warning {
      background: linear-gradient(135deg, #ffc107 0%, #e0a800 100%);
    }

    .admin-details strong {
      display: block;
      color: #333;
      margin-bottom: 2px;
    }

    .admin-details small {
      color: #888;
      font-size: 0.85rem;
    }

    .date-info {
      display: flex;
      align-items: center;
      gap: 8px;
      color: #666;
    }

    .date-info i {
      color: #667eea;
    }

    .btn-action {
      padding: 6px 12px;
      border-radius: 6px;
      font-size: 0.85rem;
      text-decoration: none;
      transition: all 0.3s;
      display: inline-flex;
      align-items: center;
      gap: 5px;
    }

    .btn-info {
      background: #17a2b8;
      color: white;
      border: none;
    }

    .btn-info:hover {
      background: #138496;
      transform: translateY(-2px);
      box-shadow: 0 4px 10px rgba(23, 162, 184, 0.4);
      color: white;
    }

    .empty-state {
      text-align: center;
      padding: 60px 20px;
      color: #888;
    }

    .empty-state i {
      font-size: 5rem;
      color: #ccc;
      margin-bottom: 20px;
    }

    .empty-state h5 {
      color: #666;
      margin-bottom: 10px;
    }

    .empty-state p {
      color: #999;
    }

    .status-badge {
      display: inline-block;
      padding: 6px 12px;
      border-radius: 20px;
      font-size: 0.85rem;
      font-weight: 500;
    }
    
    .status-pending {
      background: #fff3cd;
      color: #856404;
    }
    
    .status-diproses {
      background: #cce5ff;
      color: #004085;
    }
    
    .status-diterima {
      background: #d4edda;
      color: #155724;
    }
    
    .status-ditolak {
      background: #f8d7da;
      color: #721c24;
    }
    
    .action-badge {
      display: inline-block;
      padding: 6px 12px;
      border-radius: 20px;
      font-size: 0.85rem;
      font-weight: 500;
    }
    
    .action-peringatan {
      background: #fff3cd;
      color: #856404;
    }
    
    .action-nonaktif {
      background: #f8d7da;
      color: #721c24;
    }
    
    .action-none {
      background: #e2e3e5;
      color: #383d41;
    }
    
    .report-preview {
      max-width: 200px;
      overflow: hidden;
      text-overflow: ellipsis;
      white-space: nowrap;
      font-weight: 500;
    }

    /* RESPONSIVE DESIGN */
    @media (max-width: 992px) {
      .sidebar {
        width: 25%;
      }

      .main-content {
        margin-left: 25%;
      }
    }

    @media (max-width: 768px) {
      .sidebar {
        position: relative;
        width: 100%;
        height: auto;
        min-height: auto;
        top: 0;
      }

      .main-content {
        margin-left: 0;
        margin-top: 0;
        padding: 15px;
      }

      .topbar {
        height: auto;
        padding: 10px 0;
      }

      .topbar-container {
        flex-direction: column;
        gap: 10px;
        height: auto;
      }

      .brand-section,
      .user-section {
        width: 100%;
        justify-content: center;
      }

      .page-header {
        flex-direction: column;
        align-items: flex-start;
      }

      .table-card {
        padding: 15px;
      }

      .brand-text h4 {
        font-size: 1.1rem;
      }

      .brand-text span {
        font-size: 0.8rem;
      }

      .user-info,
      .logout-btn {
        font-size: 0.85rem;
      }
    }

    @media (max-width: 576px) {
      .btn-action {
        display: block;
        margin-bottom: 5px;
        width: 100%;
        text-align: center;
      }

      .table {
        font-size: 0.85rem;
      }

      .table td,
      .table th {
        padding: 10px;
      }

      .admin-info {
        flex-direction: column;
        align-items: flex-start;
      }

      .admin-avatar {
        width: 30px;
        height: 30px;
        font-size: 0.8rem;
      }
    }

    .sidebar::-webkit-scrollbar {
      width: 6px;
    }

    .sidebar::-webkit-scrollbar-track {
      background: #f1f1f1;
    }

    .sidebar::-webkit-scrollbar-thumb {
      background: #667eea;
      border-radius: 3px;
    }

    .sidebar::-webkit-scrollbar-thumb:hover {
      background: #764ba2;
    }
  </style>
</head>
<body>
  <!-- TOPBAR IMPROVED -->
  <div class="topbar">
    <div class="container-fluid">
      <div class="topbar-container">
        <!-- Brand Section (Left) -->
        <div class="brand-section">
          <img src="<?= base_url('asset/logo 2.png'); ?>" alt="Logo KosCare" class="brand-logo">
          <div class="brand-text">
            <h4>KosCare</h4>
            <span>Super Admin Dashboard</span>
          </div>
        </div>

        <!-- User Section (Right) -->
        <div class="user-section">
          <div class="user-info">
            <i class="fas fa-user-shield"></i>
            <div>
              <span>Halo, <strong><?php echo $this->session->userdata('super_admin_name'); ?></strong></span>
            </div>
          </div>
          <a href="<?php echo site_url('superadmin/superadmin/logout'); ?>" class="logout-btn">
            <i class="fas fa-sign-out-alt"></i> Logout
          </a>
        </div>
      </div>
    </div>
  </div>

  <!-- SIDEBAR -->
  <div class="sidebar" id="sidebar">
    <h5><i class="fas fa-bars"></i> Menu</h5>
    <ul>
      <li><a href="<?php echo site_url('superadmin/superadmin/dashboard'); ?>" class="<?= strpos($current_url, 'dashboard') !== false ? 'active' : '' ?>"><i class="fas fa-tachometer-alt"></i> Dashboard</a></li>
      <li><a href="<?php echo site_url('superadmin/superadmin/admin_list'); ?>" class="<?= (strpos($current_url, 'admin_list') !== false || strpos($current_url, 'admin_form') !== false) ? 'active' : '' ?>"><i class="fas fa-user-tie"></i> Kelola Admin</a></li>
      <li><a href="<?php echo site_url('superadmin/superadmin/kos_list'); ?>" class="<?= (strpos($current_url, 'kos_list') !== false || strpos($current_url, 'kos_form') !== false) ? 'active' : '' ?>"><i class="fas fa-building"></i> Kelola Kos</a></li>
      <li><a href="<?php echo site_url('superadmin/superadmin/report_list'); ?>" class="<?= strpos($current_url, 'report_list') !== false ? 'active' : '' ?>">
        <i class="fas fa-flag"></i> Laporan Admin 
        <?php if(isset($pending_count) && $pending_count > 0): ?>
          <span class="badge bg-danger ms-1" style="background: linear-gradient(135deg, #dc3545 0%, #c82333 100%); color: white; padding: 2px 6px; font-size: 0.7rem; border-radius: 10px;"><?php echo $pending_count; ?></span>
        <?php endif; ?>
      </a></li>
    </ul>
  </div>
  
  <div class="main-content">
    <div class="page-header">
      <h3><i class="fas fa-flag"></i> <?php echo isset($title) ? $title : 'Laporan Admin'; ?>
        <?php if(isset($pending_count) && $pending_count > 0): ?>
          <span class="badge-notification"><?php echo $pending_count; ?> Pending</span>
        <?php endif; ?>
      </h3>
    </div>
    
    <div class="table-card">
      <?php if (!empty($reports)): ?>
        <table class="table">
          <thead>
            <tr>
              <th>No</th>
              <th>Penghuni</th>
              <th>Admin</th>
              <th>Judul</th>
              <th>Status</th>
              <th>Tindakan</th>
              <th>Tanggal</th>
              <th>Aksi</th>
            </tr>
          </thead>
          <tbody>
            <?php $no = 1; foreach($reports as $r): ?>
            <tr>
              <td><strong><?php echo $no++; ?></strong></td>
              <td>
                <div class="admin-info">
                  <div class="admin-avatar">
                    <?php echo isset($r->nama_penghuni) ? strtoupper(substr($r->nama_penghuni, 0, 1)) : 'P'; ?>
                  </div>
                  <div class="admin-details">
                    <strong><?php echo isset($r->nama_penghuni) ? $r->nama_penghuni : 'Tidak Diketahui'; ?></strong>
                    <small><?php echo isset($r->penghuni_email) ? $r->penghuni_email : '-'; ?></small>
                  </div>
                </div>
              </td>
              <td>
                <div class="admin-info">
                  <div class="admin-avatar bg-warning">
                    <?php echo isset($r->admin_nama) ? strtoupper(substr($r->admin_nama, 0, 1)) : 'A'; ?>
                  </div>
                  <div class="admin-details">
                    <strong><?php echo isset($r->admin_nama) ? $r->admin_nama : 'Tidak Diketahui'; ?></strong>
                    <small><?php echo isset($r->admin_email) ? $r->admin_email : '-'; ?></small>
                  </div>
                </div>
              </td>
              <td>
                <div class="report-preview" title="<?php echo isset($r->judul) ? htmlspecialchars($r->judul) : ''; ?>">
                  <?php echo isset($r->judul) ? htmlspecialchars($r->judul) : 'Tidak ada judul'; ?>
                </div>
              </td>
              <td>
                <?php if(isset($r->status)): ?>
                  <?php if($r->status == 'pending'): ?>
                    <span class="status-badge status-pending">Pending</span>
                  <?php elseif($r->status == 'diproses'): ?>
                    <span class="status-badge status-diproses">Diproses</span>
                  <?php elseif($r->status == 'diterima'): ?>
                    <span class="status-badge status-diterima">Diterima</span>
                  <?php else: ?>
                    <span class="status-badge status-ditolak">Ditolak</span>
                  <?php endif; ?>
                <?php else: ?>
                  <span class="status-badge status-pending">Tidak Diketahui</span>
                <?php endif; ?>
              </td>
              <td>
                <?php if(isset($r->tindakan)): ?>
                  <?php if($r->tindakan == 'peringatan'): ?>
                    <span class="action-badge action-peringatan">Peringatan</span>
                  <?php elseif($r->tindakan == 'nonaktif_sementara'): ?>
                    <span class="action-badge action-nonaktif">Nonaktif Sementara</span>
                  <?php elseif($r->tindakan == 'nonaktif_permanen'): ?>
                    <span class="action-badge action-nonaktif">Nonaktif Permanen</span>
                  <?php else: ?>
                    <span class="action-badge action-none">Belum Ada</span>
                  <?php endif; ?>
                <?php else: ?>
                  <span class="action-badge action-none">Belum Ada</span>
                <?php endif; ?>
              </td>
              <td>
                <div class="date-info">
                  <i class="far fa-calendar-alt"></i>
                  <?php echo isset($r->created_at) ? date('d M Y', strtotime($r->created_at)) : '-'; ?>
                </div>
              </td>
              <td>
                <?php if(isset($r->id_report)): ?>
                  <a href="<?php echo site_url('superadmin/superadmin/report_detail/'.$r->id_report); ?>" 
                     class="btn-action btn-info">
                    <i class="fas fa-eye"></i> Detail
                  </a>
                <?php else: ?>
                  <span class="btn-action btn-info disabled">
                    <i class="fas fa-eye"></i> Detail
                  </span>
                <?php endif; ?>
              </td>
            </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      <?php else: ?>
        <div class="empty-state">
          <i class="fas fa-flag"></i>
          <h5>Belum Ada Laporan</h5>
          <p>Belum ada laporan dari penghuni</p>
        </div>
      <?php endif; ?>
    </div>
  </div>

  <script src="<?php echo site_url('asset/js/jquery-3.6.0.min.js'); ?>"></script>
  <script src="<?php echo site_url('asset/js/bootstrap.bundle.min.js'); ?>"></script>

  <script>
    // Add hover effects to logout button
    document.addEventListener('DOMContentLoaded', function() {
      const logoutBtn = document.querySelector('.logout-btn');
      if (logoutBtn) {
        logoutBtn.addEventListener('mouseenter', function() {
          this.style.transform = 'translateY(-1px) scale(1.02)';
        });
        logoutBtn.addEventListener('mouseleave', function() {
          this.style.transform = 'translateY(0) scale(1)';
        });
      }
    });
  </script>
</body>
</html>