<!-- ============================================ -->
<!-- FILE 2: application/views/user/chat_v2/index.php -->
<!-- ============================================ -->
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $title ?></title>
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    
    <!-- Chat System CSS -->
    <link rel="stylesheet" href="<?= base_url('asset/css/chat_system.css') ?>">
</head>
<body 
    data-user-type="penghuni"
    data-user-id="<?= $user_info['id'] ?>"
    data-user-name="<?= htmlspecialchars($user_info['name']) ?>"
    data-user-avatar=""
    data-admin-id="<?= $admin_info['id'] ?>"
    data-admin-name="<?= htmlspecialchars($admin_info['name']) ?>"
    data-admin-avatar=""
    data-ws-url="ws://<?= $websocket_url ?>"
    data-api-url="<?= site_url('user/Chat_v2') ?>">
    
    <!-- Chat bubble will be created by JavaScript -->
    
    <!-- Scripts -->
    <script src="<?= base_url('asset/js/chat_system.js') ?>"></script>
    <script src="<?= base_url('asset/js/user_chat.js') ?>"></script>
    <script src="<?= base_url('asset/js/chat_init.js') ?>"></script>
</body>
</html>