<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title><?= $title ?> - KosCare</title>
    <link rel="stylesheet" href="<?= base_url('asset/css/bootstrap.min.css') ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <style>
        :root {
            --primary: #4a90e2;
            --primary-dark: #357abd;
            --secondary: #64748b;
            --success: #28a745;
            --warning: #ffc107;
            --danger: #dc3545;
            --light: #f8fafc;
            --dark: #0f172a;
            --border: #e2e8f0;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: #f0f8ff;
            color: var(--dark);
            line-height: 1.6;
        }

        /* Topbar */
        .topbar {
            background: white;
            padding: 16px 0;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            z-index: 1030;
            border-bottom: 1px solid var(--border);
        }

        .topbar-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 0 24px;
        }

        .brand {
            display: flex;
            align-items: center;
            gap: 12px;
            font-size: 1.25rem;
            font-weight: 700;
            color: var(--primary);
        }

        .brand i {
            font-size: 1.5rem;
        }

        .user-menu {
            display: flex;
            align-items: center;
            gap: 16px;
        }

        .user-info-badge {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 8px 16px;
            background: var(--light);
            border-radius: 8px;
            font-size: 0.9rem;
        }

        .user-avatar {
            width: 36px;
            height: 36px;
            border-radius: 50%;
            background: var(--primary);
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 600;
        }

        .logout-btn {
            padding: 8px 16px;
            background: var(--danger);
            color: white;
            border: none;
            border-radius: 8px;
            text-decoration: none;
            transition: all 0.2s;
            font-size: 0.9rem;
            display: inline-flex;
            align-items: center;
            gap: 8px;
        }

        .logout-btn:hover {
            background: #dc2626;
            color: white;
            transform: translateY(-1px);
        }

        /* Sidebar */
        .sidebar {
            background: white;
            width: 260px;
            height: calc(100vh - 65px);
            position: fixed;
            top: 65px;
            left: 0;
            padding: 24px 0;
            box-shadow: 1px 0 3px rgba(0, 0, 0, 0.05);
            overflow-y: auto;
            border-right: 1px solid var(--border);
        }

        .nav-section {
            padding: 0 16px;
            margin-bottom: 24px;
        }

        .nav-title {
            font-size: 0.75rem;
            font-weight: 600;
            text-transform: uppercase;
            color: var(--secondary);
            margin-bottom: 12px;
            letter-spacing: 0.5px;
        }

        .nav-item {
            margin-bottom: 4px;
        }

        .nav-link {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 12px 16px;
            color: var(--secondary);
            text-decoration: none;
            border-radius: 8px;
            transition: all 0.2s;
            font-size: 0.95rem;
        }

        .nav-link:hover {
            background: var(--light);
            color: var(--primary);
        }

        .nav-link.active {
            background: var(--primary);
            color: white;
        }

        .nav-link i {
            width: 20px;
            text-align: center;
        }

        /* Main Content */
        .main-content {
            margin-left: 260px;
            margin-top: 65px;
            padding: 32px;
            min-height: calc(100vh - 65px);
        }

        /* Back Button */
        .back-btn {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            padding: 10px 20px;
            background: white;
            color: var(--primary);
            border: 2px solid var(--primary);
            border-radius: 8px;
            text-decoration: none;
            font-weight: 500;
            transition: all 0.2s;
            margin-bottom: 24px;
        }

        .back-btn:hover {
            background: var(--primary);
            color: white;
            transform: translateX(-4px);
        }

        /* Detail Card */
        .detail-card {
            background: white;
            border-radius: 12px;
            padding: 32px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
            border: 1px solid var(--border);
        }

        .detail-header {
            display: flex;
            justify-content: space-between;
            align-items: start;
            margin-bottom: 24px;
            padding-bottom: 20px;
            border-bottom: 2px solid var(--border);
        }

        .detail-title {
            font-size: 1.75rem;
            font-weight: 700;
            color: var(--dark);
            margin-bottom: 8px;
        }

        .detail-subtitle {
            font-size: 0.95rem;
            color: var(--secondary);
            display: flex;
            align-items: center;
            gap: 6px;
        }

        /* Status Badge */
        .status-badge {
            padding: 8px 16px;
            border-radius: 20px;
            font-size: 0.875rem;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .status-badge.Diajukan {
            background: #fff3cd;
            color: #856404;
        }

        .status-badge.Diproses {
            background: #cce5ff;
            color: #004085;
        }

        .status-badge.Selesai {
            background: #d4edda;
            color: #155724;
        }

        /* Image Section */
        .image-section {
            margin-bottom: 32px;
        }

        .gambar-laporan {
            width: 100%;
            max-height: 500px;
            object-fit: cover;
            border-radius: 12px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }

        /* Content Section */
        .content-section {
            margin-bottom: 32px;
        }

        .section-title {
            font-size: 1.125rem;
            font-weight: 600;
            color: var(--dark);
            margin-bottom: 12px;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .section-title i {
            color: var(--primary);
        }

        .section-content {
            background: var(--light);
            padding: 20px;
            border-radius: 10px;
            color: var(--dark);
            line-height: 1.8;
            border-left: 4px solid var(--primary);
        }

        /* Info Grid */
        .info-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
            margin-top: 24px;
        }

        .info-item {
            background: var(--light);
            padding: 20px;
            border-radius: 10px;
            border-left: 4px solid var(--primary);
        }

        .info-label {
            font-size: 0.875rem;
            color: var(--secondary);
            font-weight: 500;
            margin-bottom: 6px;
            display: flex;
            align-items: center;
            gap: 6px;
        }

        .info-value {
            font-size: 1rem;
            color: var(--dark);
            font-weight: 600;
        }

        /* Kos Info Section */
        .kos-info {
            background: linear-gradient(135deg, var(--primary) 0%, var(--primary-dark) 100%);
            padding: 24px;
            border-radius: 12px;
            margin-top: 32px;
            color: white;
        }

        .kos-info h5 {
            font-size: 1.25rem;
            font-weight: 600;
            margin-bottom: 16px;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .kos-detail {
            display: flex;
            flex-direction: column;
            gap: 12px;
        }

        .kos-detail-item {
            display: flex;
            align-items: start;
            gap: 12px;
            background: rgba(255, 255, 255, 0.1);
            padding: 12px;
            border-radius: 8px;
        }

        .kos-detail-item i {
            margin-top: 2px;
            font-size: 1.1rem;
        }

        .kos-detail-item strong {
            display: block;
            margin-bottom: 4px;
            opacity: 0.9;
            font-size: 0.875rem;
        }

        /* Responsive */
        @media (max-width: 768px) {
            .sidebar {
                transform: translateX(-100%);
            }

            .main-content {
                margin-left: 0;
                padding: 16px;
            }

            .topbar-content {
                padding: 0 16px;
            }

            .user-info-badge {
                display: none;
            }

            .detail-header {
                flex-direction: column;
                gap: 16px;
            }

            .detail-card {
                padding: 20px;
            }

            .info-grid {
                grid-template-columns: 1fr;
            }
        }

        /* Scrollbar */
        .sidebar::-webkit-scrollbar {
            width: 6px;
        }

        .sidebar::-webkit-scrollbar-track {
            background: transparent;
        }

        .sidebar::-webkit-scrollbar-thumb {
            background: var(--border);
            border-radius: 3px;
        }

        .sidebar::-webkit-scrollbar-thumb:hover {
            background: var(--secondary);
        }
    </style>
</head>

<body>
    <!-- Topbar -->
    <div class="topbar">
        <div class="topbar-content">
            <div class="brand">
                <div class="login-icon">
                    <img src="<?= base_url('asset/logo.png'); ?>" alt="Logo KosCare" style="width: 50px; height: auto;">
                </div>
                <span>KosCare</span>
            </div>
            <div class="user-menu">
                <div class="user-info-badge">
                    <div class="user-avatar">
                        P
                    </div>
                    <div>
                        <div style="font-weight: 600; font-size: 0.9rem;">Penghuni</div>
                        <div style="font-size: 0.75rem; color: var(--secondary);">User</div>
                    </div>
                </div>
                <a href="<?= site_url('user/login/logout') ?>" class="logout-btn">
                    <i class="fas fa-sign-out-alt"></i>
                    <span>Logout</span>
                </a>
            </div>
        </div>
    </div>

    <!-- Sidebar -->
    <div class="sidebar">
        <nav class="nav-section">
            <div class="nav-title">Menu Utama</div>
            <div class="nav-item">
                <a href="<?= site_url('user/dashboard') ?>" class="nav-link">
                    <i class="fas fa-home"></i>
                    <span>Dashboard</span>
                </a>
            </div>
            <div class="nav-item">
                <a href="<?= site_url('user/dashboard/laporan') ?>" class="nav-link active">
                    <i class="fas fa-clipboard-list"></i>
                    <span>Laporan Saya</span>
                </a>
            </div>
            <div class="nav-item">
                <a href="<?= site_url('user/dashboard/tambah') ?>" class="nav-link">
                    <i class="fas fa-plus-circle"></i>
                    <span>Buat Laporan</span>
                </a>
            </div>
        </nav>

        <nav class="nav-section">
            <div class="nav-title">Pengaturan</div>
            <div class="nav-item">
                <a href="<?= site_url('user/dashboard/profile') ?>" class="nav-link">
                    <i class="fas fa-user"></i>
                    <span>Profil Saya</span>
                </a>
            </div>
        </nav>
    </div>

    <!-- Main Content -->
    <div class="main-content">
        <!-- Detail Card -->
        <div class="detail-card">
            <div class="detail-header">
                <div>
                    <h1 class="detail-title"><?= $laporan->judul; ?></h1>
                    <div class="detail-subtitle">
                        <i class="far fa-calendar-alt"></i>
                        <span>Dilaporkan pada <?= date('d M Y, H:i', strtotime($laporan->tanggal_laporan)); ?></span>
                    </div>
                </div>
                <span class="status-badge <?= $laporan->status; ?>">
                    <?= $laporan->status; ?>
                </span>
            </div>

            <!-- Image Section -->
            <?php if (!empty($laporan->gambar)) : ?>
                <div class="image-section">
                    <img src="<?= base_url('asset/laporan/' . $laporan->gambar); ?>" alt="Gambar Laporan" class="gambar-laporan">
                </div>
            <?php endif; ?>

            <!-- Description Section -->
            <div class="content-section">
                <h3 class="section-title">
                    <i class="fas fa-align-left"></i>
                    <span>Deskripsi Laporan</span>
                </h3>
                <div class="section-content">
                    <?= nl2br(htmlspecialchars($laporan->deskripsi)); ?>
                </div>
            </div>

            <!-- Info Grid -->
            <div class="info-grid">
                <div class="info-item">
                    <div class="info-label">
                        <i class="far fa-clock"></i>
                        <span>Tanggal Laporan</span>
                    </div>
                    <div class="info-value">
                        <?= date('d M Y, H:i', strtotime($laporan->tanggal_laporan)); ?>
                    </div>
                </div>

                <?php if (!empty($laporan->tanggal_selesai)) : ?>
                    <div class="info-item">
                        <div class="info-label">
                            <i class="far fa-check-circle"></i>
                            <span>Tanggal Selesai</span>
                        </div>
                        <div class="info-value">
                            <?= date('d M Y, H:i', strtotime($laporan->tanggal_selesai)); ?>
                        </div>
                    </div>
                <?php endif; ?>

                <div class="info-item">
                    <div class="info-label">
                        <i class="fas fa-info-circle"></i>
                        <span>Status Laporan</span>
                    </div>
                    <div class="info-value">
                        <span class="status-badge <?= $laporan->status; ?>">
                            <?= $laporan->status; ?>
                        </span>
                    </div>
                </div>
            </div>

            <!-- Kos Information -->
            <?php if (!empty($laporan->nama_kos)) : ?>
                <div class="kos-info">
                    <h5>
                        <i class="fas fa-building"></i>
                        <span>Informasi Kos</span>
                    </h5>
                    <div class="kos-detail">
                        <div class="kos-detail-item">
                            <i class="fas fa-home"></i>
                            <div>
                                <strong>Nama Kos</strong>
                                <?= $laporan->nama_kos; ?>
                            </div>
                        </div>
                        <div class="kos-detail-item">
                            <i class="fas fa-map-marker-alt"></i>
                            <div>
                                <strong>Alamat</strong>
                                <?= $laporan->alamat; ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <script src="<?= base_url('asset/js/jquery-3.6.0.min.js') ?>"></script>
    <script src="<?= base_url('asset/js/bootstrap.bundle.min.js') ?>"></script>
</body>

</html>