<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title><?= $title ?> - KosCare</title>
    <link rel="stylesheet" href="<?= base_url('asset/css/bootstrap.min.css') ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <style>
        :root {
            --primary: #4a90e2;
            --primary-dark: #357abd;
            --secondary: #64748b;
            --success: #28a745;
            --warning: #ffc107;
            --danger: #dc3545;
            --light: #f8fafc;
            --dark: #0f172a;
            --border: #e2e8f0;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: #f0f8ff;
            color: var(--dark);
            line-height: 1.6;
        }

        /* Topbar */
        .topbar {
            background: white;
            padding: 16px 0;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            z-index: 1030;
            border-bottom: 1px solid var(--border);
        }

        .topbar-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 0 24px;
        }

        .brand {
            display: flex;
            align-items: center;
            gap: 12px;
            font-size: 1.25rem;
            font-weight: 700;
            color: var(--primary);
        }

        .brand i {
            font-size: 1.5rem;
        }

        .user-menu {
            display: flex;
            align-items: center;
            gap: 16px;
        }

        .user-info-badge {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 8px 16px;
            background: var(--light);
            border-radius: 8px;
            font-size: 0.9rem;
        }

        .user-avatar {
            width: 36px;
            height: 36px;
            border-radius: 50%;
            background: var(--primary);
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 600;
        }

        .logout-btn {
            padding: 8px 16px;
            background: var(--danger);
            color: white;
            border: none;
            border-radius: 8px;
            text-decoration: none;
            transition: all 0.2s;
            font-size: 0.9rem;
            display: inline-flex;
            align-items: center;
            gap: 8px;
        }

        .logout-btn:hover {
            background: #dc2626;
            color: white;
            transform: translateY(-1px);
        }

        /* Sidebar */
        .sidebar {
            background: white;
            width: 260px;
            height: calc(100vh - 65px);
            position: fixed;
            top: 65px;
            left: 0;
            padding: 24px 0;
            box-shadow: 1px 0 3px rgba(0, 0, 0, 0.05);
            overflow-y: auto;
            border-right: 1px solid var(--border);
        }

        .nav-section {
            padding: 0 16px;
            margin-bottom: 24px;
        }

        .nav-title {
            font-size: 0.75rem;
            font-weight: 600;
            text-transform: uppercase;
            color: var(--secondary);
            margin-bottom: 12px;
            letter-spacing: 0.5px;
        }

        .nav-item {
            margin-bottom: 4px;
        }

        .nav-link {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 12px 16px;
            color: var(--secondary);
            text-decoration: none;
            border-radius: 8px;
            transition: all 0.2s;
            font-size: 0.95rem;
        }

        .nav-link:hover {
            background: var(--light);
            color: var(--primary);
        }

        .nav-link.active {
            background: var(--primary);
            color: white;
        }

        .nav-link i {
            width: 20px;
            text-align: center;
        }

        /* Main Content */
        .main-content {
            margin-left: 260px;
            margin-top: 65px;
            padding: 32px;
            min-height: calc(100vh - 65px);
        }

        /* Page Header */
        .page-header {
            background: linear-gradient(135deg, var(--primary) 0%, var(--primary-dark) 100%);
            padding: 32px;
            border-radius: 16px;
            margin-bottom: 32px;
            box-shadow: 0 4px 6px rgba(37, 99, 235, 0.1);
            color: white;
        }

        .page-header h1 {
            font-size: 1.875rem;
            font-weight: 700;
            margin-bottom: 8px;
        }

        .page-header p {
            font-size: 1rem;
            opacity: 0.9;
        }

        /* Content Card */
        .content-card {
            background: white;
            border-radius: 12px;
            padding: 24px;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
            border: 1px solid var(--border);
            margin-bottom: 24px;
        }

        .card-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 24px;
            padding-bottom: 16px;
            border-bottom: 1px solid var(--border);
        }

        .card-title {
            font-size: 1.125rem;
            font-weight: 600;
            color: var(--dark);
            display: flex;
            align-items: center;
            gap: 8px;
        }

        /* Alerts */
        .alert {
            padding: 16px 20px;
            border-radius: 10px;
            margin-bottom: 24px;
            display: flex;
            align-items: center;
            gap: 12px;
            animation: slideDown 0.3s ease-out;
        }

        .alert-success {
            background: #d4edda;
            border-left: 4px solid var(--success);
            color: #155724;
        }

        .alert-danger {
            background: #f8d7da;
            border-left: 4px solid var(--danger);
            color: #721c24;
        }

        @keyframes slideDown {
            from {
                opacity: 0;
                transform: translateY(-20px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* Form Styles */
        .form-laporan {
            max-width: 800px;
        }

        .form-group {
            margin-bottom: 24px;
        }

        .form-group label {
            display: block;
            margin-bottom: 8px;
            font-weight: 600;
            color: var(--dark);
            font-size: 0.95rem;
        }

        .required {
            color: var(--danger);
        }

        .form-control {
            width: 100%;
            padding: 12px 16px;
            border: 2px solid var(--border);
            border-radius: 8px;
            font-size: 0.95rem;
            transition: all 0.2s;
            font-family: inherit;
        }

        .form-control:focus {
            outline: none;
            border-color: var(--primary);
            box-shadow: 0 0 0 3px rgba(74, 144, 226, 0.1);
        }

        textarea.form-control {
            resize: vertical;
            min-height: 120px;
        }

        .text-danger {
            color: var(--danger);
            font-size: 0.875rem;
            margin-top: 5px;
            display: block;
        }

        /* Current Image */
        .current-image {
            background: var(--light);
            padding: 20px;
            border-radius: 12px;
            margin-bottom: 20px;
            border: 2px solid var(--border);
        }

        .current-image p {
            margin: 0 0 12px 0;
            color: var(--dark);
            font-weight: 500;
        }

        .current-image img {
            max-width: 100%;
            max-height: 300px;
            border-radius: 8px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            margin-bottom: 12px;
            display: block;
        }

        .image-info {
            font-size: 0.875rem;
            color: var(--secondary);
            margin-top: 12px !important;
            display: flex;
            align-items: center;
            gap: 8px;
            background: white;
            padding: 10px 12px;
            border-radius: 6px;
            border-left: 3px solid var(--primary);
        }

        /* Upload Area */
        .upload-area {
            position: relative;
            border: 2px dashed var(--border);
            border-radius: 12px;
            padding: 40px 20px;
            text-align: center;
            transition: all 0.3s;
            cursor: pointer;
            background: var(--light);
        }

        .upload-area:hover {
            border-color: var(--primary);
            background: #f0f7ff;
        }

        .upload-area.dragover {
            border-color: var(--primary);
            background: #e7f3ff;
            transform: scale(1.02);
        }

        .form-control-file {
            position: absolute;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            opacity: 0;
            cursor: pointer;
        }

        .upload-placeholder {
            pointer-events: none;
        }

        .upload-placeholder i {
            font-size: 3rem;
            color: var(--primary);
            margin-bottom: 16px;
            display: block;
        }

        .upload-placeholder p {
            margin: 10px 0 5px;
            font-size: 1rem;
            color: var(--dark);
            font-weight: 500;
        }

        .upload-placeholder small {
            color: var(--secondary);
            font-size: 0.875rem;
        }

        .image-preview {
            display: none;
            margin-top: 20px;
            text-align: center;
        }

        .image-preview.show {
            display: block;
        }

        .image-preview img {
            max-width: 100%;
            max-height: 300px;
            border-radius: 12px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }

        .remove-image {
            display: inline-flex;
            align-items: center;
            gap: 6px;
            margin-top: 12px;
            color: var(--danger);
            cursor: pointer;
            font-size: 0.9rem;
            font-weight: 500;
            transition: all 0.2s;
        }

        .remove-image:hover {
            color: #dc2626;
            transform: translateY(-1px);
        }

        /* Form Actions */
        .form-actions {
            display: flex;
            gap: 12px;
            margin-top: 32px;
            padding-top: 24px;
            border-top: 1px solid var(--border);
        }

        /* Buttons */
        .btn-primary {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            padding: 12px 24px;
            background: var(--primary);
            color: white;
            border: none;
            border-radius: 8px;
            text-decoration: none;
            font-weight: 500;
            transition: all 0.2s;
            cursor: pointer;
            font-size: 1rem;
        }

        .btn-primary:hover {
            background: var(--primary-dark);
            color: white;
            transform: translateY(-2px);
            box-shadow: 0 4px 6px rgba(37, 99, 235, 0.2);
        }

        .btn-secondary {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            padding: 12px 24px;
            background: white;
            color: var(--secondary);
            border: 2px solid var(--border);
            border-radius: 8px;
            text-decoration: none;
            font-weight: 500;
            transition: all 0.2s;
            cursor: pointer;
            font-size: 1rem;
        }

        .btn-secondary:hover {
            background: var(--light);
            color: var(--dark);
            border-color: var(--secondary);
        }

        /* Responsive */
        @media (max-width: 768px) {
            .sidebar {
                transform: translateX(-100%);
            }

            .main-content {
                margin-left: 0;
                padding: 16px;
            }

            .topbar-content {
                padding: 0 16px;
            }

            .user-info-badge {
                display: none;
            }

            .form-actions {
                flex-direction: column;
            }

            .btn-primary,
            .btn-secondary {
                width: 100%;
                justify-content: center;
            }

            .current-image img {
                max-width: 100%;
            }
        }

        /* Scrollbar */
        .sidebar::-webkit-scrollbar {
            width: 6px;
        }

        .sidebar::-webkit-scrollbar-track {
            background: transparent;
        }

        .sidebar::-webkit-scrollbar-thumb {
            background: var(--border);
            border-radius: 3px;
        }

        .sidebar::-webkit-scrollbar-thumb:hover {
            background: var(--secondary);
        }
    </style>
</head>

<body>
    <!-- Topbar -->
    <div class="topbar">
        <div class="topbar-content">
            <div class="brand">
                <div class="login-icon">
                    <img src="<?= base_url('asset/logo.png'); ?>" alt="Logo KosCare" style="width: 50px; height: auto;">
                </div>
                <span>KosCare</span>
            </div>
            <div class="user-menu">
                <div class="user-info-badge">
                    <div class="user-avatar">
                        <?= strtoupper(substr($user->nama_penghuni, 0, 1)) ?>
                    </div>
                    <div>
                        <div style="font-weight: 600; font-size: 0.9rem;"><?= $user->nama_penghuni ?></div>
                        <div style="font-size: 0.75rem; color: var(--secondary);">Penghuni</div>
                    </div>
                </div>
                <a href="<?= site_url('user/login/logout') ?>" class="logout-btn">
                    <i class="fas fa-sign-out-alt"></i>
                    <span>Logout</span>
                </a>
            </div>
        </div>
    </div>

    <!-- Sidebar -->
    <div class="sidebar">
        <nav class="nav-section">
            <div class="nav-title">Menu Utama</div>
            <div class="nav-item">
                <a href="<?= site_url('user/dashboard') ?>" class="nav-link">
                    <i class="fas fa-home"></i>
                    <span>Dashboard</span>
                </a>
            </div>
            <div class="nav-item">
                <a href="<?= site_url('user/dashboard/laporan') ?>" class="nav-link active">
                    <i class="fas fa-clipboard-list"></i>
                    <span>Laporan Saya</span>
                </a>
            </div>
            <div class="nav-item">
                <a href="<?= site_url('user/dashboard/tambah') ?>" class="nav-link">
                    <i class="fas fa-plus-circle"></i>
                    <span>Buat Laporan</span>
                </a>
            </div>
        </nav>

        <nav class="nav-section">
            <div class="nav-title">Pengaturan</div>
            <div class="nav-item">
                <a href="<?= site_url('user/dashboard/profile') ?>" class="nav-link">
                    <i class="fas fa-user"></i>
                    <span>Profil Saya</span>
                </a>
            </div>
        </nav>
    </div>

    <!-- Main Content -->
    <div class="main-content">
        <!-- Alerts -->
        <?php if ($this->session->flashdata('success')): ?>
            <div class="alert alert-success">
                <i class="fas fa-check-circle"></i>
                <span><?= $this->session->flashdata('success') ?></span>
            </div>
        <?php endif; ?>

        <?php if ($this->session->flashdata('error')): ?>
            <div class="alert alert-danger">
                <i class="fas fa-exclamation-circle"></i>
                <span><?= $this->session->flashdata('error') ?></span>
            </div>
        <?php endif; ?>

        <!-- Page Header -->
        <div class="page-header">
            <h1>Edit Laporan ✏️</h1>
            <p>Ubah detail laporan Anda sesuai kebutuhan</p>
        </div>

        <!-- Form Card -->
        <div class="content-card">
            <div class="card-header">
                <h2 class="card-title">
                    <i class="fas fa-edit"></i>
                    <span>Form Edit Laporan</span>
                </h2>
                <a href="<?= site_url('user/dashboard/laporan') ?>" class="btn-secondary">
                    <i class="fas fa-arrow-left"></i>
                    <span>Kembali</span>
                </a>
            </div>

            <form action="<?= site_url('user/laporan/update') ?>" method="post" enctype="multipart/form-data" class="form-laporan">
                <input type="hidden" name="id_laporan" value="<?= $laporan->id_laporan ?>">

                <div class="form-group">
                    <label for="judul">Judul Laporan <span class="required">*</span></label>
                    <input type="text"
                        class="form-control"
                        id="judul"
                        name="judul"
                        placeholder="Contoh: Kerusakan Fasilitas Kamar Mandi"
                        required
                        maxlength="150"
                        value="<?= set_value('judul', $laporan->judul) ?>">
                    <?= form_error('judul', '<small class="text-danger">', '</small>') ?>
                </div>

                <div class="form-group">
                    <label for="deskripsi">Deskripsi Laporan <span class="required">*</span></label>
                    <textarea class="form-control"
                        id="deskripsi"
                        name="deskripsi"
                        rows="8"
                        placeholder="Jelaskan detail laporan Anda dengan lengkap..."
                        required><?= set_value('deskripsi', $laporan->deskripsi) ?></textarea>
                    <?= form_error('deskripsi', '<small class="text-danger">', '</small>') ?>
                </div>

                <div class="form-group">
                    <label for="gambar">Upload Gambar Baru (Opsional)</label>

                    <?php if ($laporan->gambar): ?>
                        <div class="current-image">
                            <p><i class="fas fa-image"></i> <strong>Gambar Saat Ini:</strong></p>
                            <img src="<?= base_url('asset/laporan/' . $laporan->gambar) ?>" alt="Gambar Laporan">
                            <p class="image-info">
                                <i class="fas fa-info-circle"></i>
                                <span>Jika Anda upload gambar baru, gambar ini akan diganti</span>
                            </p>
                        </div>
                    <?php endif; ?>

                    <div class="upload-area" id="uploadArea">
                        <input type="file"
                            class="form-control-file"
                            id="gambar"
                            name="gambar"
                            accept="image/jpeg,image/jpg,image/png,image/gif">
                        <div class="upload-placeholder">
                            <i class="fas fa-cloud-upload-alt"></i>
                            <p>Klik atau drag & drop gambar di sini</p>
                            <small>Format: JPG, JPEG, PNG, GIF (Maks. 2MB)</small>
                        </div>
                        <div class="image-preview" id="imagePreview"></div>
                    </div>
                </div>

                <div class="form-actions">
                    <button type="submit" class="btn-primary">
                        <i class="fas fa-save"></i>
                        <span>Simpan Perubahan</span>
                    </button>
                    <a href="<?= site_url('user/dashboard/laporan') ?>" class="btn-secondary">
                        <i class="fas fa-times"></i>
                        <span>Batal</span>
                    </a>
                </div>

            </form>
        </div>
    </div>

    <script src="<?= base_url('asset/js/jquery-3.6.0.min.js') ?>"></script>
    <script src="<?= base_url('asset/js/bootstrap.bundle.min.js') ?>"></script>

    <script>
        // Auto hide alerts
        document.addEventListener('DOMContentLoaded', function() {
            const alerts = document.querySelectorAll('.alert');
            alerts.forEach(alert => {
                setTimeout(() => {
                    alert.style.animation = 'slideUp 0.3s ease-out';
                    setTimeout(() => alert.remove(), 300);
                }, 5000);
            });

            const style = document.createElement('style');
            style.textContent = `
                @keyframes slideUp {
                    from { opacity: 1; transform: translateY(0); }
                    to { opacity: 0; transform: translateY(-20px); }
                }
            `;
            document.head.appendChild(style);

            // Upload area functionality
            const uploadArea = document.getElementById('uploadArea');
            const fileInput = document.getElementById('gambar');
            const imagePreview = document.getElementById('imagePreview');
            const uploadPlaceholder = uploadArea.querySelector('.upload-placeholder');

            // Preview gambar saat dipilih
            fileInput.addEventListener('change', function(e) {
                handleFiles(this.files);
            });

            // Drag & drop functionality
            uploadArea.addEventListener('dragover', function(e) {
                e.preventDefault();
                uploadArea.classList.add('dragover');
            });

            uploadArea.addEventListener('dragleave', function(e) {
                e.preventDefault();
                uploadArea.classList.remove('dragover');
            });

            uploadArea.addEventListener('drop', function(e) {
                e.preventDefault();
                uploadArea.classList.remove('dragover');

                const files = e.dataTransfer.files;
                fileInput.files = files;
                handleFiles(files);
            });

            function handleFiles(files) {
                if (files.length > 0) {
                    const file = files[0];

                    // Validasi tipe file
                    if (!file.type.match('image.*')) {
                        alert('File harus berupa gambar!');
                        return;
                    }

                    // Validasi ukuran file (2MB)
                    if (file.size > 2048000) {
                        alert('Ukuran file maksimal 2MB!');
                        return;
                    }

                    const reader = new FileReader();

                    reader.onload = function(e) {
                        uploadPlaceholder.style.display = 'none';
                        imagePreview.innerHTML = `
                            <img src="${e.target.result}" alt="Preview">
                            <div class="remove-image" onclick="removeImage()">
                                <i class="fas fa-times-circle"></i> Hapus Gambar Baru
                            </div>
                        `;
                        imagePreview.classList.add('show');
                    };

                    reader.readAsDataURL(file);
                }
            }

            window.removeImage = function() {
                fileInput.value = '';
                imagePreview.innerHTML = '';
                imagePreview.classList.remove('show');
                uploadPlaceholder.style.display = 'block';
            };
        });
    </script>
</body>

</html>