<?php
// Check if admin has active subscription - handled in controller
// Variables: $admin_has_subscription, $admin_suspended
?>
<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title><?= $title ?> - KosCare</title>
    <link rel="stylesheet" href="<?= base_url('asset/css/bootstrap.min.css') ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <?php if ($admin_has_subscription && (!isset($admin_suspended['suspended']) || !$admin_suspended['suspended'])): ?>
        <!-- Chat System CSS - Only load if admin has subscription and not suspended -->
        <link rel="stylesheet" href="<?= base_url('asset/css/chat_system.css') ?>">
    <?php endif; ?>

    <style>
        /* ========== SAMA PERSIS DENGAN PROFIL.PHP ========== */
        :root {
            --primary: #4a90e2;
            --primary-dark: #357abd;
            --secondary: #64748b;
            --success: #28a745;
            --warning: #ffc107;
            --danger: #dc3545;
            --light: #f8fafc;
            --dark: #0f172a;
            --border: #e2e8f0;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: #f0f8ff;
            color: var(--dark);
            line-height: 1.6;
        }

        /* Topbar - SAMA PERSIS */
        .topbar {
            background: white;
            padding: 16px 0;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            z-index: 1030;
            border-bottom: 1px solid var(--border);
        }

        .topbar-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 0 24px;
        }

        .brand {
            display: flex;
            align-items: center;
            gap: 12px;
            font-size: 1.25rem;
            font-weight: 700;
            color: var(--primary);
        }

        .brand i {
            font-size: 1.5rem;
        }

        .user-menu {
            display: flex;
            align-items: center;
            gap: 16px;
        }

        .user-info-badge {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 8px 16px;
            background: var(--light);
            border-radius: 8px;
            font-size: 0.9rem;
        }

        .user-avatar {
            width: 36px;
            height: 36px;
            border-radius: 50%;
            background: var(--primary);
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 600;
        }

        .logout-btn {
            padding: 8px 16px;
            background: var(--danger);
            color: white;
            border: none;
            border-radius: 8px;
            text-decoration: none;
            transition: all 0.2s;
            font-size: 0.9rem;
            display: inline-flex;
            align-items: center;
            gap: 8px;
        }

        .logout-btn:hover {
            background: #dc2626;
            color: white;
            transform: translateY(-1px);
        }

        /* Sidebar - SAMA PERSIS */
        .sidebar {
            background: white;
            width: 260px;
            height: calc(100vh - 65px);
            position: fixed;
            top: 65px;
            left: 0;
            padding: 24px 0;
            box-shadow: 1px 0 3px rgba(0, 0, 0, 0.05);
            overflow-y: auto;
            border-right: 1px solid var(--border);
        }

        .nav-section {
            padding: 0 16px;
            margin-bottom: 24px;
        }

        .nav-title {
            font-size: 0.75rem;
            font-weight: 600;
            text-transform: uppercase;
            color: var(--secondary);
            margin-bottom: 12px;
            letter-spacing: 0.5px;
        }

        .nav-item {
            margin-bottom: 4px;
        }

        .nav-link {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 12px 16px;
            color: var(--secondary);
            text-decoration: none;
            border-radius: 8px;
            transition: all 0.2s;
            font-size: 0.95rem;
        }

        .nav-link:hover {
            background: var(--light);
            color: var(--primary);
        }

        .nav-link.active {
            background: var(--primary);
            color: white;
        }

        .nav-link i {
            width: 20px;
            text-align: center;
        }

        /* Disabled action styles - SAMA PERSIS */
        .disabled-action {
            opacity: 0.6;
            cursor: not-allowed;
            position: relative;
        }

        .disabled-action::after {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(255, 255, 255, 0.5);
            border-radius: 8px;
            z-index: 1;
        }

        .disabled-action-text {
            position: relative;
            z-index: 2;
        }

        /* Main Content */
        .main-content {
            margin-left: 260px;
            margin-top: 65px;
            padding: 32px;
            min-height: calc(100vh - 65px);
        }

        /* Responsive - SAMA PERSIS */
        @media (max-width: 768px) {
            .sidebar {
                transform: translateX(-100%);
            }

            .main-content {
                margin-left: 0;
                padding: 16px;
            }

            .topbar-content {
                padding: 0 16px;
            }

            .user-info-badge {
                display: none;
            }

            .admin-suspended-content {
                flex-direction: column;
                text-align: center;
            }

            .admin-suspended-icon {
                margin: 0 auto 15px;
            }
        }

        /* Scrollbar - SAMA PERSIS */
        .sidebar::-webkit-scrollbar {
            width: 6px;
        }

        .sidebar::-webkit-scrollbar-track {
            background: transparent;
        }

        .sidebar::-webkit-scrollbar-thumb {
            background: var(--border);
            border-radius: 3px;
        }

        .sidebar::-webkit-scrollbar-thumb:hover {
            background: var(--secondary);
        }

        /* ========== STYLE KHUSUS INDEX.PHP ========== */
        /* Welcome Section */
        .welcome-section {
            background: linear-gradient(135deg, var(--primary) 0%, var(--primary-dark) 100%);
            padding: 32px;
            border-radius: 16px;
            margin-bottom: 32px;
            box-shadow: 0 4px 6px rgba(37, 99, 235, 0.1);
            color: white;
        }

        .welcome-section h1 {
            font-size: 1.875rem;
            font-weight: 700;
            margin-bottom: 8px;
        }

        .welcome-section p {
            font-size: 1rem;
            opacity: 0.9;
        }

        .room-badge {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            padding: 6px 12px;
            background: rgba(255, 255, 255, 0.2);
            border-radius: 6px;
            margin-top: 12px;
        }

        /* Admin Suspended Alert */
        .admin-suspended-alert {
            border-radius: 12px;
            margin-bottom: 24px;
            border-left: 5px solid;
            animation: slideDown 0.5s ease-out;
        }

        .admin-suspended-alert.permanent {
            background: linear-gradient(135deg, #ffebee 0%, #ffcdd2 100%);
            border-left-color: var(--danger);
        }

        .admin-suspended-alert.temporary {
            background: linear-gradient(135deg, #fff8e1 0%, #ffecb3 100%);
            border-left-color: var(--warning);
        }

        .admin-suspended-content {
            display: flex;
            align-items: flex-start;
            padding: 20px;
            gap: 15px;
        }

        .admin-suspended-icon {
            font-size: 2.5rem;
            flex-shrink: 0;
            margin-top: 5px;
        }

        .admin-suspended-details {
            flex: 1;
        }

        .admin-suspended-details h4 {
            margin: 0 0 10px 0;
            font-size: 1.1rem;
        }

        .admin-suspended-details p {
            margin: 5px 0;
            font-size: 0.95rem;
        }

        .suspended-timer {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            background: rgba(0, 0, 0, 0.1);
            padding: 6px 12px;
            border-radius: 20px;
            margin-top: 10px;
            font-weight: 600;
            animation: pulse 2s infinite;
        }

        /* Iklan Section */
        .iklan-section {
            margin-bottom: 32px;
        }

        .iklan-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 20px;
        }

        .iklan-card {
            background: white;
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
            transition: all 0.3s ease;
            cursor: pointer;
            border: 1px solid var(--border);
            position: relative;
        }

        .iklan-card:hover {
            transform: translateY(-4px);
            box-shadow: 0 8px 16px rgba(0, 0, 0, 0.15);
        }

        .iklan-badge {
            position: absolute;
            top: 12px;
            right: 12px;
            background: rgba(74, 144, 226, 0.95);
            color: white;
            padding: 4px 12px;
            border-radius: 20px;
            font-size: 0.75rem;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            z-index: 10;
        }

        .iklan-image {
            width: 100%;
            height: 200px;
            object-fit: cover;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 3rem;
        }

        .iklan-image img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        .iklan-content {
            padding: 20px;
        }

        .iklan-title {
            font-size: 1.125rem;
            font-weight: 600;
            color: var(--dark);
            margin-bottom: 8px;
            display: -webkit-box;
            -webkit-line-clamp: 2;
            -webkit-box-orient: vertical;
            overflow: hidden;
        }

        .iklan-description {
            font-size: 0.875rem;
            color: var(--secondary);
            line-height: 1.5;
            display: -webkit-box;
            -webkit-line-clamp: 3;
            -webkit-box-orient: vertical;
            overflow: hidden;
            margin-bottom: 16px;
        }

        .iklan-link {
            display: inline-flex;
            align-items: center;
            gap: 6px;
            color: var(--primary);
            font-weight: 500;
            font-size: 0.875rem;
            text-decoration: none;
            transition: all 0.2s;
        }

        .iklan-link:hover {
            color: var(--primary-dark);
            gap: 8px;
        }

        /* Stats Grid */
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));
            gap: 24px;
            margin-bottom: 32px;
        }

        .stat-card {
            background: white;
            padding: 24px;
            border-radius: 12px;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
            border: 1px solid var(--border);
            transition: all 0.2s;
            position: relative;
            overflow: hidden;
        }

        .stat-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 4px;
            height: 100%;
            background: var(--primary);
        }

        .stat-card:hover {
            transform: translateY(-4px);
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }

        .stat-card.warning::before {
            background: var(--warning);
        }

        .stat-card.success::before {
            background: var(--success);
        }

        .stat-header {
            display: flex;
            justify-content: space-between;
            align-items: start;
            margin-bottom: 16px;
        }

        .stat-icon {
            width: 48px;
            height: 48px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.5rem;
        }

        .stat-card .stat-icon {
            background: rgba(37, 99, 235, 0.1);
            color: var(--primary);
        }

        .stat-card.warning .stat-icon {
            background: rgba(245, 158, 11, 0.1);
            color: var(--warning);
        }

        .stat-card.success .stat-icon {
            background: rgba(16, 185, 129, 0.1);
            color: var(--success);
        }

        .stat-value {
            font-size: 2.25rem;
            font-weight: 700;
            color: var(--dark);
            line-height: 1;
            margin-bottom: 8px;
        }

        .stat-label {
            font-size: 0.875rem;
            color: var(--secondary);
            font-weight: 500;
        }

        /* Content Card */
        .content-card {
            background: white;
            border-radius: 12px;
            padding: 24px;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
            border: 1px solid var(--border);
            margin-bottom: 24px;
        }

        .card-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 24px;
            padding-bottom: 16px;
            border-bottom: 1px solid var(--border);
        }

        .card-title {
            font-size: 1.125rem;
            font-weight: 600;
            color: var(--dark);
            display: flex;
            align-items: center;
            gap: 8px;
        }

        /* Report Items */
        .report-list {
            display: flex;
            flex-direction: column;
            gap: 12px;
        }

        .report-item {
            padding: 16px;
            background: var(--light);
            border-radius: 10px;
            border-left: 3px solid var(--primary);
            transition: all 0.2s;
        }

        .report-item:hover {
            background: #f1f5f9;
            transform: translateX(4px);
        }

        .report-item.status-diproses {
            border-left-color: var(--primary);
        }

        .report-item.status-diajukan {
            border-left-color: var(--warning);
        }

        .report-item.status-selesai {
            border-left-color: var(--success);
        }

        .report-header {
            display: flex;
            justify-content: space-between;
            align-items: start;
            margin-bottom: 8px;
        }

        .report-title {
            font-weight: 600;
            color: var(--dark);
            margin-bottom: 4px;
        }

        .report-time {
            font-size: 0.8rem;
            color: var(--secondary);
            display: flex;
            align-items: center;
            gap: 4px;
        }

        .status-badge {
            padding: 4px 12px;
            border-radius: 20px;
            font-size: 0.75rem;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .status-badge.diajukan {
            background: #fff3cd;
            color: #856404;
        }

        .status-badge.diproses {
            background: #cce5ff;
            color: #004085;
        }

        .status-badge.selesai {
            background: #d4edda;
            color: #155724;
        }

        /* Empty State */
        .empty-state {
            text-align: center;
            padding: 64px 24px;
        }

        .empty-state-icon {
            font-size: 4rem;
            color: var(--border);
            margin-bottom: 16px;
        }

        .empty-state-title {
            font-size: 1.125rem;
            font-weight: 600;
            color: var(--secondary);
            margin-bottom: 8px;
        }

        .empty-state-text {
            color: var(--secondary);
            margin-bottom: 24px;
        }

        /* Buttons */
        .btn-primary {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            padding: 12px 24px;
            background: var(--primary);
            color: white;
            border: none;
            border-radius: 8px;
            text-decoration: none;
            font-weight: 500;
            transition: all 0.2s;
            cursor: pointer;
        }

        .btn-primary:hover {
            background: var(--primary-dark);
            color: white;
            transform: translateY(-2px);
            box-shadow: 0 4px 6px rgba(37, 99, 235, 0.2);
        }

        .btn-primary:disabled {
            background: #ccc;
            color: #666;
            cursor: not-allowed;
            transform: none;
            box-shadow: none;
        }

        .btn-primary:disabled:hover {
            background: #ccc;
            color: #666;
            transform: none;
            box-shadow: none;
        }

        .btn-outline {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            padding: 10px 20px;
            background: transparent;
            color: var(--primary);
            border: 2px solid var(--primary);
            border-radius: 8px;
            text-decoration: none;
            font-weight: 500;
            transition: all 0.2s;
        }

        .btn-outline:hover {
            background: var(--primary);
            color: white;
        }

        /* Alerts */
        .alert {
            padding: 16px 20px;
            border-radius: 10px;
            margin-bottom: 24px;
            display: flex;
            align-items: center;
            gap: 12px;
            animation: slideDown 0.3s ease-out;
        }

        .alert-success {
            background: #d4edda;
            border-left: 4px solid var(--success);
            color: #155724;
        }

        .alert-danger {
            background: #f8d7da;
            border-left: 4px solid var(--danger);
            color: #721c24;
        }

        .alert-warning {
            background: #fff3cd;
            border-left: 4px solid var(--warning);
            color: #856404;
        }

        .alert-info {
            background: #d1ecf1;
            border-left: 4px solid #17a2b8;
            color: #0c5460;
        }

        @keyframes slideDown {
            from {
                opacity: 0;
                transform: translateY(-20px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* Chat Styles */
        .chat-disabled-notice {
            position: fixed;
            bottom: 90px;
            right: 20px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 15px 20px;
            border-radius: 15px;
            box-shadow: 0 5px 20px rgba(0, 0, 0, 0.2);
            max-width: 300px;
            z-index: 9999;
            display: none;
        }

        .chat-disabled-notice.show {
            display: block;
            animation: slideInRight 0.3s ease-out;
        }

        @keyframes slideInRight {
            from {
                transform: translateX(400px);
                opacity: 0;
            }

            to {
                transform: translateX(0);
                opacity: 1;
            }
        }

        .chat-bubble-disabled {
            position: fixed;
            bottom: 20px;
            right: 20px;
            width: 60px;
            height: 60px;
            background: #ccc;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: not-allowed;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
            z-index: 9998;
        }

        .chat-bubble-disabled i {
            font-size: 24px;
            color: #666;
        }

        @keyframes pulse {
            0% {
                transform: scale(1);
            }

            50% {
                transform: scale(1.05);
            }

            100% {
                transform: scale(1);
            }
        }

        @keyframes slideUp {
            from {
                opacity: 1;
                transform: translateY(0);
            }

            to {
                opacity: 0;
                transform: translateY(-20px);
            }
        }
    </style>
</head>

<body
    <?php if ($admin_has_subscription && (!isset($admin_suspended['suspended']) || !$admin_suspended['suspended'])): ?>
    data-user-type="penghuni"
    data-user-id="<?= $user->id_penghuni ?>"
    data-user-name="<?= htmlspecialchars($user->nama_penghuni) ?>"
    data-user-avatar=""
    data-admin-id="<?= isset($admin_suspended['admin_id']) ? $admin_suspended['admin_id'] : '' ?>"
    data-admin-name="<?= isset($admin_suspended['admin_name']) ? htmlspecialchars($admin_suspended['admin_name']) : 'Admin' ?>"
    data-admin-avatar=""
    data-ws-url="ws://localhost:3001"
    data-api-url="<?= site_url('user/Chat_v2') ?>"
    <?php endif; ?>>

    <!-- Topbar - SAMA PERSIS DENGAN PROFIL.PHP -->
    <div class="topbar">
        <div class="topbar-content">
            <div class="brand">
                <div class="login-icon">
                    <img src="<?= base_url('asset/logo.png'); ?>" alt="Logo KosCare" style="width: 50px; height: auto;">
                </div>
                <span>KosCare</span>
            </div>

            <div class="user-menu">
                <div class="user-info-badge">
                    <div class="user-avatar">
                        <?= strtoupper(substr($user->nama_penghuni, 0, 1)) ?>
                    </div>
                    <div>
                        <div style="font-weight: 600; font-size: 0.9rem;"><?= $user->nama_penghuni ?></div>
                        <div style="font-size: 0.75rem; color: var(--secondary);">Penghuni</div>
                    </div>
                </div>

                <a href="<?= site_url('user/login/logout') ?>" class="logout-btn">
                    <i class="fas fa-sign-out-alt"></i>
                    <span>Logout</span>
                </a>
            </div>
        </div>
    </div>

    <!-- Sidebar - SAMA PERSIS DENGAN PROFIL.PHP -->
    <div class="sidebar">
        <nav class="nav-section">
            <div class="nav-title">Menu Utama</div>

            <div class="nav-item">
                <a href="<?= site_url('user/dashboard') ?>" class="nav-link active">
                    <i class="fas fa-home"></i>
                    <span>Dashboard</span>
                </a>
            </div>

            <div class="nav-item">
                <a href="<?= site_url('user/dashboard/laporan') ?>" class="nav-link <?= isset($admin_suspended['suspended']) && $admin_suspended['suspended'] ? 'disabled-action' : '' ?>">
                    <i class="fas fa-clipboard-list"></i>
                    <span class="<?= isset($admin_suspended['suspended']) && $admin_suspended['suspended'] ? 'disabled-action-text' : '' ?>">Laporan Saya</span>
                    <?php if (isset($admin_suspended['suspended']) && $admin_suspended['suspended']): ?>
                        <span style="margin-left: auto; font-size: 0.7rem; color: var(--danger);">
                            <i class="fas fa-ban"></i>
                        </span>
                    <?php endif; ?>
                </a>
            </div>

            <div class="nav-item">
                <a href="<?= site_url('user/dashboard/tambah') ?>" class="nav-link <?= isset($admin_suspended['suspended']) && $admin_suspended['suspended'] ? 'disabled-action' : '' ?>">
                    <i class="fas fa-plus-circle"></i>
                    <span class="<?= isset($admin_suspended['suspended']) && $admin_suspended['suspended'] ? 'disabled-action-text' : '' ?>">Buat Laporan</span>
                    <?php if (isset($admin_suspended['suspended']) && $admin_suspended['suspended']): ?>
                        <span style="margin-left: auto; font-size: 0.7rem; color: var(--danger);">
                            <i class="fas fa-ban"></i>
                        </span>
                    <?php endif; ?>
                </a>
            </div>
        </nav>

        <nav class="nav-section">
            <div class="nav-title">Pengaturan</div>

            <div class="nav-item">
                <a href="<?= site_url('user/dashboard/profile') ?>" class="nav-link">
                    <i class="fas fa-user"></i>
                    <span>Profil Saya</span>
                </a>
            </div>
        </nav>
    </div>

    <!-- Main Content -->
    <div class="main-content">

        <!-- Alerts -->
        <?php if ($this->session->flashdata('success')): ?>
            <div class="alert alert-success">
                <i class="fas fa-check-circle"></i>
                <span><?= $this->session->flashdata('success') ?></span>
            </div>
        <?php endif; ?>

        <?php if ($this->session->flashdata('error')): ?>
            <div class="alert alert-danger">
                <i class="fas fa-exclamation-circle"></i>
                <span><?= $this->session->flashdata('error') ?></span>
            </div>
        <?php endif; ?>

        <!-- Admin Suspended Alert -->
        <?php if (isset($admin_suspended['suspended']) && $admin_suspended['suspended']): ?>
            <div class="admin-suspended-alert <?= $admin_suspended['type'] ?>">
                <div class="admin-suspended-content">
                    <div class="admin-suspended-icon">
                        <?php if ($admin_suspended['type'] == 'permanent'): ?>
                            <i class="fas fa-ban text-danger"></i>
                        <?php else: ?>
                            <i class="fas fa-clock text-warning"></i>
                        <?php endif; ?>
                    </div>
                    <div class="admin-suspended-details">
                        <h4>
                            <?php if ($admin_suspended['type'] == 'permanent'): ?>
                                <i class="fas fa-exclamation-triangle"></i> Admin Dinonaktifkan Permanen
                            <?php else: ?>
                                <i class="fas fa-clock"></i> Admin Dinonaktifkan Sementara
                            <?php endif; ?>
                        </h4>

                        <?php if ($admin_suspended['type'] == 'permanent'): ?>
                            <p><strong>Admin pengelola kos Anda telah dinonaktifkan permanen.</strong></p>
                            <p>Fitur pengajuan laporan dan chat saat ini tidak tersedia.</p>
                            <p><strong>Alasan:</strong> <?= $admin_suspended['reason'] ?></p>
                            <p><small>Hubungi Super Admin untuk informasi lebih lanjut.</small></p>
                        <?php else: ?>
                            <p><strong>Admin pengelola kos sedang dinonaktifkan sementara.</strong></p>
                            <p>Fitur pengajuan laporan akan tersedia kembali pada:</p>
                            <p><strong><?= date('d M Y H:i', strtotime($admin_suspended['until'])) ?></strong></p>
                            <div class="suspended-timer">
                                <i class="fas fa-hourglass-half"></i>
                                <span>Sisa waktu: <?= $admin_suspended['days_left'] ?> hari</span>
                            </div>
                            <p style="margin-top: 10px;"><strong>Alasan:</strong> <?= $admin_suspended['reason'] ?></p>
                            <p><small>Anda tetap dapat melihat laporan yang sudah diajukan sebelumnya.</small></p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <!-- Chat Disabled Notice -->
        <?php if (!$admin_has_subscription && (!isset($admin_suspended['suspended']) || !$admin_suspended['suspended'])): ?>
            <div class="alert alert-info">
                <i class="fas fa-info-circle"></i>
                <strong>Chat Feature Unavailable</strong><br>
                The chat feature is currently unavailable. Please contact your boarding house administrator.
            </div>
        <?php endif; ?>

        <!-- Welcome Section -->
        <div class="welcome-section">
            <h1>Selamat Datang, <?= $user->nama_penghuni ?>! 👋</h1>
            <p>Kelola laporan dan informasi kamar kost Anda dengan mudah</p>

            <div class="room-badge">
                <i class="fas fa-door-open"></i>
                <span>Kamar: <strong><?= $user->kamar ?: 'Belum ada kamar' ?></strong></span>
                <?php if (!empty($user->nama_kos)): ?>
                    <span style="margin-left: 10px; opacity: 0.8;">
                        <i class="fas fa-building"></i> <?= $user->nama_kos ?>
                    </span>
                <?php endif; ?>
            </div>
        </div>

        <!-- Iklan Section -->
        <?php if (!empty($iklan)): ?>
            <div class="iklan-section">
                <div class="content-card">

                    <div class="card-header">
                        <h2 class="card-title">
                            <i class="fas fa-bullhorn"></i>
                            <span>Informasi & Promo</span>
                        </h2>
                    </div>

                    <div class="iklan-grid">
                        <?php
                        usort($iklan, function ($a, $b) {
                            return (int)($a->urutan ?? 999) - (int)($b->urutan ?? 999);
                        });
                        ?>

                        <?php foreach ($iklan as $item): ?>
                            <div class="iklan-card"
                                onclick="<?= $item->link ? "window.open('{$item->link}', '_blank')" : 'return false;' ?>">

                                <span class="iklan-badge">
                                    <i class="fas fa-star"></i> Promo
                                </span>

                                <div class="iklan-image">
                                    <?php if (!empty($item->gambar)): ?>
                                        <img src="<?= base_url('asset/iklan/' . $item->gambar) ?>"
                                            alt="<?= $item->judul ?>">
                                    <?php else: ?>
                                        <i class="fas fa-image"></i>
                                    <?php endif; ?>
                                </div>

                                <div class="iklan-content">
                                    <h3 class="iklan-title"><?= $item->judul ?></h3>

                                    <?php if (!empty($item->deskripsi)): ?>
                                        <p class="iklan-description"><?= $item->deskripsi ?></p>
                                    <?php endif; ?>

                                    <?php if (!empty($item->link)): ?>
                                        <a href="<?= $item->link ?>" target="_blank"
                                            class="iklan-link"
                                            onclick="event.stopPropagation();">

                                            <span>Selengkapnya</span>
                                            <i class="fas fa-arrow-right"></i>
                                        </a>
                                    <?php endif; ?>
                                </div>

                            </div>
                        <?php endforeach; ?>
                    </div>

                </div>
            </div>
        <?php endif; ?>

        <!-- Quick Action -->
        <div style="margin-bottom:32px;">
            <?php if (isset($admin_suspended['suspended']) && $admin_suspended['suspended']): ?>
                <button class="btn-primary" disabled style="position: relative;">
                    <i class="fas fa-ban"></i>
                    <span>Tidak Dapat Buat Laporan</span>
                    <div style="position: absolute; top: -5px; right: -5px; background: var(--danger); color: white; border-radius: 50%; width: 20px; height: 20px; display: flex; align-items: center; justify-content: center; font-size: 0.7rem;">
                        <i class="fas fa-exclamation"></i>
                    </div>
                </button>
                <div style="margin-top: 10px; font-size: 0.9rem; color: var(--secondary);">
                    <?php if ($admin_suspended['type'] == 'permanent'): ?>
                        <i class="fas fa-info-circle"></i> Hubungi Super Admin untuk informasi lebih lanjut.
                    <?php else: ?>
                        <i class="fas fa-clock"></i> Anda dapat membuat laporan lagi dalam <?= $admin_suspended['days_left'] ?> hari.
                    <?php endif; ?>
                </div>
            <?php else: ?>
                <a href="<?= site_url('user/dashboard/tambah') ?>" class="btn-primary">
                    <i class="fas fa-plus"></i>
                    <span>Buat Laporan Baru</span>
                </a>
            <?php endif; ?>
        </div>

        <!-- Stats -->
        <div class="stats-grid">

            <div class="stat-card">
                <div class="stat-header">
                    <div>
                        <div class="stat-value"><?= $stats['total_laporan'] ?></div>
                        <div class="stat-label">Total Laporan</div>
                    </div>
                    <div class="stat-icon"><i class="fas fa-clipboard-list"></i></div>
                </div>
            </div>

            <div class="stat-card warning">
                <div class="stat-header">
                    <div>
                        <div class="stat-value"><?= $stats['laporan_pending'] ?></div>
                        <div class="stat-label">Menunggu Proses</div>
                    </div>
                    <div class="stat-icon"><i class="fas fa-clock"></i></div>
                </div>
            </div>

            <div class="stat-card">
                <div class="stat-header">
                    <div>
                        <div class="stat-value"><?= $stats['laporan_proses'] ?></div>
                        <div class="stat-label">Sedang Diproses</div>
                    </div>
                    <div class="stat-icon"><i class="fas fa-spinner"></i></div>
                </div>
            </div>

            <div class="stat-card success">
                <div class="stat-header">
                    <div>
                        <div class="stat-value"><?= $stats['laporan_selesai'] ?></div>
                        <div class="stat-label">Selesai</div>
                    </div>
                    <div class="stat-icon"><i class="fas fa-check-circle"></i></div>
                </div>
            </div>

        </div>

        <!-- Recent Reports -->
        <div class="content-card">
            <div class="card-header">
                <h2 class="card-title">
                    <i class="fas fa-history"></i>
                    <span>Laporan Terbaru</span>
                </h2>

                <?php if (!empty($laporan) && (!isset($admin_suspended['suspended']) || !$admin_suspended['suspended'])): ?>
                    <a href="<?= site_url('user/dashboard/laporan') ?>" class="btn-outline">
                        <span>Lihat Semua</span>
                        <i class="fas fa-arrow-right"></i>
                    </a>
                <?php endif; ?>
            </div>

            <?php if (!empty($laporan)): ?>
                <div class="report-list">
                    <?php foreach (array_slice($laporan, 0, 5) as $item): ?>
                        <div class="report-item status-<?= strtolower($item->status) ?>">

                            <div class="report-header">
                                <div>
                                    <div class="report-title"><?= $item->judul ?></div>
                                    <div class="report-time">
                                        <i class="far fa-clock"></i>
                                        <?= date('d M Y, H:i', strtotime($item->tanggal_laporan)) ?>
                                    </div>
                                </div>

                                <span class="status-badge <?= strtolower($item->status) ?>"><?= $item->status ?></span>
                            </div>

                        </div>
                    <?php endforeach; ?>
                </div>

            <?php else: ?>

                <div class="empty-state">
                    <div class="empty-state-icon"><i class="fas fa-inbox"></i></div>
                    <div class="empty-state-title">Belum Ada Laporan</div>
                    <div class="empty-state-text">
                        <?php if (isset($admin_suspended['suspended']) && $admin_suspended['suspended']): ?>
                            Tidak dapat membuat laporan saat admin sedang dinonaktifkan.
                        <?php else: ?>
                            Anda belum membuat laporan apapun.
                        <?php endif; ?>
                    </div>

                    <?php if (!isset($admin_suspended['suspended']) || !$admin_suspended['suspended']): ?>
                        <a href="<?= site_url('user/dashboard/tambah') ?>" class="btn-primary">
                            <i class="fas fa-plus"></i>
                            <span>Buat Laporan Pertama</span>
                        </a>
                    <?php endif; ?>
                </div>

            <?php endif; ?>
        </div>
    </div>

    <!-- Chat Bubble - Only if admin has subscription and not suspended -->
    <?php if ($admin_has_subscription && (!isset($admin_suspended['suspended']) || !$admin_suspended['suspended'])): ?>
        <!-- Chat bubble will be created by JavaScript -->
    <?php else: ?>
        <!-- Disabled Chat Bubble -->
        <div class="chat-bubble-disabled" id="chatBubbleDisabled">
            <?php if (isset($admin_suspended['suspended']) && $admin_suspended['suspended']): ?>
                <i class="fas fa-ban"></i>
            <?php else: ?>
                <i class="fas fa-lock"></i>
            <?php endif; ?>
        </div>

        <!-- Chat Disabled Notice -->
        <div class="chat-disabled-notice" id="chatDisabledNotice">
            <h6 style="margin: 0 0 5px 0;">
                <?php if (isset($admin_suspended['suspended']) && $admin_suspended['suspended']): ?>
                    <i class="fas fa-ban"></i> Chat Tidak Tersedia
                <?php else: ?>
                    <i class="fas fa-lock"></i> Chat Unavailable
                <?php endif; ?>
            </h6>
            <p style="margin: 0; font-size: 13px;">
                <?php if (isset($admin_suspended['suspended']) && $admin_suspended['suspended']): ?>
                    Chat tidak tersedia saat admin sedang dinonaktifkan.
                <?php else: ?>
                    Your admin hasn't activated the chat feature yet.
                <?php endif; ?>
            </p>
        </div>
    <?php endif; ?>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

    <?php if ($admin_has_subscription && (!isset($admin_suspended['suspended']) || !$admin_suspended['suspended'])): ?>
        <!-- Chat System Scripts - Only load if admin has subscription and not suspended -->
        <script src="<?= base_url('asset/js/chat_system.js') ?>"></script>
        <script src="<?= base_url('asset/js/user_chat.js') ?>"></script>
        <script src="<?= base_url('asset/js/chat_init.js') ?>"></script>
    <?php else: ?>
        <script>
            // Disable click on disabled menu items - SAMA PERSIS DENGAN PROFIL.PHP
            document.addEventListener('DOMContentLoaded', function() {
                const alerts = document.querySelectorAll('.alert');
                alerts.forEach(alert => {
                    setTimeout(() => {
                        alert.style.animation = 'slideUp 0.3s ease-out';
                        setTimeout(() => alert.remove(), 300);
                    }, 5000);
                });

                document.querySelectorAll('.disabled-action').forEach(item => {
                    item.addEventListener('click', function(e) {
                        e.preventDefault();
                        e.stopPropagation();

                        const alertMsg = document.createElement('div');
                        alertMsg.className = 'alert alert-warning';
                        alertMsg.style.position = 'fixed';
                        alertMsg.style.top = '80px';
                        alertMsg.style.right = '20px';
                        alertMsg.style.zIndex = '9999';
                        alertMsg.style.maxWidth = '300px';
                        alertMsg.innerHTML = `
                            <i class="fas fa-exclamation-triangle"></i>
                            <span>Fitur ini tidak tersedia saat admin dinonaktifkan.</span>
                        `;

                        document.body.appendChild(alertMsg);

                        setTimeout(() => {
                            alertMsg.style.opacity = '0';
                            alertMsg.style.transition = 'opacity 0.5s';
                            setTimeout(() => alertMsg.remove(), 500);
                        }, 3000);
                    });
                });

                // Auto-refresh untuk cek status admin setiap 5 menit
                setTimeout(() => {
                    location.reload();
                }, 300000);
            });
        </script>
    <?php endif; ?>

    <script>
        // Active state untuk sidebar
        document.addEventListener('DOMContentLoaded', function() {
            const currentPath = window.location.pathname;
            const navLinks = document.querySelectorAll('.nav-link');

            // Reset semua active
            navLinks.forEach(link => {
                link.classList.remove('active');
            });

            // Set active berdasarkan halaman saat ini
            if (currentPath.includes('/dashboard/profile')) {
                document.querySelector('a[href*="profile"]').classList.add('active');
            } else if (currentPath.includes('/dashboard/laporan')) {
                document.querySelector('a[href*="laporan"]').classList.add('active');
            } else if (currentPath.includes('/dashboard/tambah')) {
                document.querySelector('a[href*="tambah"]').classList.add('active');
            } else {
                document.querySelector('a[href*="/user/dashboard"]').classList.add('active');
            }
        });
    </script>
</body>

</html>