<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>Laporan Saya - KosCare</title>
    <link rel="stylesheet" href="<?= base_url('asset/css/bootstrap.min.css') ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <style>
        :root {
            --primary: #4a90e2;
            --primary-dark: #357abd;
            --secondary: #64748b;
            --success: #28a745;
            --warning: #ffc107;
            --danger: #dc3545;
            --info: #17a2b8;
            --light: #f8fafc;
            --dark: #0f172a;
            --border: #e2e8f0;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: #f0f8ff;
            color: var(--dark);
            line-height: 1.6;
        }

        /* Topbar */
        .topbar {
            background: white;
            padding: 16px 0;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            z-index: 1030;
            border-bottom: 1px solid var(--border);
        }

        .topbar-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 0 24px;
        }

        .brand {
            display: flex;
            align-items: center;
            gap: 12px;
            font-size: 1.25rem;
            font-weight: 700;
            color: var(--primary);
        }

        .brand i {
            font-size: 1.5rem;
        }

        .user-menu {
            display: flex;
            align-items: center;
            gap: 16px;
        }

        .user-info-badge {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 8px 16px;
            background: var(--light);
            border-radius: 8px;
            font-size: 0.9rem;
        }

        .user-avatar {
            width: 36px;
            height: 36px;
            border-radius: 50%;
            background: var(--primary);
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 600;
        }

        .logout-btn {
            padding: 8px 16px;
            background: var(--danger);
            color: white;
            border: none;
            border-radius: 8px;
            text-decoration: none;
            transition: all 0.2s;
            font-size: 0.9rem;
            display: inline-flex;
            align-items: center;
            gap: 8px;
        }

        .logout-btn:hover {
            background: #dc2626;
            color: white;
            transform: translateY(-1px);
        }

        /* Sidebar */
        .sidebar {
            background: white;
            width: 260px;
            height: calc(100vh - 65px);
            position: fixed;
            top: 65px;
            left: 0;
            padding: 24px 0;
            box-shadow: 1px 0 3px rgba(0, 0, 0, 0.05);
            overflow-y: auto;
            border-right: 1px solid var(--border);
        }

        .nav-section {
            padding: 0 16px;
            margin-bottom: 24px;
        }

        .nav-title {
            font-size: 0.75rem;
            font-weight: 600;
            text-transform: uppercase;
            color: var(--secondary);
            margin-bottom: 12px;
            letter-spacing: 0.5px;
        }

        .nav-item {
            margin-bottom: 4px;
        }

        .nav-link {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 12px 16px;
            color: var(--secondary);
            text-decoration: none;
            border-radius: 8px;
            transition: all 0.2s;
            font-size: 0.95rem;
        }

        .nav-link:hover {
            background: var(--light);
            color: var(--primary);
        }

        .nav-link.active {
            background: var(--primary);
            color: white;
        }

        .nav-link i {
            width: 20px;
            text-align: center;
        }

        /* Main Content */
        .main-content {
            margin-left: 260px;
            margin-top: 65px;
            padding: 32px;
            min-height: calc(100vh - 65px);
        }

        /* Page Header */
        .page-header {
            background: linear-gradient(135deg, var(--primary) 0%, var(--primary-dark) 100%);
            padding: 32px;
            border-radius: 16px;
            margin-bottom: 32px;
            box-shadow: 0 4px 6px rgba(37, 99, 235, 0.1);
            color: white;
        }

        .page-header h1 {
            font-size: 1.875rem;
            font-weight: 700;
            margin-bottom: 8px;
        }

        .page-header p {
            font-size: 1rem;
            opacity: 0.9;
        }

        /* Alerts */
        .alert {
            padding: 16px 20px;
            border-radius: 10px;
            margin-bottom: 24px;
            display: flex;
            align-items: center;
            gap: 12px;
            animation: slideDown 0.3s ease-out;
        }

        .alert-success {
            background: #d4edda;
            border-left: 4px solid var(--success);
            color: #155724;
        }

        .alert-danger {
            background: #f8d7da;
            border-left: 4px solid var(--danger);
            color: #721c24;
        }

        @keyframes slideDown {
            from {
                opacity: 0;
                transform: translateY(-20px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* Content Card */
        .content-card {
            background: white;
            border-radius: 12px;
            padding: 24px;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
            border: 1px solid var(--border);
            margin-bottom: 24px;
        }

        .card-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 24px;
            padding-bottom: 16px;
            border-bottom: 1px solid var(--border);
        }

        .card-title {
            font-size: 1.125rem;
            font-weight: 600;
            color: var(--dark);
            display: flex;
            align-items: center;
            gap: 8px;
        }

        /* Table Styles */
        .table-responsive {
            overflow-x: auto;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
        }

        .table thead th {
            background: var(--light);
            padding: 14px 16px;
            text-align: left;
            font-weight: 600;
            color: var(--dark);
            font-size: 0.875rem;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            border-bottom: 2px solid var(--border);
        }

        .table tbody td {
            padding: 16px;
            border-bottom: 1px solid var(--border);
            vertical-align: middle;
            color: var(--secondary);
        }

        .table tbody tr {
            transition: all 0.2s;
        }

        .table tbody tr:hover {
            background: var(--light);
        }

        /* Status Badges */
        .status-badge {
            display: inline-flex;
            align-items: center;
            gap: 6px;
            padding: 6px 12px;
            border-radius: 20px;
            font-size: 0.75rem;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .status-badge.diajukan {
            background: #fff3cd;
            color: #856404;
        }

        .status-badge.diproses {
            background: #cce5ff;
            color: #004085;
        }

        .status-badge.selesai {
            background: #d4edda;
            color: #155724;
        }

        /* Buttons */
        .btn {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            padding: 10px 20px;
            border: none;
            border-radius: 8px;
            text-decoration: none;
            font-weight: 500;
            font-size: 0.9rem;
            transition: all 0.2s;
            cursor: pointer;
        }

        .btn-primary {
            background: var(--primary);
            color: white;
        }

        .btn-primary:hover {
            background: var(--primary-dark);
            color: white;
            transform: translateY(-2px);
            box-shadow: 0 4px 6px rgba(37, 99, 235, 0.2);
        }

        .btn-sm {
            padding: 8px 12px;
            font-size: 0.85rem;
        }

        .btn-info {
            background: var(--info);
            color: white;
        }

        .btn-info:hover {
            background: #138496;
        }

        .btn-warning {
            background: var(--warning);
            color: var(--dark);
        }

        .btn-warning:hover {
            background: #e0a800;
        }

        .btn-danger {
            background: var(--danger);
            color: white;
        }

        .btn-danger:hover {
            background: #c82333;
        }

        .btn-secondary {
            background: var(--secondary);
            color: white;
            cursor: not-allowed;
            opacity: 0.6;
        }

        .btn-group {
            display: flex;
            gap: 6px;
        }

        /* Empty State */
        .empty-state {
            text-align: center;
            padding: 64px 24px;
        }

        .empty-state-icon {
            font-size: 4rem;
            color: var(--border);
            margin-bottom: 16px;
        }

        .empty-state-title {
            font-size: 1.125rem;
            font-weight: 600;
            color: var(--secondary);
            margin-bottom: 8px;
        }

        .empty-state-text {
            color: var(--secondary);
            margin-bottom: 24px;
        }

        /* Responsive */
        @media (max-width: 768px) {
            .sidebar {
                transform: translateX(-100%);
            }

            .main-content {
                margin-left: 0;
                padding: 16px;
            }

            .topbar-content {
                padding: 0 16px;
            }

            .user-info-badge {
                display: none;
            }

            .table {
                font-size: 0.85rem;
            }

            .table thead th,
            .table tbody td {
                padding: 10px;
            }
        }

        /* Scrollbar */
        .sidebar::-webkit-scrollbar {
            width: 6px;
        }

        .sidebar::-webkit-scrollbar-track {
            background: transparent;
        }

        .sidebar::-webkit-scrollbar-thumb {
            background: var(--border);
            border-radius: 3px;
        }

        .sidebar::-webkit-scrollbar-thumb:hover {
            background: var(--secondary);
        }
    </style>
</head>

<body>
    <!-- Topbar -->
    <div class="topbar">
        <div class="topbar-content">
            <div class="brand">
                <div class="login-icon">
                    <img src="<?= base_url('asset/logo.png'); ?>" alt="Logo KosCare" style="width: 50px; height: auto;">
                </div>
                <span>KosCare</span>
            </div>
            <div class="user-menu">
                <div class="user-info-badge">
                    <div class="user-avatar">
                        <?= strtoupper(substr($user->nama_penghuni, 0, 1)) ?>
                    </div>
                    <div>
                        <div style="font-weight: 600; font-size: 0.9rem;"><?= $user->nama_penghuni ?></div>
                        <div style="font-size: 0.75rem; color: var(--secondary);">Penghuni</div>
                    </div>
                </div>
                <a href="<?= site_url('user/login/logout') ?>" class="logout-btn">
                    <i class="fas fa-sign-out-alt"></i>
                    <span>Logout</span>
                </a>
            </div>
        </div>
    </div>

    <!-- Sidebar -->
    <!-- Sidebar -->
    <div class="sidebar">
        <nav class="nav-section">
            <div class="nav-title">Menu Utama</div>
            <div class="nav-item">
                <a href="<?= site_url('user/dashboard') ?>" class="nav-link">
                    <i class="fas fa-home"></i>
                    <span>Dashboard</span>
                </a>
            </div>
            <div class="nav-item">
                <a href="<?= site_url('user/dashboard/laporan_admin') ?>" class="nav-link active">
                    <i class="fas fa-user-shield"></i>
                    <span>Laporan Saya</span>
                </a>
            </div>
            <div class="nav-item">
                <a href="<?= site_url('user/dashboard/tambah') ?>" class="nav-link">
                    <i class="fas fa-plus-circle"></i>
                    <span>Buat Laporan Kos</span>
                </a>
            </div>
            <div class="nav-item">
                <a href="<?= site_url('user/dashboard/tambah_laporan_admin') ?>" class="nav-link">
                    <i class="fas fa-flag"></i>
                    <span>Laporkan Admin</span>
                </a>
            </div>
        </nav>

        <nav class="nav-section">
            <div class="nav-title">Pengaturan</div>
            <div class="nav-item">
                <a href="<?= site_url('user/dashboard/profile') ?>" class="nav-link">
                    <i class="fas fa-user"></i>
                    <span>Profil Saya</span>
                </a>
            </div>
        </nav>
    </div>

    <!-- Main Content -->
    <div class="main-content">
        <!-- Alerts -->
        <?php if ($this->session->flashdata('success')): ?>
            <div class="alert alert-success">
                <i class="fas fa-check-circle"></i>
                <span><?= $this->session->flashdata('success') ?></span>
            </div>
        <?php endif; ?>

        <?php if ($this->session->flashdata('error')): ?>
            <div class="alert alert-danger">
                <i class="fas fa-exclamation-circle"></i>
                <span><?= $this->session->flashdata('error') ?></span>
            </div>
        <?php endif; ?>

        <!-- Page Header -->
        <div class="page-header">
            <h1>📋 Laporan Saya</h1>
            <p>Kelola dan pantau semua laporan yang Anda buat</p>
        </div>

        <!-- Content Card -->
        <div class="content-card">
            <div class="card-header">
                <h2 class="card-title">
                    <i class="fas fa-list"></i>
                    <span>Daftar Laporan</span>
                </h2>
                <a href="<?= site_url('user/dashboard/tambah') ?>" class="btn btn-primary">
                    <i class="fas fa-plus"></i>
                    <span>Buat Laporan Baru</span>
                </a>
            </div>

            <?php if (!empty($laporan)): ?>
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th style="width: 50px;">No</th>
                                <th>Judul</th>
                                <th>Deskripsi</th>
                                <th style="width: 140px;">Status</th>
                                <th style="width: 160px;">Tanggal Laporan</th>
                                <th style="width: 160px;">Tanggal Selesai</th>
                                <th style="width: 180px;">Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($laporan as $index => $item): ?>
                                <tr>
                                    <td style="font-weight: 600; color: var(--dark);"><?= $index + 1 ?></td>
                                    <td style="font-weight: 600; color: var(--dark);">
                                        <?= htmlspecialchars($item->judul) ?>
                                    </td>
                                    <td>
                                        <?php
                                        $deskripsi = htmlspecialchars($item->deskripsi);
                                        echo (strlen($deskripsi) > 60) ? substr($deskripsi, 0, 60) . '...' : $deskripsi;
                                        ?>
                                    </td>
                                    <td>
                                        <?php if ($item->status == 'Diajukan'): ?>
                                            <span class="status-badge diajukan">
                                                <i class="fas fa-clock"></i> Diajukan
                                            </span>
                                        <?php elseif ($item->status == 'Diproses'): ?>
                                            <span class="status-badge diproses">
                                                <i class="fas fa-spinner"></i> Diproses
                                            </span>
                                        <?php else: ?>
                                            <span class="status-badge selesai">
                                                <i class="fas fa-check-circle"></i> Selesai
                                            </span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?= date('d M Y, H:i', strtotime($item->tanggal_laporan)) ?></td>
                                    <td>
                                        <?= $item->tanggal_selesai ? date('d M Y, H:i', strtotime($item->tanggal_selesai)) : '-' ?>
                                    </td>
                                    <td>
                                        <div class="btn-group">
                                            <a href="<?= site_url('user/dashboard/detail/' . $item->id_laporan) ?>"
                                                class="btn btn-sm btn-info"
                                                title="Lihat Detail">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <?php if ($item->status == 'Diajukan'): ?>
                                                <a href="<?= site_url('user/dashboard/edit/' . $item->id_laporan) ?>"
                                                    class="btn btn-sm btn-warning"
                                                    title="Edit">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <a href="<?= site_url('user/dashboard/hapus/' . $item->id_laporan) ?>"
                                                    class="btn btn-sm btn-danger"
                                                    onclick="return confirm('Yakin ingin menghapus laporan ini?')"
                                                    title="Hapus">
                                                    <i class="fas fa-trash"></i>
                                                </a>
                                            <?php else: ?>
                                                <button class="btn btn-sm btn-secondary"
                                                    disabled
                                                    title="Laporan tidak dapat diedit">
                                                    <i class="fas fa-lock"></i>
                                                </button>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            <?php else: ?>
                <div class="empty-state">
                    <div class="empty-state-icon">
                        <i class="fas fa-clipboard-list"></i>
                    </div>
                    <div class="empty-state-title">Belum Ada Laporan</div>
                    <div class="empty-state-text">Anda belum membuat laporan apapun. Klik tombol di atas untuk membuat laporan baru.</div>
                    <a href="<?= site_url('user/dashboard/tambah') ?>" class="btn btn-primary">
                        <i class="fas fa-plus"></i>
                        <span>Buat Laporan Pertama</span>
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <script src="<?= base_url('asset/js/jquery-3.6.0.min.js') ?>"></script>
    <script src="<?= base_url('asset/js/bootstrap.bundle.min.js') ?>"></script>

    <script>
        // Auto hide alerts
        document.addEventListener('DOMContentLoaded', function() {
            const alerts = document.querySelectorAll('.alert');
            alerts.forEach(alert => {
                setTimeout(() => {
                    alert.style.animation = 'slideUp 0.3s ease-out';
                    setTimeout(() => alert.remove(), 300);
                }, 5000);
            });
        });

        const style = document.createElement('style');
        style.textContent = `
            @keyframes slideUp {
                from { opacity: 1; transform: translateY(0); }
                to { opacity: 0; transform: translateY(-20px); }
            }
        `;
        document.head.appendChild(style);
    </script>
</body>

</html>