<!doctype html>
<html lang="id">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Buat Password Baru - KosCare</title>
    <link rel="stylesheet" href="<?= base_url('asset/css/bootstrap.min.css') ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <style>
        /* STYLE TETAP SAMA SEPERTI DI ATAS */
    </style>
</head>

<body>
    <div class="reset-container">
        <div class="reset-card">
            <div class="reset-header">
                <div class="reset-icon">
                    <i class="fas fa-lock"></i>
                </div>
                <h2>Password Baru</h2>
                <p>Buat password yang kuat untuk akun Anda</p>
            </div>

            <div class="reset-body">
                <?php if (isset($user)): ?>
                    <div class="user-info">
                        <div class="user-avatar">
                            <?= strtoupper(substr($user->nama_penghuni, 0, 1)) ?>
                        </div>
                        <div class="user-details">
                            <h5><?= htmlspecialchars($user->nama_penghuni) ?></h5>
                            <p><?= htmlspecialchars($user->email) ?></p>
                        </div>
                    </div>
                <?php endif; ?>

                <!-- HAPUS INPUT HIDDEN TOKEN atau GANTI dengan email -->
                <input type="hidden" name="email" value="<?= htmlspecialchars($this->session->userdata('reset_email')) ?>">

                <form method="post" action="<?= site_url('user/reset_password/process') ?>" id="resetForm">
                    <div class="requirements">
                        <h6><i class="fas fa-shield-alt"></i> Kriteria Password:</h6>
                        <div class="requirement-item invalid" id="reqLength">
                            <i class="fas fa-circle"></i>
                            <span>Minimal 6 karakter</span>
                        </div>
                        <div class="requirement-item invalid" id="reqMatch">
                            <i class="fas fa-circle"></i>
                            <span>Password harus cocok</span>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="password" class="form-label">
                            <i class="fas fa-key"></i> Password Baru
                        </label>
                        <div class="input-group">
                            <i class="fas fa-lock input-icon"></i>
                            <input
                                type="password"
                                name="password"
                                id="password"
                                class="form-control"
                                placeholder="Masukkan password baru"
                                required
                                minlength="6"
                                autocomplete="new-password"
                                autofocus>
                            <i class="fas fa-eye password-toggle" id="togglePassword"></i>
                        </div>
                        <div class="password-strength">
                            <div class="strength-bar" id="strengthBar"></div>
                        </div>
                        <div class="strength-text" id="strengthText"></div>
                    </div>

                    <div class="form-group">
                        <label for="confirm_password" class="form-label">
                            <i class="fas fa-key"></i> Konfirmasi Password
                        </label>
                        <div class="input-group">
                            <i class="fas fa-lock input-icon"></i>
                            <input
                                type="password"
                                name="confirm_password"
                                id="confirm_password"
                                class="form-control"
                                placeholder="Masukkan ulang password baru"
                                required
                                minlength="6"
                                autocomplete="new-password">
                            <i class="fas fa-eye password-toggle" id="toggleConfirmPassword"></i>
                        </div>
                        <div class="password-match" id="passwordMatch"></div>
                    </div>

                    <button type="submit" class="btn-reset" id="submitBtn" disabled>
                        <span>Reset Password</span>
                        <i class="fas fa-check"></i>
                    </button>
                </form>
            </div>
            <div class="reset-footer">
                <a href="<?= site_url('user/login') ?>" class="back-link">
                    <i class="fas fa-arrow-left"></i> Kembali ke Login
                </a>
            </div>
        </div>
    </div>

    <script>
        // Elements
        const passwordInput = document.getElementById('password');
        const confirmInput = document.getElementById('confirm_password');
        const togglePassword = document.getElementById('togglePassword');
        const toggleConfirmPassword = document.getElementById('toggleConfirmPassword');
        const strengthBar = document.getElementById('strengthBar');
        const strengthText = document.getElementById('strengthText');
        const passwordMatch = document.getElementById('passwordMatch');
        const submitBtn = document.getElementById('submitBtn');
        const resetForm = document.getElementById('resetForm');
        const reqLength = document.getElementById('reqLength');
        const reqMatch = document.getElementById('reqMatch');

        // Toggle password visibility
        function togglePasswordVisibility(inputElement, toggleElement) {
            const type = inputElement.getAttribute('type') === 'password' ? 'text' : 'password';
            inputElement.setAttribute('type', type);

            // Toggle icon
            toggleElement.classList.toggle('fa-eye');
            toggleElement.classList.toggle('fa-eye-slash');
        }

        togglePassword.addEventListener('click', () => {
            togglePasswordVisibility(passwordInput, togglePassword);
        });

        toggleConfirmPassword.addEventListener('click', () => {
            togglePasswordVisibility(confirmInput, toggleConfirmPassword);
        });

        // Check password strength
        function checkPasswordStrength(password) {
            let strength = 0;
            let feedback = '';
            let color = '';

            if (password.length >= 6) strength++;
            if (password.length >= 8) strength++;
            if (/[A-Z]/.test(password)) strength++;
            if (/[0-9]/.test(password)) strength++;
            if (/[^A-Za-z0-9]/.test(password)) strength++;

            // Update strength bar
            const width = (strength / 5) * 100;
            strengthBar.style.width = width + '%';

            // Update text and color
            if (password.length === 0) {
                feedback = '';
                color = '';
                strengthBar.className = 'strength-bar';
            } else if (password.length < 6) {
                feedback = 'Terlalu pendek';
                color = 'strength-weak';
            } else if (strength <= 2) {
                feedback = 'Lemah';
                color = 'strength-weak';
            } else if (strength <= 3) {
                feedback = 'Cukup';
                color = 'strength-medium';
            } else {
                feedback = 'Kuat';
                color = 'strength-strong';
            }

            strengthBar.className = 'strength-bar ' + color;
            strengthText.textContent = feedback;
            strengthText.className = 'strength-text ' + color;

            return strength;
        }

        // Check if passwords match
        function checkPasswordMatch() {
            const password = passwordInput.value;
            const confirm = confirmInput.value;

            if (confirm.length === 0) {
                passwordMatch.innerHTML = '';
                passwordMatch.className = 'password-match';
                return false;
            }

            if (password === confirm) {
                passwordMatch.innerHTML = '<i class="fas fa-check-circle"></i> Password cocok';
                passwordMatch.className = 'password-match match-valid';
                return true;
            } else {
                passwordMatch.innerHTML = '<i class="fas fa-times-circle"></i> Password tidak cocok';
                passwordMatch.className = 'password-match match-invalid';
                return false;
            }
        }

        // Update requirements
        function updateRequirements() {
            const password = passwordInput.value;
            const confirm = confirmInput.value;

            // Check length requirement
            if (password.length >= 6) {
                reqLength.innerHTML = '<i class="fas fa-check-circle"></i> Minimal 6 karakter';
                reqLength.className = 'requirement-item valid';
            } else {
                reqLength.innerHTML = '<i class="fas fa-times-circle"></i> Minimal 6 karakter';
                reqLength.className = 'requirement-item invalid';
            }

            // Check match requirement
            if (confirm.length > 0 && password === confirm) {
                reqMatch.innerHTML = '<i class="fas fa-check-circle"></i> Password harus cocok';
                reqMatch.className = 'requirement-item valid';
            } else {
                reqMatch.innerHTML = '<i class="fas fa-times-circle"></i> Password harus cocok';
                reqMatch.className = 'requirement-item invalid';
            }

            // Enable/disable submit button
            const isValid = password.length >= 6 && password === confirm && confirm.length > 0;
            submitBtn.disabled = !isValid;
        }

        // Event listeners
        passwordInput.addEventListener('input', function() {
            checkPasswordStrength(this.value);
            checkPasswordMatch();
            updateRequirements();
        });

        confirmInput.addEventListener('input', function() {
            checkPasswordMatch();
            updateRequirements();
        });

        // Form submission
        resetForm.addEventListener('submit', function(e) {
            const password = passwordInput.value;
            const confirm = confirmInput.value;

            // Final validation
            if (password.length < 6) {
                e.preventDefault();
                alert('Password minimal 6 karakter.');
                passwordInput.focus();
                return;
            }

            if (password !== confirm) {
                e.preventDefault();
                alert('Password dan konfirmasi password tidak cocok.');
                confirmInput.focus();
                return;
            }

            // Show loading state
            submitBtn.classList.add('loading');
            submitBtn.querySelector('span').textContent = 'Memproses...';
            submitBtn.disabled = true;
        });

        // Initialize
        document.addEventListener('DOMContentLoaded', function() {
            passwordInput.focus();
            updateRequirements();
        });

        // Enter key to move between fields
        passwordInput.addEventListener('keypress', function(e) {
            if (e.key === 'Enter') {
                e.preventDefault();
                confirmInput.focus();
            }
        });

        confirmInput.addEventListener('keypress', function(e) {
            if (e.key === 'Enter' && !submitBtn.disabled) {
                e.preventDefault();
                resetForm.requestSubmit();
            }
        });
    </script>
</body>

</html>