<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Verifikasi OTP - KosCare</title>
    <link rel="stylesheet" href="<?= base_url('asset/css/bootstrap.min.css') ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        body {
            background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        .card {
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.2);
            border: none;
            max-width: 450px;
            width: 100%;
        }
        
        .card-header {
            background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
            color: white;
            border-radius: 15px 15px 0 0 !important;
            padding: 30px;
            text-align: center;
        }
        
        .card-body {
            padding: 30px;
        }
        
        .otp-input {
            letter-spacing: 10px;
            font-size: 24px;
            text-align: center;
            font-weight: bold;
        }
        
        .btn-primary {
            background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
            border: none;
            padding: 10px 20px;
            border-radius: 8px;
            width: 100%;
        }
        
        .email-info {
            background-color: #f8f9fa;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
            text-align: center;
        }
        
        .btn-link {
            color: #4a90e2;
            text-decoration: none;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="card">
            <div class="card-header">
                <h3><i class="fas fa-shield-alt"></i> Verifikasi OTP</h3>
                <p class="mb-0">Masukkan 6 digit kode OTP</p>
            </div>
            
            <div class="card-body">
                <div class="email-info">
                    <i class="fas fa-envelope"></i>
                    Kode telah dikirim ke:<br>
                    <strong><?= $email ?></strong>
                </div>
                
                <?php if ($this->session->flashdata('error')): ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <?= $this->session->flashdata('error') ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>
                
                <?php if ($this->session->flashdata('success')): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <?= $this->session->flashdata('success') ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>
                
                <form method="post" action="<?= site_url('user/reset_password/verify_otp') ?>">
                    <div class="mb-4">
                        <label for="otp" class="form-label">Kode OTP (6 digit)</label>
                        <input type="text" class="form-control otp-input" id="otp" name="otp" 
                               maxlength="6" required pattern="\d{6}" 
                               placeholder="000000">
                    </div>
                    
                    <button type="submit" class="btn btn-primary mb-3">
                        <i class="fas fa-check"></i> Verifikasi
                    </button>
                    
                    <div class="text-center">
                        <p class="mb-2">Tidak menerima kode?</p>
                        <a href="<?= site_url('user/reset_password/resend') ?>" class="btn btn-link">
                            <i class="fas fa-redo"></i> Kirim Ulang Kode
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <script src="<?= base_url('asset/js/bootstrap.bundle.min.js') ?>"></script>
    <script>
        // Auto-focus dan auto-move untuk OTP input
        document.getElementById('otp').focus();
        
        document.getElementById('otp').addEventListener('input', function(e) {
            this.value = this.value.replace(/\D/g, '');
            
            if (this.value.length === 6) {
                document.querySelector('button[type="submit"]').focus();
            }
        });
    </script>
</body>
</html>