param(
    [Parameter(Mandatory=$true)]
    [string]$FileListPath
)

# Cek apakah file daftar patch ada
if (-Not (Test-Path $FileListPath)) {
    Write-Host "File list tidak ditemukan: $FileListPath" -ForegroundColor Red
    exit
}

# Nama output
$outputFile = "bundle_output.txt"

# Hapus file lama jika ada
if (Test-Path $outputFile) {
    Remove-Item $outputFile
}

# Ambil root direktori tempat script dijalankan
$rootPath = Get-Location

Write-Host "Root project: $rootPath"
Write-Host "Mengambil file berdasarkan daftar dari: $FileListPath"

# Baca setiap baris di file daftar patch
$paths = Get-Content $FileListPath

foreach ($relativePath in $paths) {
    if ($relativePath.Trim() -eq "") { continue }

    $fullPath = Join-Path $rootPath $relativePath

    # Tulis header untuk tiap file
    Add-Content $outputFile "====================================="
    Add-Content $outputFile "FILE: $relativePath"
    Add-Content $outputFile "FULL PATH: $fullPath"
    Add-Content $outputFile "====================================="
    Add-Content $outputFile ""

    if (Test-Path $fullPath) {
        # Ambil isi file
        $content = Get-Content $fullPath -Raw
        Add-Content $outputFile $content
    } else {
        # Kasih pesan kalau file tidak ada
        Add-Content $outputFile "[FILE TIDAK DITEMUKAN]"
    }

    Add-Content $outputFile "`n`n"
}

Write-Host "Selesai! File digabungkan menjadi: $outputFile" -ForegroundColor Green
